/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tunnel;

import com.tridium.tunnel.TunnelConst;
import com.tridium.tunnel.TunnelException;
import com.tridium.tunnel.TunnelMagicException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Logger;

public class TunnelUtils
implements TunnelConst {
    public static Logger log = Logger.getLogger("tunnel");

    public static int readMessage(DataInputStream in, String prefix) throws IOException {
        int msgType = 0;
        try {
            if (in.read() != MAGIC[0] || in.read() != MAGIC[1] || in.read() != MAGIC[2] || in.read() != MAGIC[3]) {
                System.out.println(prefix + ": Invalid magic");
            }
            msgType = in.read();
            switch (msgType) {
                case 11: {
                    break;
                }
                case 17: {
                    break;
                }
                case 19: {
                    break;
                }
                case 23: {
                    break;
                }
                case 29: {
                    break;
                }
                case 31: {
                    break;
                }
                case 37: {
                    break;
                }
                case 41: {
                    break;
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return msgType;
    }

    public static String readString(DataInputStream in) throws IOException {
        int len = in.readInt();
        if (len == 0) {
            return "";
        }
        byte[] buf = new byte[len];
        in.readFully(buf);
        return new String(buf, "UTF-8");
    }

    public static String readAuthData(DataInputStream in) throws IOException, TunnelException {
        byte[] magic = new byte[4];
        in.readFully(magic);
        if (!Arrays.equals(magic, MAGIC)) {
            throw new TunnelMagicException();
        }
        int messageType = in.read();
        if (messageType != 53) {
            throw new TunnelException(29);
        }
        return TunnelUtils.readString(in);
    }

    public static void writeAuthData(DataOutputStream out, String authData) throws IOException {
        byte[] messageBytes = authData.getBytes();
        out.write(MAGIC);
        out.write(53);
        out.writeInt(messageBytes.length);
        out.write(messageBytes);
    }
}

