/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tunnel.dashboard;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.tunnel.BTunnelService;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.crypto.BTlsCipherSuiteGroup;
import javax.baja.security.crypto.CertManagerFactory;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.BSecurityItemStatus;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.security.auth.x500.X500Principal;

@NiagaraType(agent={@AgentOn(types={"tunnel:TunnelService"})})
public class BTunnelServiceSecurityDashboardProviderAgent
extends BObject
implements BISecurityDashboardProviderAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BTunnelServiceSecurityDashboardProviderAgent.class);
    private static final double CERT_EXPIRY_WARNING_MILLIS = BRelTime.makeDays((int)90).getMillis();
    private static final String SECTION_HEADER = "securityDashboard.sectionHeader";
    private static final String CERT_EXPIRED_PREFIX = "securityDashboard.certificate.expired";
    private static final String CERT_NEAR_EXPIRY_PREFIX = "securityDashboard.certificate.nearExpiry";
    private static final String CERT_NOT_FOUND_PREFIX = "securityDashboard.certificate.notFound";
    private static final String CERT_NOT_YET_VALID_PREFIX = "securityDashboard.certificate.notYetValid";
    private static final String CERT_SELF_SIGNED_PREFIX = "securityDashboard.certificate.selfSigned";
    private static final String CERT_DEFAULT_PREFIX = "securityDashboard.certificate.default";
    private static final String CERT_SIGNED_PREFIX = "securityDashboard.certificate.signed";
    private static final String CERT_ENCRYPTED_PREFIX = "securityDashboard.certificate.encrypted";
    private static final String CERT_UNIQUELY_ENCRYPTED_PREFIX = "securityDashboard.certificate.uniquely.encrypted";
    private static final String CERT_GLOBALLY_ENCRYPTED_PREFIX = "securityDashboard.certificate.globally.encrypted";
    private static final String CERT_VALID_PREFIX = "securityDashboard.certificate.valid";
    private static final String CIPHER_SUITE_PREFIX = "securityDashboard.cipherSuiteGroup";
    private static final String TLS_PREFIX = "securityDashboard.tlsMinProtocol";
    private static final Logger log = Logger.getLogger("tunnel");
    private SecurityDashboardItemBuilder builder;
    private BTunnelService tunnelService;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void setSecurityDashboardItemsSource(BIObject object) {
        this.tunnelService = (BTunnelService)object;
        this.builder = new SecurityDashboardItemBuilder((BIObject)this);
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)SECTION_HEADER);
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.tunnelService.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        items.add(this.getCipherSuiteItem());
        items.add(this.getTlsMinProtocolItem());
        items.addAll(this.getCertificateItems());
        return items;
    }

    private List<SecurityDashboardItem> getCertificateItems() {
        ArrayList<SecurityDashboardItem> items;
        block14: {
            items = new ArrayList<SecurityDashboardItem>();
            String certName = this.tunnelService.getCertAliasAndPassword().getAlias();
            try {
                X509Certificate certificate = BTunnelServiceSecurityDashboardProviderAgent.getCertificate(certName);
                try {
                    certificate.checkValidity();
                    if (BTunnelServiceSecurityDashboardProviderAgent.isNearExpiration(certificate)) {
                        items.add(this.makeItem(BSecurityItemStatus.securityStatusWarning).withSummary(this.getSummaryKey(CERT_NEAR_EXPIRY_PREFIX), new Object[]{certName, certificate.getNotAfter()}).withDescription(BTunnelServiceSecurityDashboardProviderAgent.getDescriptionKey(CERT_NEAR_EXPIRY_PREFIX), new Object[0]));
                    } else {
                        items.add(this.makeItem(BSecurityItemStatus.securityStatusOK).withSummary(this.getSummaryKey(CERT_VALID_PREFIX), new Object[]{certName}).withDescription(BTunnelServiceSecurityDashboardProviderAgent.getDescriptionKey(CERT_VALID_PREFIX), new Object[0]));
                    }
                }
                catch (CertificateExpiredException e) {
                    items.add(this.makeItem(BSecurityItemStatus.securityStatusAlert).withSummary(this.getSummaryKey(CERT_EXPIRED_PREFIX), new Object[]{certName}).withDescription(BTunnelServiceSecurityDashboardProviderAgent.getDescriptionKey(CERT_EXPIRED_PREFIX), new Object[0]));
                }
                catch (CertificateNotYetValidException e) {
                    items.add(this.makeItem(BSecurityItemStatus.securityStatusAlert).withSummary(this.getSummaryKey(CERT_NOT_YET_VALID_PREFIX), new Object[]{certName, certificate.getNotBefore()}).withDescription(BTunnelServiceSecurityDashboardProviderAgent.getDescriptionKey(CERT_NOT_YET_VALID_PREFIX), new Object[0]));
                }
                if (BTunnelServiceSecurityDashboardProviderAgent.isSelfSigned(certificate)) {
                    if ("default".equalsIgnoreCase(certName)) {
                        items.add(this.makeItem(BSecurityItemStatus.securityStatusWarning).withSummary(this.getSummaryKey(CERT_DEFAULT_PREFIX), new Object[0]).withDescription(BTunnelServiceSecurityDashboardProviderAgent.getDescriptionKey(CERT_DEFAULT_PREFIX), new Object[0]));
                    } else {
                        items.add(this.makeItem(BSecurityItemStatus.securityStatusWarning).withSummary(this.getSummaryKey(CERT_SELF_SIGNED_PREFIX), new Object[]{certName}).withDescription(BTunnelServiceSecurityDashboardProviderAgent.getDescriptionKey(CERT_SELF_SIGNED_PREFIX), new Object[0]));
                    }
                } else {
                    items.add(this.makeItem(BSecurityItemStatus.securityStatusOK).withSummary(this.getSummaryKey(CERT_SIGNED_PREFIX), new Object[]{certName}).withDescription(BTunnelServiceSecurityDashboardProviderAgent.getDescriptionKey(CERT_SIGNED_PREFIX), new Object[0]));
                }
                try {
                    ICoreKeyStore keyStore = (ICoreKeyStore)CertManagerFactory.getInstance().getKeyStore();
                    if (CertUtils.isPrivateKeyGloballyEncrypted((String)certName, (ICoreKeyStore)keyStore)) {
                        items.add(this.makeItem(BSecurityItemStatus.securityStatusWarning).withSummary(this.getSummaryKey(CERT_GLOBALLY_ENCRYPTED_PREFIX), new Object[]{certName}).withDescription(BTunnelServiceSecurityDashboardProviderAgent.getDescriptionKey(CERT_ENCRYPTED_PREFIX), new Object[0]));
                        break block14;
                    }
                    items.add(this.makeItem(BSecurityItemStatus.securityStatusOK).withSummary(this.getSummaryKey(CERT_UNIQUELY_ENCRYPTED_PREFIX), new Object[]{certName}).withDescription(BTunnelServiceSecurityDashboardProviderAgent.getDescriptionKey(CERT_ENCRYPTED_PREFIX), new Object[0]));
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "unable to check private key for password", e);
                }
            }
            catch (Exception e) {
                items.add(this.makeItem(BSecurityItemStatus.securityStatusWarning).withSummary(this.getSummaryKey(CERT_NOT_FOUND_PREFIX), new Object[]{certName}).withDescription(BTunnelServiceSecurityDashboardProviderAgent.getDescriptionKey(CERT_NOT_FOUND_PREFIX), new Object[0]));
            }
        }
        return items;
    }

    private SecurityDashboardItem getCipherSuiteItem() {
        BTlsCipherSuiteGroup cipherSuite = this.tunnelService.getCipherSuiteGroup();
        return this.makeItem(BTunnelServiceSecurityDashboardProviderAgent.isCipherSuiteStrong(cipherSuite) ? BSecurityItemStatus.securityStatusOK : BSecurityItemStatus.securityStatusWarning).withSummary(this.getSummaryKey(CIPHER_SUITE_PREFIX), new Object[]{cipherSuite}).withDescription(BTunnelServiceSecurityDashboardProviderAgent.getDescriptionKey(CIPHER_SUITE_PREFIX), new Object[0]);
    }

    private SecurityDashboardItem getTlsMinProtocolItem() {
        BSslTlsEnum tlsVersion = this.tunnelService.getTlsMinProtocol();
        return this.makeItem(BTunnelServiceSecurityDashboardProviderAgent.isTlsVersionStrong(tlsVersion) ? BSecurityItemStatus.securityStatusOK : BSecurityItemStatus.securityStatusWarning).withSummary(this.getSummaryKey(TLS_PREFIX), new Object[]{tlsVersion}).withDescription(BTunnelServiceSecurityDashboardProviderAgent.getDescriptionKey(TLS_PREFIX), new Object[]{BSslTlsEnum.tlsv1_2});
    }

    private SecurityDashboardItemBuilder.ItemBuild makeItem(BSecurityItemStatus status) {
        boolean enabled = this.tunnelService.getEnabled();
        return this.builder.make(enabled ? status : BSecurityItemStatus.securityStatusInfo);
    }

    private String getSummaryKey(String prefix) {
        boolean enabled = this.tunnelService.getEnabled();
        return prefix + (enabled ? ".enabled" : ".disabled") + ".summary";
    }

    private static String getDescriptionKey(String prefix) {
        return prefix + ".description";
    }

    private static X509Certificate getCertificate(String certName) throws Exception {
        return CertManagerFactory.getInstance().getKeyStore().getCertificate(certName);
    }

    private static boolean isCipherSuiteStrong(BTlsCipherSuiteGroup cipherSuite) {
        return cipherSuite == BTlsCipherSuiteGroup.recommended;
    }

    private static boolean isNearExpiration(X509Certificate certificate) {
        return (double)(certificate.getNotAfter().getTime() - new Date().getTime()) < CERT_EXPIRY_WARNING_MILLIS;
    }

    private static boolean isSelfSigned(X509Certificate certificate) {
        return CertUtils.checkDnEquality((X500Principal)certificate.getIssuerX500Principal(), (X500Principal)certificate.getSubjectX500Principal());
    }

    private static boolean isTlsVersionStrong(BSslTlsEnum tlsVersion) {
        return tlsVersion.equals((Object)BSslTlsEnum.tlsv1_2) || tlsVersion.equals((Object)BSslTlsEnum.tlsv1_3);
    }
}

