/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.maxpro.util;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONUtil;
import com.tridium.maxpro.datatypes.BMaxproPanTiltZoomSettings;
import com.tridium.maxpro.enums.BMaxproNormalSpeedEnum;
import com.tridium.maxpro.nvr.BMaxproNvr;
import com.tridium.maxpro.util.Helper;
import com.tridium.ndriver.comm.http.HttpComm;
import com.tridium.ndriver.comm.http.NHttpRequest;
import com.tridium.ndriver.comm.http.NHttpResponse;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.videoDriver.enums.BPlaybackTypeEnum;
import com.tridium.videoDriver.enums.BVideoEventTypesEnum;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import com.tridium.videoDriver.event.BVideoEvent;
import com.tridium.videoDriver.videoStream.BPlaybackParams;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BAbsTime;

public class MaxproHttpUtil {
    public static final String FUSION = "Fusion";
    public static final String MAXPRONVR = "MAXPRONVR";
    public static final String ENTERPRISE = "Enterprise";
    public static final String INTELLEX = "Intellex";
    public static final String PELCO = "Pelco";
    public static final String HRDP = "HRDP";
    public static final String MAX_RECORDER_TYPE_IDENTIFIER = "Max_RecorderTypeIdentifier";
    public static final String GET_PASSWORD_RPC_METHOD_CALL = "getPasswordRpc";
    public static Logger maxpro_log = Logger.getLogger("Maxpro_Log");

    public static JSONObject getAllRecordersConfiguration(HttpComm hcom, BMaxproNvr nvr) throws Exception {
        String uri = "/UVISOM/ISOM/DeviceMgmt/Recorders/Config";
        if (maxpro_log.isLoggable(Level.FINE)) {
            maxpro_log.fine("Get All Recorders Configuration Request");
        }
        NHttpResponse rsp = MaxproHttpUtil.get(hcom, uri, nvr);
        String strRsp = new String(rsp.getData());
        if (maxpro_log.isLoggable(Level.FINE)) {
            maxpro_log.fine("Get All Recorders Configuration Response : " + strRsp);
        }
        JSONArray recorders = new JSONObject(strRsp).getJSONArray("recorderConfig");
        for (int i = 0; i < recorders.length(); ++i) {
            String strTypeIdentifier = JSONUtil.getString((JSONObject)recorders.getJSONObject(i), (String)"recorderType");
            if (strTypeIdentifier.equalsIgnoreCase(MAXPRONVR) || strTypeIdentifier.equalsIgnoreCase(PELCO) || strTypeIdentifier.equalsIgnoreCase(FUSION) || strTypeIdentifier.equalsIgnoreCase(ENTERPRISE) || strTypeIdentifier.equalsIgnoreCase(INTELLEX) || strTypeIdentifier.equalsIgnoreCase(HRDP) || strTypeIdentifier.equalsIgnoreCase(MAX_RECORDER_TYPE_IDENTIFIER)) {
                return recorders.getJSONObject(i).getJSONObject("identifiers");
            }
            maxpro_log.severe("Recorder Type NOT Supported");
        }
        return null;
    }

    public static boolean getCameraState(HttpComm hcom, BMaxproNvr nvr, int cameraId) throws Exception {
        String uri = "/UVISOM/ISOM/DeviceMgmt/Cameras/" + cameraId + "/state";
        NHttpResponse rsp = MaxproHttpUtil.get(hcom, uri, nvr);
        String strRsp = new String(rsp.getData());
        String strState = (String)new JSONObject(strRsp).getJSONObject("activeTroubles").get("videoLoss");
        return !strState.equalsIgnoreCase("true");
    }

    public static JSONArray getAllCamerasConfiguration(HttpComm hcom, BMaxproNvr nvr) throws Exception {
        String uri = "/UVISOM/ISOM/DeviceMgmt/Cameras/Config";
        NHttpResponse rsp = MaxproHttpUtil.get(hcom, uri, nvr);
        String strRsp = new String(rsp.getData());
        return new JSONObject(strRsp).getJSONArray("cameraConfig");
    }

    public static JSONObject createStream(HttpComm hcom, BIpAddress addr, BMaxproNvr nvr, int nCameraId, BPlaybackParams playbackParams) throws Exception {
        String uri = "/UVISOM/ISOM/VideoMgmt/Media/Streams/Config";
        String strdata = "";
        if (playbackParams.getPlaybackType() == BPlaybackTypeEnum.live) {
            strdata = "{\"identifiers\":{},\"protocol\":\"HPS\",\"relation\":[{\"name\":\"StreamRetrievedFromCamera\",\"entityID\":\"" + nCameraId + "\"}],\"retrievalType\":\"Live\"}";
        } else {
            BAbsTime startTime = playbackParams.getTimeIndex();
            String strStartTime = startTime.encodeToString();
            strStartTime = startTime.toUtcTime().encodeToString();
            strStartTime = strStartTime.substring(0, 19) + "Z";
            strdata = "{\"identifiers\": {},\"relation\": [{\"name\": \"StreamRetrievedFromCamera\",\"entityID\": \"" + nCameraId + "\"}],\"protocol\": \" HPS\",\"retrievalType\": \"Playback\",\"playbackParams\": {\"startDateTime\": \"" + strStartTime + "\"}}";
        }
        NHttpResponse rsp = MaxproHttpUtil.post(hcom, addr, uri, nvr, strdata);
        String strRsp = new String(rsp.getData());
        return new JSONObject(strRsp);
    }

    public static NHttpResponse get(HttpComm hcom, String uri, BMaxproNvr nvr) throws Exception {
        String meth = "GET";
        NHttpRequest rqst = new NHttpRequest(nvr.httpAddress(), meth, uri);
        rqst.addBasicAuthorization(nvr.getCredentials().getUsername(), Helper.getPasswordString(nvr, GET_PASSWORD_RPC_METHOD_CALL));
        return hcom.sendRequest(rqst);
    }

    public static NHttpResponse post(HttpComm hcom, BIpAddress addr, String uri, BMaxproNvr nvr, String bufdata) throws Exception {
        String meth = "POST";
        NHttpRequest rqst = new NHttpRequest(addr, meth, uri);
        rqst.addBasicAuthorization(nvr.getCredentials().getUsername(), Helper.getPasswordString(nvr, GET_PASSWORD_RPC_METHOD_CALL));
        rqst.setData(bufdata);
        rqst.addHeader("Accept", "*/*");
        rqst.addHeader("Accept-Language", "en-US");
        rqst.addHeader("Content-Length", "" + bufdata.length());
        rqst.addHeader("Accept-Encoding", "identity");
        rqst.addHeader("LocalAccess", "1");
        rqst.addHeader("Content-Type", "application/json");
        rqst.addHeader("Connection", "Keep-Alive");
        rqst.addHeader("Cache-Control", "no-cache");
        return hcom.sendRequest(rqst);
    }

    public static NHttpResponse put(HttpComm hcom, BIpAddress addr, String uri, BMaxproNvr nvr, String bufdata) throws Exception {
        String meth = "PUT";
        NHttpRequest rqst = new NHttpRequest(addr, meth, uri);
        rqst.addBasicAuthorization(nvr.getCredentials().getUsername(), Helper.getPasswordString(nvr, GET_PASSWORD_RPC_METHOD_CALL));
        rqst.setData(bufdata);
        rqst.addHeader("Accept", "*/*");
        rqst.addHeader("Accept-Language", "en-US");
        rqst.addHeader("Content-Length", "" + bufdata.length());
        rqst.addHeader("Accept-Encoding", "identity");
        rqst.addHeader("LocalAccess", "1");
        rqst.addHeader("Content-Type", "application/json");
        rqst.addHeader("Connection", "Keep-Alive");
        rqst.addHeader("Cache-Control", "no-cache");
        return hcom.sendRequest(rqst);
    }

    public static int[] getPanTiltParams(BMaxproPanTiltZoomSettings ptzSettings, BVideoPanTiltEnum panTiltAction) {
        int panDegrees = 0;
        int tiltDegrees = 0;
        if (panTiltAction == BVideoPanTiltEnum.panRightSlow) {
            panDegrees = -ptzSettings.getPanDegreesSlow();
        } else if (panTiltAction == BVideoPanTiltEnum.panRightMedium) {
            panDegrees = -ptzSettings.getPanDegreesMedium();
        } else if (panTiltAction == BVideoPanTiltEnum.panRightFast) {
            panDegrees = -ptzSettings.getPanDegreesFast();
        } else if (panTiltAction == BVideoPanTiltEnum.panRightTiltDownSlow) {
            panDegrees = -ptzSettings.getPanDegreesSlow();
            tiltDegrees = -ptzSettings.getTiltDegreesSlow();
        } else if (panTiltAction == BVideoPanTiltEnum.panRightTiltDownMedium) {
            panDegrees = -ptzSettings.getPanDegreesMedium();
            tiltDegrees = -ptzSettings.getTiltDegreesMedium();
        } else if (panTiltAction == BVideoPanTiltEnum.panRightTiltDownFast) {
            panDegrees = -ptzSettings.getPanDegreesFast();
            tiltDegrees = -ptzSettings.getTiltDegreesFast();
        } else if (panTiltAction == BVideoPanTiltEnum.tiltDownSlow) {
            tiltDegrees = -ptzSettings.getTiltDegreesSlow();
        } else if (panTiltAction == BVideoPanTiltEnum.tiltDownMedium) {
            tiltDegrees = -ptzSettings.getTiltDegreesMedium();
        } else if (panTiltAction == BVideoPanTiltEnum.tiltDownFast) {
            tiltDegrees = -ptzSettings.getTiltDegreesFast();
        } else if (panTiltAction == BVideoPanTiltEnum.panLeftTiltDownSlow) {
            panDegrees = ptzSettings.getPanDegreesSlow();
            tiltDegrees = -ptzSettings.getTiltDegreesSlow();
        } else if (panTiltAction == BVideoPanTiltEnum.panLeftTiltDownMedium) {
            panDegrees = ptzSettings.getPanDegreesMedium();
            tiltDegrees = -ptzSettings.getTiltDegreesMedium();
        } else if (panTiltAction == BVideoPanTiltEnum.panLeftTiltDownFast) {
            panDegrees = ptzSettings.getPanDegreesFast();
            tiltDegrees = -ptzSettings.getTiltDegreesFast();
        } else if (panTiltAction == BVideoPanTiltEnum.panLeftSlow) {
            panDegrees = ptzSettings.getPanDegreesSlow();
        } else if (panTiltAction == BVideoPanTiltEnum.panLeftMedium) {
            panDegrees = ptzSettings.getPanDegreesMedium();
        } else if (panTiltAction == BVideoPanTiltEnum.panLeftFast) {
            panDegrees = ptzSettings.getPanDegreesFast();
        } else if (panTiltAction == BVideoPanTiltEnum.panLeftTiltUpSlow) {
            panDegrees = ptzSettings.getPanDegreesSlow();
            tiltDegrees = ptzSettings.getTiltDegreesSlow();
        } else if (panTiltAction == BVideoPanTiltEnum.panLeftTiltUpMedium) {
            panDegrees = ptzSettings.getPanDegreesMedium();
            tiltDegrees = ptzSettings.getTiltDegreesMedium();
        } else if (panTiltAction == BVideoPanTiltEnum.panLeftTiltUpFast) {
            panDegrees = ptzSettings.getPanDegreesFast();
            tiltDegrees = ptzSettings.getTiltDegreesFast();
        } else if (panTiltAction == BVideoPanTiltEnum.tiltUpSlow) {
            tiltDegrees = ptzSettings.getTiltDegreesSlow();
        } else if (panTiltAction == BVideoPanTiltEnum.tiltUpMedium) {
            tiltDegrees = ptzSettings.getTiltDegreesMedium();
        } else if (panTiltAction == BVideoPanTiltEnum.tiltUpFast) {
            tiltDegrees = ptzSettings.getTiltDegreesFast();
        } else if (panTiltAction == BVideoPanTiltEnum.panRightTiltUpSlow) {
            panDegrees = -ptzSettings.getPanDegreesSlow();
            tiltDegrees = ptzSettings.getTiltDegreesSlow();
        } else if (panTiltAction == BVideoPanTiltEnum.panRightTiltUpMedium) {
            panDegrees = -ptzSettings.getPanDegreesMedium();
            tiltDegrees = ptzSettings.getTiltDegreesMedium();
        } else if (panTiltAction == BVideoPanTiltEnum.panRightTiltUpFast) {
            panDegrees = -ptzSettings.getPanDegreesFast();
            tiltDegrees = ptzSettings.getTiltDegreesFast();
        } else if (panTiltAction == BVideoPanTiltEnum.none) {
            maxpro_log.severe("pantilt action is none");
            panDegrees = 0;
            tiltDegrees = 0;
        } else {
            throw new IllegalArgumentException("Unsupported panTiltAction: " + panTiltAction);
        }
        return new int[]{panDegrees, tiltDegrees};
    }

    public static int getZoomParams(BMaxproPanTiltZoomSettings ptzSettings, BVideoZoomEnum zoomAction) {
        int zoomIndex = 0;
        if (zoomAction == BVideoZoomEnum.none) {
            zoomIndex = 0;
        } else if (zoomAction == BVideoZoomEnum.reset) {
            zoomIndex = 0;
        } else if (zoomAction == BVideoZoomEnum.zoomInFast) {
            zoomIndex = ptzSettings.getZoomIndexFast();
        } else if (zoomAction == BVideoZoomEnum.zoomInMedium) {
            zoomIndex = ptzSettings.getZoomIndexMedium();
        } else if (zoomAction == BVideoZoomEnum.zoomInSlow) {
            zoomIndex = ptzSettings.getZoomIndexSlow();
        } else if (zoomAction == BVideoZoomEnum.zoomOutFast) {
            zoomIndex = -ptzSettings.getZoomIndexFast();
        } else if (zoomAction == BVideoZoomEnum.zoomOutMedium) {
            zoomIndex = -ptzSettings.getZoomIndexMedium();
        } else if (zoomAction == BVideoZoomEnum.zoomOutSlow) {
            zoomIndex = -ptzSettings.getZoomIndexSlow();
        } else {
            throw new IllegalArgumentException("Unsupported zoomAction: " + zoomAction);
        }
        return zoomIndex;
    }

    public static JSONObject createEventStream(HttpComm hcom, BIpAddress addr, BMaxproNvr nvr) throws Exception {
        String uri = "/UVISOM/ISOM/EventMgmt/EventStreams/config";
        String strData = "{\"session\": {\"protocol\": \"SubscriberGetStream\"}";
        if (maxpro_log.isLoggable(Level.FINE)) {
            maxpro_log.fine("Create Event Stream Request");
        }
        NHttpResponse rsp = MaxproHttpUtil.post(hcom, addr, uri, nvr, strData);
        String strRsp = new String(rsp.getData());
        if (maxpro_log.isLoggable(Level.FINE)) {
            maxpro_log.fine("Create Event Stream  Response : " + strRsp);
        }
        return new JSONObject(strRsp);
    }

    public static JSONArray readEvents(HttpComm hcom, BMaxproNvr nvr, String params) throws Exception {
        String uri = "/UVISOM/ISOM/EventMgmt/EventStreams/" + nvr.getEventStreamId() + "/data?" + params;
        if (maxpro_log.isLoggable(Level.FINE)) {
            maxpro_log.fine("Read Events Request");
        }
        NHttpResponse rsp = MaxproHttpUtil.get(hcom, uri, nvr);
        String strRsp = new String(rsp.getData());
        if (maxpro_log.isLoggable(Level.FINE)) {
            maxpro_log.fine("Read Events Response : " + strRsp);
        }
        return new JSONObject(strRsp).getJSONArray("eventList");
    }

    public static BVideoEvent[] parseEventsResponse(JSONArray eventList, int cameraId) {
        ArrayList<BVideoEvent> events = new ArrayList<BVideoEvent>();
        for (int i = 0; i < eventList.length(); ++i) {
            JSONObject event = eventList.getJSONObject(i);
            String strEntityID = JSONUtil.getString((JSONObject)event, (String)"entityId");
            if (Integer.parseInt(strEntityID) != cameraId) continue;
            try {
                BVideoEvent maxproEvent = BVideoEvent.makeOffNormalEvent();
                maxproEvent.setEventType(BVideoEventTypesEnum.customEvent);
                String strDescription = JSONUtil.getString((JSONObject)event, (String)"description");
                BAbsTime time = BAbsTime.make((String)JSONUtil.getString((JSONObject)event, (String)"timeStamp"));
                maxproEvent.setDescription(strDescription);
                maxproEvent.setTimestamp(time);
                events.add(maxproEvent);
                continue;
            }
            catch (Exception xe) {
                maxpro_log.log(Level.SEVERE, "Failed to Parse Events Response", xe);
            }
        }
        Object[] maxproEvents = new BVideoEvent[events.size()];
        for (int k = 0; k < maxproEvents.length; ++k) {
            maxproEvents[k] = (BVideoEvent)events.get(k);
        }
        SortUtil.sort((Object[])maxproEvents, (Object[])maxproEvents, (Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                BVideoEvent e1 = (BVideoEvent)o1;
                BVideoEvent e2 = (BVideoEvent)o2;
                return e1.getTimestamp().compareTo((Object)e2.getTimestamp());
            }
        });
        return maxproEvents;
    }

    public static void configureFwdRwdSettings(HttpComm hcom, BIpAddress addr, BMaxproNvr nvr, int nCameraId, BPlaybackParams playbackParams, String streamId, BMaxproNormalSpeedEnum normalSpeedEnum, int fastSpeed) {
        String uri = "/UVISOM/ISOM/VideoMgmt/Media/Streams/" + streamId + "/Config";
        String strdata = "";
        boolean playBackType = false;
        String guid = MaxproHttpUtil.getGuidFromStreamId(streamId);
        String speed = MaxproHttpUtil.getSpeedAsString(playbackParams, normalSpeedEnum, fastSpeed);
        playBackType = playbackParams.getPlaybackType() != BPlaybackTypeEnum.slowRew && playbackParams.getPlaybackType() != BPlaybackTypeEnum.fastRew;
        BAbsTime startTime = playbackParams.getTimeIndex();
        String strStartTime = startTime.encodeToString();
        strStartTime = startTime.toUtcTime().encodeToString();
        strStartTime = strStartTime.substring(0, 19) + "Z";
        strdata = "{\"identifiers\":{\"guid\":\"" + guid + "\"},\"relation\": [{\"name\": \"StreamRetrievedFromCamera\",\"entityID\": \"" + nCameraId + "\"}],\"protocol\": \" HPS\",\"retrievalType\": \"Playback\",\"playbackParams\": {\"speed\":\"" + speed + "\",\"forwardDirection\":" + playBackType + "}}";
        NHttpResponse rsp = null;
        try {
            rsp = MaxproHttpUtil.put(hcom, addr, uri, nvr, strdata);
        }
        catch (Exception e) {
            maxpro_log.log(Level.SEVERE, "Failed to configure Fwd/Rwd Settings", e);
        }
    }

    public static String getSpeedAsString(BPlaybackParams playbackParams, BMaxproNormalSpeedEnum normalSpeedEnum, int fastSpeed) {
        double desiredSpeed;
        int playbackSpeed = playbackParams.getPlaybackSpeed().getOrdinal() + 1;
        if (playbackParams.getPlaybackType() == BPlaybackTypeEnum.fastRew || playbackParams.getPlaybackType() == BPlaybackTypeEnum.fastFwd) {
            desiredSpeed = playbackSpeed * fastSpeed;
        } else {
            double normalSpeed = 1.0 / Math.pow(2.0, normalSpeedEnum.getOrdinal());
            desiredSpeed = normalSpeed * Math.pow(2.0, playbackSpeed - 1);
        }
        if (desiredSpeed > 16.0) {
            desiredSpeed = 16.0;
        }
        if (desiredSpeed == 0.125) {
            return "1/8";
        }
        if (desiredSpeed == 0.25) {
            return "1/4";
        }
        if (desiredSpeed == 0.5) {
            return "1/2";
        }
        return "" + (int)desiredSpeed;
    }

    public static String getGuidFromStreamId(String streamId) {
        String strGuid = "";
        int index = streamId.indexOf("~HPS~");
        strGuid = streamId.substring(0, index);
        streamId = streamId.substring(index + 5, streamId.length());
        strGuid = strGuid + "~" + streamId.substring(0, streamId.indexOf("~"));
        return strGuid;
    }
}

