/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.backup;

import com.tridium.backup.BBackupRecord;
import com.tridium.fox.session.Fox;
import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.file.BFileChannel;
import com.tridium.fox.sys.file.BFoxFileStore;
import com.tridium.sys.station.Station;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.baja.backup.BBackupService;
import javax.baja.file.FilePath;
import javax.baja.job.BJob;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="postSessionId", type="String", defaultValue="", flags=4), @NiagaraProperty(name="postPath", type="String", defaultValue="", flags=4)})
public class BFoxBackupJob
extends BSimpleJob {
    @Generated
    public static final Property postSessionId = BFoxBackupJob.newProperty((int)4, (String)"", null);
    @Generated
    public static final Property postPath = BFoxBackupJob.newProperty((int)4, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxBackupJob.class);
    private static final BIcon icon = BIcon.std((String)"backup.png");
    String host;
    FilePath path;
    String user;

    @Generated
    public String getPostSessionId() {
        return this.getString(postSessionId);
    }

    @Generated
    public void setPostSessionId(String v) {
        this.setString(postSessionId, v, null);
    }

    @Generated
    public String getPostPath() {
        return this.getString(postPath);
    }

    @Generated
    public void setPostPath(String v) {
        this.setString(postPath, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        BBackupService service = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
        String sessionId = this.getPostSessionId();
        FoxSession session = Fox.getSession((String)sessionId);
        if (session == null) {
            throw new Exception("Invalid fox session id: " + sessionId);
        }
        Object pauseToken = null;
        try {
            pauseToken = session.pauseSessionTimeout();
            BFoxConnection conn = (BFoxConnection)session.conn();
            BFileChannel chan = conn.getChannels().getFileChannel();
            Context sessionCx = chan.getSessionContext();
            if (!service.getPermissions(sessionCx).has(48)) {
                throw new PermissionException();
            }
            this.host = session.getRemoteHost();
            this.path = new FilePath(this.getPostPath());
            this.user = cx == null ? "unknown" : String.valueOf(cx.getUser());
            this.log().message("Host: " + this.host);
            this.log().message("Path: " + this.path);
            this.log().message("User: " + this.user);
            Station.saveSync((BJob)this, (int)10);
            chan.makeFile(null, this.path);
            OutputStream out = chan.write(new BFoxFileStore(null, this.path));
            service.zip((BJob)this, out, true, null);
            BBackupRecord rec = new BBackupRecord();
            rec.setTimestamp(BAbsTime.make());
            rec.setHost(this.host);
            rec.setPath(this.path.toString());
            rec.setUser(this.user);
            rec.append(service);
        }
        finally {
            session.resumeSessionTimeout(pauseToken);
        }
    }

    public void writeBackupLog(PrintWriter out) {
        out.println("post.host=" + this.host);
        out.println("post.path=" + this.path);
        out.println("post.user=" + this.user);
    }

    public BIcon getIcon() {
        return icon;
    }
}

