/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platDataRecovery.ui;

import com.tridium.platDataRecovery.config.BDataRecoveryConfig;
import com.tridium.platDataRecovery.config.BDataRecoveryFullPolicy;
import com.tridium.platDataRecovery.config.BDataRecoveryPersistenceCapacity;
import com.tridium.platDataRecovery.ui.BDataRecoveryPersistenceCapacityFE;
import com.tridium.ui.theme.Theme;
import com.tridium.util.ObjectUtil;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType
public class BDataRecoveryConfigEditor
extends BWbComponentView {
    @Generated
    public static final Type TYPE = Sys.loadType(BDataRecoveryConfigEditor.class);
    static BImage openIcon = BImage.make((String)"module://icons/x16/open.png");
    static BDirectoryChooser chooser;
    private static final BFont BOLD_TEXT_FONT;
    private static final Lexicon lex;
    private BIntegerFE totalDataRecoverySizeFE = null;
    private BIntegerFE numberDataRecoveryBlocksFE = null;
    private BTextField activeDirectoryFE = null;
    private BButton activeDirButton = null;
    private BTextField persistentDirectoryFE = null;
    private BButton persistentDirButton = null;
    private BFrozenEnumFE activeFullPolicyFE = null;
    private BDataRecoveryPersistenceCapacityFE persistentCapacityFE = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDataRecoveryConfigEditor() {
        this.autoRegisterForComponentEvents = false;
    }

    public void deactivated() {
        super.deactivated();
        this.totalDataRecoverySizeFE = null;
        this.numberDataRecoveryBlocksFE = null;
        this.activeDirectoryFE = null;
        this.activeDirButton = null;
        this.persistentDirectoryFE = null;
        this.persistentDirButton = null;
        this.activeFullPolicyFE = null;
        this.persistentCapacityFE = null;
    }

    protected final void doLoadValue(BObject value, Context cx) {
        BDataRecoveryConfig currentConfig = (BDataRecoveryConfig)value;
        currentConfig.lease(3);
        BGridPane configPane = new BGridPane(2);
        configPane.setValign(BValign.top);
        configPane.setHalign(BHalign.left);
        configPane.setColumnAlign(BHalign.fill);
        configPane.setStretchColumn(1);
        configPane.setColumnGap(10.0);
        configPane.setRowGap(6.0);
        configPane.setColorRows(false);
        this.totalDataRecoverySizeFE = new BIntegerFE();
        BDataRecoveryConfigEditor.addLabelWidgetPair(configPane, BDataRecoveryConfigEditor.text("config.totalSize.label"), BDataRecoveryConfigEditor.left((BWidget)this.totalDataRecoverySizeFE), true);
        this.totalDataRecoverySizeFE.loadValue((BObject)BInteger.make((int)currentConfig.getDataRecoverySize()), (Context)currentConfig.getSlotFacets((Slot)BDataRecoveryConfig.dataRecoverySize));
        this.totalDataRecoverySizeFE.setReadonly(true);
        this.totalDataRecoverySizeFE.setEnabled(false);
        this.linkTo(null, (BComponent)this.totalDataRecoverySizeFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.numberDataRecoveryBlocksFE = new BIntegerFE();
        BDataRecoveryConfigEditor.addLabelWidgetPair(configPane, BDataRecoveryConfigEditor.text("config.numberBlocks.label"), BDataRecoveryConfigEditor.left((BWidget)this.numberDataRecoveryBlocksFE), true);
        this.numberDataRecoveryBlocksFE.loadValue((BObject)BInteger.make((int)currentConfig.getNumberBlocks()), (Context)currentConfig.getSlotFacets((Slot)BDataRecoveryConfig.numberBlocks));
        this.numberDataRecoveryBlocksFE.setReadonly(true);
        this.numberDataRecoveryBlocksFE.setEnabled(false);
        this.linkTo(null, (BComponent)this.numberDataRecoveryBlocksFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.activeDirectoryFE = new BTextField("", 30);
        this.activeDirButton = new BButton((Command)new BrowseDataRecoveryDirectory((BWidget)this, this.activeDirectoryFE));
        this.activeDirButton.setButtonStyle(BButtonStyle.toolBar);
        BGridPane activeDir = new BGridPane(2);
        activeDir.add(null, (BValue)this.activeDirectoryFE);
        activeDir.add(null, (BValue)this.activeDirButton);
        BDataRecoveryConfigEditor.addLabelWidgetPair(configPane, BDataRecoveryConfigEditor.text("config.activeDirectory.label"), BDataRecoveryConfigEditor.left((BWidget)activeDir), true);
        this.activeDirectoryFE.setText(currentConfig.getActiveDirectory());
        this.activeDirectoryFE.setEditable(false);
        this.activeDirectoryFE.setEnabled(false);
        this.activeDirButton.setEnabled(false);
        this.linkTo(null, (BComponent)this.activeDirectoryFE, (Slot)BTextEditor.textModified, (Slot)setModified);
        this.persistentDirectoryFE = new BTextField("", 30);
        this.persistentDirButton = new BButton((Command)new BrowseDataRecoveryDirectory((BWidget)this, this.persistentDirectoryFE));
        this.persistentDirButton.setButtonStyle(BButtonStyle.toolBar);
        BGridPane persistentDir = new BGridPane(2);
        persistentDir.add(null, (BValue)this.persistentDirectoryFE);
        persistentDir.add(null, (BValue)this.persistentDirButton);
        BDataRecoveryConfigEditor.addLabelWidgetPair(configPane, BDataRecoveryConfigEditor.text("config.persistentDirectory.label"), BDataRecoveryConfigEditor.left((BWidget)persistentDir), true);
        this.persistentDirectoryFE.setText(currentConfig.getPersistentDirectory());
        this.persistentDirectoryFE.setEditable(false);
        this.persistentDirectoryFE.setEnabled(false);
        this.persistentDirButton.setEnabled(false);
        this.linkTo(null, (BComponent)this.persistentDirectoryFE, (Slot)BTextEditor.textModified, (Slot)setModified);
        this.activeFullPolicyFE = new BFrozenEnumFE();
        BDataRecoveryConfigEditor.addLabelWidgetPair(configPane, BDataRecoveryConfigEditor.text("config.fullPolicy.label"), BDataRecoveryConfigEditor.left((BWidget)this.activeFullPolicyFE), true);
        this.activeFullPolicyFE.loadValue((BObject)currentConfig.getActiveFullPolicy(), (Context)currentConfig.getSlotFacets((Slot)BDataRecoveryConfig.activeFullPolicy));
        this.activeFullPolicyFE.setReadonly(true);
        this.activeFullPolicyFE.setEnabled(false);
        this.linkTo(null, (BComponent)this.activeFullPolicyFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.persistentCapacityFE = new BDataRecoveryPersistenceCapacityFE();
        BDataRecoveryConfigEditor.addLabelWidgetPair(configPane, BDataRecoveryConfigEditor.text("config.storageCapacity.label"), BDataRecoveryConfigEditor.left((BWidget)this.persistentCapacityFE), true);
        this.persistentCapacityFE.loadValue((BObject)currentConfig.getPersistentStorageCapacity(), (Context)currentConfig.getSlotFacets((Slot)BDataRecoveryConfig.persistentStorageCapacity));
        this.persistentCapacityFE.setReadonly(true);
        this.persistentCapacityFE.setEnabled(false);
        this.linkTo(null, (BComponent)this.persistentCapacityFE, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.registerForComponentEvents((BComponent)currentConfig, Integer.MAX_VALUE);
        this.setContent((BWidget)configPane);
    }

    protected final BObject doSaveValue(BObject value, Context cx) throws Exception {
        BDataRecoveryConfig dataRecoveryConfig = (BDataRecoveryConfig)value;
        int tempIntValue = ((BInteger)this.totalDataRecoverySizeFE.saveValue(cx)).getInt();
        dataRecoveryConfig.setDataRecoverySize(tempIntValue);
        tempIntValue = ((BInteger)this.numberDataRecoveryBlocksFE.saveValue(cx)).getInt();
        dataRecoveryConfig.setNumberBlocks(tempIntValue);
        String tempStringValue = this.activeDirectoryFE.getText();
        dataRecoveryConfig.setActiveDirectory(tempStringValue);
        tempStringValue = this.persistentDirectoryFE.getText();
        dataRecoveryConfig.setPersistentDirectory(tempStringValue);
        BDataRecoveryFullPolicy tempFullPolicy = (BDataRecoveryFullPolicy)this.activeFullPolicyFE.saveValue(cx);
        dataRecoveryConfig.setActiveFullPolicy(tempFullPolicy);
        BDataRecoveryPersistenceCapacity tempCapacity = (BDataRecoveryPersistenceCapacity)this.persistentCapacityFE.saveValue(cx);
        dataRecoveryConfig.setPersistentStorageCapacity(tempCapacity);
        return dataRecoveryConfig;
    }

    public final void doSetReadonly(boolean readonly) {
        boolean enabled;
        boolean bl = enabled = !readonly;
        if (this.totalDataRecoverySizeFE != null) {
            this.totalDataRecoverySizeFE.setReadonly(readonly);
            this.totalDataRecoverySizeFE.setEnabled(enabled);
        }
        if (this.numberDataRecoveryBlocksFE != null) {
            this.numberDataRecoveryBlocksFE.setReadonly(readonly);
            this.numberDataRecoveryBlocksFE.setEnabled(enabled);
        }
        if (this.activeDirectoryFE != null) {
            this.activeDirectoryFE.setEnabled(true);
            this.activeDirectoryFE.setEditable(enabled);
        }
        if (this.activeDirButton != null) {
            this.activeDirButton.setEnabled(enabled);
        }
        if (this.persistentDirectoryFE != null) {
            this.persistentDirectoryFE.setEnabled(true);
            this.persistentDirectoryFE.setEditable(enabled);
        }
        if (this.persistentDirButton != null) {
            this.persistentDirButton.setEnabled(enabled);
        }
        if (this.activeFullPolicyFE != null) {
            this.activeFullPolicyFE.setReadonly(readonly);
            this.activeFullPolicyFE.setEnabled(enabled);
        }
        if (this.persistentCapacityFE != null) {
            this.persistentCapacityFE.setReadonly(readonly);
            this.persistentCapacityFE.setEnabled(enabled);
        }
    }

    public final void handleComponentEvent(BComponentEvent evt) {
        if (evt.getSlot().isProperty()) {
            if (evt.getSourceComponent() instanceof BDataRecoveryConfig) {
                BDataRecoveryConfig config = (BDataRecoveryConfig)evt.getSourceComponent();
                Property property = evt.getSlot().asProperty();
                BValue propertyValue = config.get(property);
                if (property == BDataRecoveryConfig.dataRecoverySize) {
                    if (this.totalDataRecoverySizeFE != null) {
                        this.totalDataRecoverySizeFE.loadValue((BObject)((BInteger)propertyValue), (Context)config.getSlotFacets((Slot)BDataRecoveryConfig.dataRecoverySize));
                    }
                } else if (property == BDataRecoveryConfig.numberBlocks) {
                    if (this.numberDataRecoveryBlocksFE != null) {
                        this.numberDataRecoveryBlocksFE.loadValue((BObject)((BInteger)propertyValue), (Context)config.getSlotFacets((Slot)BDataRecoveryConfig.numberBlocks));
                    }
                } else if (property == BDataRecoveryConfig.activeDirectory) {
                    if (this.activeDirectoryFE != null) {
                        this.activeDirectoryFE.setText(propertyValue.toString().trim());
                    }
                } else if (property == BDataRecoveryConfig.persistentDirectory) {
                    if (this.persistentDirectoryFE != null) {
                        this.persistentDirectoryFE.setText(propertyValue.toString().trim());
                    }
                } else if (property == BDataRecoveryConfig.activeFullPolicy) {
                    if (this.activeFullPolicyFE != null) {
                        this.activeFullPolicyFE.loadValue((BObject)((BDataRecoveryFullPolicy)propertyValue), (Context)config.getSlotFacets((Slot)BDataRecoveryConfig.activeFullPolicy));
                    }
                } else if (property == BDataRecoveryConfig.persistentStorageCapacity && this.persistentCapacityFE != null) {
                    this.persistentCapacityFE.loadValue((BObject)((BDataRecoveryPersistenceCapacity)propertyValue), (Context)config.getSlotFacets((Slot)BDataRecoveryConfig.persistentStorageCapacity));
                }
            } else {
                super.handleComponentEvent(evt);
            }
        } else {
            super.handleComponentEvent(evt);
        }
    }

    private static String text(String key) {
        return lex.getText("DataRecoveryService." + key);
    }

    private static BWidget left(BWidget content) {
        BGridPane result = new BGridPane(1);
        result.setHalign(BHalign.left);
        result.setColumnAlign(BHalign.left);
        result.add(null, (BValue)content);
        return result;
    }

    private static void addLabelWidgetPair(BGridPane grid, String text, BWidget widget2, boolean bold) {
        String fieldName = text.trim();
        if (fieldName.length() > 10) {
            fieldName = fieldName.substring(0, 10);
        }
        fieldName = ObjectUtil.generateUniqueName((String)SlotPath.escape((String)fieldName), (ObjectUtil.NameContainer)new NameContainerDRS((BComplex)grid));
        grid.add(fieldName, (BValue)BDataRecoveryConfigEditor.makeLabel(text, bold));
        grid.add(null, (BValue)widget2);
    }

    public static BLabel makeLabel(String text, boolean bold) {
        return BDataRecoveryConfigEditor.makeLabel(text, bold, BHalign.left);
    }

    public static BLabel makeLabel(String text, boolean bold, BHalign align) {
        BLabel result = new BLabel(text == null ? "" : text, align);
        if (bold) {
            result.setFont(BOLD_TEXT_FONT);
        }
        return result;
    }

    static {
        BOLD_TEXT_FONT = Theme.widget().getBoldText();
        lex = Lexicon.make((String)"platDataRecovery");
    }

    private static final class NameContainerDRS
    implements ObjectUtil.NameContainer {
        BComplex complex;

        public NameContainerDRS(BComplex pComplex) {
            this.complex = pComplex;
        }

        public boolean contains(String name) {
            return this.complex.getSlot(name) != null;
        }
    }

    private static class BrowseDataRecoveryDirectory
    extends Command {
        BTextField directory;

        public BrowseDataRecoveryDirectory(BWidget owner, BTextField moduleDir) {
            super(owner, "");
            this.directory = moduleDir;
        }

        public BImage getIcon() {
            return openIcon;
        }

        public CommandArtifact doInvoke() {
            BOrd file = chooser.show();
            if (file != null) {
                OrdQuery[] q = file.parse();
                this.directory.setText(q[q.length - 1].getBody());
                this.directory.repaint();
            }
            return null;
        }
    }
}

