/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap;

import com.tridium.authn.NiagaraLoginModule;
import com.tridium.ldap.BLdapConfig;
import com.tridium.ldap.BLdapTypeConfig;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.util.Lexicon;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public class LdapLoginModule
extends NiagaraLoginModule {
    private BLdapConfig config;
    protected static final Lexicon lex = Lexicon.make((String)"ldap");

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.config = (BLdapConfig)((BLdapTypeConfig)((Object)options.get("config"))).make();
        this.callbackHandler = callbackHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login() throws LoginException {
        char[] password;
        String username;
        if (this.callbackHandler == null) {
            throw new LoginException(lex.getText("ldap.error.nullCallback"));
        }
        Callback[] callbacks = new Callback[]{new NameCallback("name"), new PasswordCallback("password", false)};
        try {
            this.callbackHandler.handle(callbacks);
            username = ((NameCallback)callbacks[0]).getName();
            if (username.equals("")) {
                return false;
            }
            char[] tempPassword = ((PasswordCallback)callbacks[1]).getPassword();
            password = new char[tempPassword.length];
            System.arraycopy(tempPassword, 0, password, 0, tempPassword.length);
            ((PasswordCallback)callbacks[1]).clearPassword();
        }
        catch (UnsupportedCallbackException e) {
            String msg = lex.getText("ldap.error.couldNotHandle", new Object[]{e.getCallback()});
            BLdapConfig.logException(msg, e, Level.SEVERE);
            throw new LoginException(msg);
        }
        catch (Exception e) {
            String msg = lex.getText("ldap.error.callbackError");
            BLdapConfig.logException(msg, e, Level.SEVERE);
            throw new LoginException(msg);
        }
        try {
            this.user = this.config.authenticate(username, new String(password));
        }
        finally {
            for (char c : password) {
                c = '\u0000';
            }
            password = null;
        }
        this.succeeded = true;
        return true;
    }
}

