/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap.v3;

import com.tridium.fox.message.FoxMessage;
import com.tridium.ldap.BLdapConfig;
import com.tridium.ldap.v3.AcquireCredentialsAction;
import com.tridium.ldap.v3.KerberosCallback;
import java.io.IOException;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.fox.authn.BFoxCallbackHandler;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.kerberos.BKerberosCredentials;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;

@NiagaraType(agent={@AgentOn(types={"ldap:KerberosAuthenticationScheme"})})
public class BFoxKerberosCallbackHandler
extends BFoxCallbackHandler {
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxKerberosCallbackHandler.class);
    String username = null;
    protected static final Lexicon lex = Lexicon.make((String)"ldap");

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof KerberosCallback) {
                KerberosCallback kCallback = (KerberosCallback)callback;
                try {
                    FoxMessage kInfo = new FoxMessage();
                    kInfo.add("server", kCallback.getServer());
                    kInfo.add("realm", kCallback.getRealm());
                    kInfo.add("kdc", kCallback.getKdc());
                    this.session.setState("client.tune sendKInfo");
                    this.session.sendTuning("kInfo", kInfo);
                    BKerberosCredentials cred = (BKerberosCredentials)AccessController.doPrivileged(() -> (BKerberosCredentials)Subject.doAs(kCallback.getSubject(), new AcquireCredentialsAction(this.session)));
                    kCallback.setCredentials((BIUserCredentials)cred);
                    continue;
                }
                catch (Exception e) {
                    String msg = lex.getText("ldap.error.couldNotGetCreds");
                    BLdapConfig.logException(msg, e, Level.SEVERE);
                    throw new IOException(msg);
                }
            }
            throw new UnsupportedCallbackException(callback, lex.getText("ldap.error.callbackUnsupported", new Object[]{callback.getClass()}));
        }
    }

    public String getUsername() {
        return this.username;
    }
}

