/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap.v3;

import com.tridium.authn.NiagaraLoginConfiguration;
import com.tridium.ldap.v3.BKerberosConfig;
import com.tridium.ldap.v3.KerberosLoginModule;
import com.tridium.util.PxUtil;
import com.tridium.web.Template;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import javax.baja.agent.AgentList;
import javax.baja.authn.BSSOAuthenticationScheme;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BAbstractAuthenticator;
import javax.baja.security.BBlankAuthenticator;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUserPrototypeMergePolicy;
import javax.baja.user.IHasPrototypeMergePolicy;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

@NiagaraType(agent={@AgentOn(types={"baja:AuthenticationScheme"})})
@NiagaraProperties(value={@NiagaraProperty(name="config", type="BKerberosConfig", defaultValue="new BKerberosConfig()"), @NiagaraProperty(name="prototypeMergePolicy", type="BUserPrototypeMergePolicy", defaultValue="new BUserPrototypeMergePolicy()")})
public class BKerberosAuthenticationScheme
extends BSSOAuthenticationScheme
implements IHasPrototypeMergePolicy {
    @Generated
    public static final Property config = BKerberosAuthenticationScheme.newProperty((int)0, (BValue)new BKerberosConfig(), null);
    @Generated
    public static final Property prototypeMergePolicy = BKerberosAuthenticationScheme.newProperty((int)0, (BValue)new BUserPrototypeMergePolicy(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BKerberosAuthenticationScheme.class);
    public static final String SCHEME_NAME = "n4Kerberos";
    private Configuration configuration;
    private static final BOrd helpTemplate = BOrd.make((String)"module://ldap/com/tridium/ldap/rc/kerberosHelp.vm");

    @Generated
    public BKerberosConfig getConfig() {
        return (BKerberosConfig)this.get(config);
    }

    @Generated
    public void setConfig(BKerberosConfig v) {
        this.set(config, (BValue)v, null);
    }

    @Generated
    public BUserPrototypeMergePolicy getPrototypeMergePolicy() {
        return (BUserPrototypeMergePolicy)this.get(prototypeMergePolicy);
    }

    @Generated
    public void setPrototypeMergePolicy(BUserPrototypeMergePolicy v) {
        this.set(prototypeMergePolicy, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.toTop("webEditors:MultiSheet");
        list.toTop("workbench:PropertySheet");
        return PxUtil.movePxViewsToTop((AgentList)list);
    }

    public String getSchemeName() {
        return SCHEME_NAME;
    }

    public Configuration getLoginConfiguration() {
        HashMap<String, BKerberosConfig> options = new HashMap<String, BKerberosConfig>();
        options.put("config", this.getConfig());
        if (this.configuration == null) {
            this.configuration = new NiagaraLoginConfiguration(KerberosLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
        }
        return this.configuration;
    }

    public boolean supportsRemoteUsers() {
        return true;
    }

    public BAbstractAuthenticator getDefaultAuthenticator() {
        return new BBlankAuthenticator();
    }

    public String getLoginRedirectURL() {
        return "/login-kerb";
    }

    public Optional<String> getHelpHTML() {
        try {
            return Optional.of(Template.process((BOrd)helpTemplate));
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }
}

