/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ldap.v3;

import com.tridium.authn.NiagaraFailedLoginException;
import com.tridium.authn.NiagaraLoginModule;
import com.tridium.ldap.BLdapConfig;
import com.tridium.ldap.v3.BKerberosAuthenticationScheme;
import com.tridium.ldap.v3.BKerberosConfig;
import com.tridium.ldap.v3.KerberosCallback;
import java.security.AccessController;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.security.BIUserCredentials;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public class KerberosLoginModule
extends NiagaraLoginModule {
    private BKerberosConfig config;
    protected static Logger logger = Logger.getLogger("ldap");
    protected static final Lexicon lex = Lexicon.make((String)"ldap");

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.config = (BKerberosConfig)((Object)options.get("config"));
    }

    public boolean login() throws LoginException {
        BIUserCredentials cred;
        this.config.setScheme((BAuthenticationScheme)((BKerberosAuthenticationScheme)this.config.getParent()));
        if (this.callbackHandler == null) {
            throw new LoginException(lex.getText("ldap.error.nullCallback"));
        }
        try {
            String kdc = this.config.getAllKdcHosts();
            AccessController.doPrivileged(() -> {
                System.setProperty("java.security.krb5.realm", this.config.getRealm());
                System.setProperty("java.security.krb5.kdc", kdc);
                BKerberosConfig.setKrb5ConfLocation();
                return null;
            });
            Subject sub = this.config.getStationSubject();
            Callback[] callbacks = new Callback[]{new KerberosCallback(this.config.getStationKerberosName(), this.config.getRealm(), kdc, sub)};
            this.callbackHandler.handle(callbacks);
            cred = ((KerberosCallback)callbacks[0]).getCredentials();
            if (cred == null) {
                return false;
            }
        }
        catch (UnsupportedCallbackException e) {
            String msg = lex.getText("ldap.error.couldNotHandle", new Object[]{e.getCallback()});
            BLdapConfig.logException(msg, e, Level.SEVERE);
            throw new LoginException(msg);
        }
        catch (Exception e) {
            this.user = null;
            throw new LoginException(lex.getText("ldap.error.callbackError"));
        }
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BUser existingUser = userService.getUser(cred.getUsername());
        String schemeName = this.config.getParent().getName();
        if (existingUser != null && !schemeName.equals(existingUser.getAuthenticationSchemeName())) {
            String msg = lex.getText("ldap.error.existingUser", new Object[]{existingUser.getName(), existingUser.getAuthenticationSchemeName()});
            logger.severe(msg);
            throw new NiagaraFailedLoginException(existingUser.getUsername(), msg);
        }
        this.user = this.config.authenticate(cred);
        this.succeeded = true;
        return true;
    }
}

