/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.util.BasicException;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.comm.MbusCommReceiver;
import com.tridium.mbus.comm.MbusCommTransmitter;
import com.tridium.mbus.comm.MbusSocketComm;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.net.BInternetAddress;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.status.BStatus;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="ipAddress", type="BInternetAddress", defaultValue="new BInternetAddress(\"192.168.1.10:6021\")"), @NiagaraProperty(name="pingPreConnect", type="boolean", defaultValue="true", flags=8)})
public final class BMbusTcpIpNetwork
extends BAbstractMbusNetwork
implements MbusSocketComm.ISocketAddressHolder {
    @Generated
    public static final Property ipAddress = BMbusTcpIpNetwork.newProperty((int)0, (BValue)new BInternetAddress("192.168.1.10:6021"), null);
    @Generated
    public static final Property pingPreConnect = BMbusTcpIpNetwork.newProperty((int)8, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMbusTcpIpNetwork.class);
    private final Object startCommsLock = new Object();
    private volatile boolean commsStartAllowed = false;
    private volatile String startingUpForIp = null;

    @Generated
    public BInternetAddress getIpAddress() {
        return (BInternetAddress)this.get(ipAddress);
    }

    @Generated
    public void setIpAddress(BInternetAddress v) {
        this.set(ipAddress, (BValue)v, null);
    }

    @Generated
    public boolean getPingPreConnect() {
        return this.getBoolean(pingPreConnect);
    }

    @Generated
    public void setPingPreConnect(boolean v) {
        this.setBoolean(pingPreConnect, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMbusTcpIpNetwork() {
        this.setFlags((Slot)serialPortConfig, 4);
        this.setFlags((Slot)searchBaudRate, 4);
    }

    public Type[] getServiceTypes() {
        Array a = new Array(Type.class);
        a.add((Object)this.getType());
        a.addAll((Object[])super.getServiceTypes());
        return (Type[])a.trim();
    }

    @Override
    public void started() throws Exception {
        this.startStationMonitorSaving();
        this.setFlags((Slot)ping, 8);
        this.setFlags((Slot)upload, 4);
        this.setFlags((Slot)download, 4);
    }

    @Override
    public void stopped() throws Exception {
        this.stopStationMonitorSaving();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changed(Property p, Context cx) {
        if (this.isRunning()) {
            if (ipAddress == p) {
                if (this.getLog().isTraceOn()) {
                    this.getLog().trace(this.getName() + " *** Comm restart in progress due to IP change ***");
                }
                try {
                    this.stopComm();
                }
                catch (Exception e) {
                    this.getLog().error("Error attempting to change the IP address on this device", (Throwable)e);
                }
            }
            if (status == p || ipAddress == p) {
                Object object = this.startCommsLock;
                synchronized (object) {
                    if (this.isDisabled()) {
                        block20: {
                            try {
                                this.stopComm();
                                this.startingUpForIp = null;
                            }
                            catch (Exception e) {
                                if (!this.getLog().isTraceOn()) break block20;
                                this.getLog().trace("Exception occurred while stopping comm", (Throwable)e);
                            }
                        }
                        return;
                    }
                    if (this.startingUpForIp != null) {
                        return;
                    }
                    if (!(this.isFatalFault() || this.isCommActive() || this.getComm().isCommStarted())) {
                        this.startingUpForIp = this.getIpAddress().encodeToString();
                        try {
                            this.startCommunicationSystem();
                            this.startingUpForIp = null;
                        }
                        catch (Exception e) {
                            if (this.getLog().isTraceOn()) {
                                this.getLog().error("Error start comms system", (Throwable)e);
                            }
                            this.startingUpForIp = null;
                        }
                        finally {
                            this.startingUpForIp = null;
                        }
                    }
                }
                return;
            }
        }
        super.changed(p, cx);
    }

    @Override
    public void descendantsStarted() throws Exception {
        this.commsStartAllowed = true;
        if (this.getLog().isTraceOn()) {
            this.getLog().trace(this.getName() + " *** Comm start allowed ***");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        BMbusTcpIpNetwork.this.startComm();
                    }
                    catch (Throwable e) {
                        if (!BMbusTcpIpNetwork.this.getLog().isTraceOn()) break block2;
                        BMbusTcpIpNetwork.this.getLog().trace(BMbusTcpIpNetwork.this.getName() + " *** Comm start fail at descendants started *** " + e.getMessage());
                    }
                }
            }
        }, "Mbus:StartCommThread").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startComm() throws Exception {
        Object object = this.startCommsLock;
        synchronized (object) {
            if (!this.isDisabled() && !this.isFatalFault() && this.getComm() != null) {
                try {
                    this.startCommunicationSystem();
                }
                catch (Exception e) {
                    this.setFaultCause(e.getMessage());
                    this.setStatus(BStatus.make((BStatus)this.getStatus(), (int)4, (boolean)true));
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopComm() throws Exception {
        Object object = this.startCommsLock;
        synchronized (object) {
            Comm comm = this.getComm();
            if (comm instanceof MbusSocketComm) {
                MbusSocketComm mbusComm = (MbusSocketComm)comm;
                mbusComm.stop();
            }
        }
    }

    public void doPing() {
        if (!Sys.isStationStarted()) {
            return;
        }
        if (this.startingUpForIp != null) {
            return;
        }
        if (this.isDown()) {
            this.startingUpForIp = this.getIpAddress().encodeToString();
            try {
                this.stopComm();
                this.startCommunicationSystem();
                this.setFaultCause("");
                this.startingUpForIp = null;
            }
            catch (BasicException e) {
                this.pingFail(e.getMessage());
                this.startingUpForIp = null;
                return;
            }
            catch (Exception e) {
                this.pingFail(e.getMessage());
                this.startingUpForIp = null;
                return;
            }
        } else {
            MbusSocketComm socketComm = (MbusSocketComm)this.getComm();
            if (socketComm.attemptDeviceIcmpPingAllowed()) {
                if (this.getPingPreConnect() && !socketComm.icmpPing()) {
                    this.setFaultCause("Could not ping TCP/IP gateway");
                    this.pingFail("Could not ping TCP/IP gateway");
                    return;
                }
                if (this.getNetwork().getFaultCause().startsWith("Could not ping TCP/IP gateway")) {
                    this.getNetwork().setFaultCause("");
                }
            }
        }
        try {
            if (MbusToolkit.getLogger().getName() != this.getNetwork().getLogger().getName()) {
                MbusToolkit.setLogger(this.getNetwork().getLogger());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.pingOk();
    }

    private void startCommunicationSystem() throws Exception {
        if (this.getComm() == null) {
            if (this.getLog().isTraceOn()) {
                this.getLog().trace(this.getName() + " *** Comm request ignored - currently null comms link layer ***");
            }
            return;
        }
        if (!this.commsStartAllowed) {
            if (this.getLog().isTraceOn()) {
                this.getLog().trace(this.getName() + " *** Comm start delayed until full network boot ***");
            }
            return;
        }
        if (this.getComm().isCommStarted()) {
            return;
        }
        if (this.getLog().isTraceOn()) {
            this.getLog().trace(this.getName() + " *** Starting Communication Handler - Socket Comm ***");
        }
        this.getComm().start();
        if (this.getLog().isTraceOn()) {
            this.getLog().trace(this.getName() + " *** Started Communication Handler - Socket Comm ***");
        }
    }

    protected String checkSerialConfig() {
        return null;
    }

    @Override
    protected String getLicenseConnectTypeName() {
        return "tcpip";
    }

    @Override
    protected Comm makeComm() {
        MbusCommReceiver receiver = new MbusCommReceiver();
        receiver.setCollisionHexBytes(this.getCollisionCsvBytes());
        return new MbusSocketComm((BBasicNetwork)this, receiver, new MbusCommTransmitter(), this);
    }

    @Override
    public BInternetAddress getInternetAddress() {
        return this.getIpAddress();
    }
}

