/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.comm;

import com.tridium.mbus.messages.MbusMessage;
import javax.baja.serial.BBaudRate;
import javax.baja.sys.BRelTime;

public class MBusTxTimings {
    public long intermessageDelay = 12000L;
    public BRelTime responseTimeout = BRelTime.makeSeconds((int)12);
    public BRelTime initialisationDelay = BRelTime.makeSeconds((int)1);
    public int retryTransmission = 0;

    public MBusTxTimings() {
    }

    public MBusTxTimings(MBusTxTimings timingsToClone) {
        this.intermessageDelay = timingsToClone.intermessageDelay;
        this.initialisationDelay = BRelTime.make((long)timingsToClone.initialisationDelay.getMillis());
        this.responseTimeout = BRelTime.make((long)timingsToClone.responseTimeout.getMillis());
        this.retryTransmission = timingsToClone.retryTransmission;
    }

    public boolean timingsMatch(MBusTxTimings other) {
        return other.intermessageDelay == this.intermessageDelay && other.initialisationDelay == this.initialisationDelay && other.responseTimeout == this.responseTimeout && other.retryTransmission == this.retryTransmission;
    }

    public static long calculateTxRxTime(long bytesTxRxLength, BBaudRate baudRate) {
        return MBusTxTimings.calculateTxRxTime(bytesTxRxLength, baudRate.getOrdinal());
    }

    public static long calculateTxRxTime(MbusMessage messageToSendRef, BBaudRate baudRate) {
        return MBusTxTimings.calculateTxRxTime((long)messageToSendRef.getWriteBytesLength(), baudRate.getOrdinal());
    }

    public static long calculateTxRxTime(long bytesToTxRx, long baudRate) {
        long timeToSendInMillis = (bytesToTxRx *= 11L) / baudRate * 1000L;
        timeToSendInMillis = (long)((double)timeToSendInMillis + (double)(bytesToTxRx % baudRate) / (double)baudRate * 1000.0);
        return timeToSendInMillis;
    }

    public void applyInitialisationDelay() throws InterruptedException {
        long initDelayMs = this.initialisationDelay.getMillis();
        if (initDelayMs < 1L) {
            return;
        }
        Thread.sleep(initDelayMs);
    }
}

