/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.comm;

import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.mbus.comm.MbusSocketComm;
import com.tridium.mbus.messages.MbusMessage;
import com.tridium.mbus.messages.MbusReceivedMessage;
import com.tridium.mbus.messages.MbusReqUd1Message;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.utils.MbusCrcGenerator;
import com.tridium.mbus.utils.MbusToolkit;
import java.net.SocketException;
import javax.baja.log.Log;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;

public final class MbusCommReceiver
extends CommReceiver {
    private byte[] collisionDetectionCharacters = new byte[0];
    private boolean rcv_done = false;
    private MbusReceivedMessage rcv_msg = null;
    private byte[] rcv_messageInput = null;
    private boolean rcv_responseOk = false;
    private volatile boolean smi_done = false;
    private boolean smi_firstChar = true;
    private int smi_length = 4;
    private boolean smi_lengthNextChar = false;
    private int smi_charIn = -1;
    private boolean smi_newChar = false;
    private final byte[] smi_inputBuffer = new byte[300];
    private int smi_numberOfBytesInput = 0;
    private byte[] smi_byteMessage = null;
    private boolean streamPositionRecovery = false;
    private long lastCharReadTicks = 0L;
    private final Object resetRequestLock = new Object();
    private volatile boolean resetRequested = false;
    private long resetRequestedTicks = 0L;
    private long lastEOFMarkerTicks = Long.MIN_VALUE;
    private final Object messageSentLock = new Object();
    private long maxDataReceivedGapTimeMs = 1000L;
    MbusMessage sentMessage = null;
    private final Log rawLog = Log.getLog((String)"MBusNetwork_RAW_INPUT");

    public void setCollisionHexBytes(String string) {
        if (this.rawLog.isTraceOn()) {
            this.rawLog.trace("Loading collision detection data from \"" + string + "\"");
        }
        if (string == null || string.trim().length() == 0) {
            return;
        }
        try {
            try {
                this.collisionDetectionCharacters = MbusCommReceiver.getHexToBytes(string, ',');
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.collisionDetectionCharacters.length == 0) {
                try {
                    this.collisionDetectionCharacters = MbusCommReceiver.getHexToBytes(string, ';');
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.collisionDetectionCharacters.length == 0) {
                try {
                    this.collisionDetectionCharacters = MbusCommReceiver.getHexToBytes(string, '\t');
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.collisionDetectionCharacters.length == 0) {
                try {
                    this.collisionDetectionCharacters = MbusCommReceiver.getHexToBytes(string, ' ');
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.rawLog.isTraceOn()) {
                for (int i = 0; i < this.collisionDetectionCharacters.length; ++i) {
                    this.rawLog.trace("Collision detection character loaded - [" + i + "] = 0x" + TextUtil.byteToHexString((int)this.collisionDetectionCharacters[i]));
                }
            }
        }
        catch (Throwable t) {
            this.rawLog.error("Issue when loading collisionHexBytes for receiver with value \"" + string + "\"", t);
        }
    }

    private static byte[] getHexToBytes(String srcString, char expectedDelimiter) throws Exception {
        byte[] results = null;
        String[] splitString = TextUtil.split((String)srcString, (char)expectedDelimiter);
        results = new byte[splitString.length];
        for (int i = 0; i < splitString.length; ++i) {
            splitString[i] = splitString[i].trim();
            if (splitString[i].startsWith("0x")) {
                splitString[i] = splitString[i].substring(2);
            }
            if (splitString[i].length() > 2) {
                throw new Exception("Value is longer than 1 byte in hex - invalid entry");
            }
            splitString[i] = splitString[i].toUpperCase();
            for (int chNo = 0; chNo < splitString[i].length(); ++chNo) {
                if (splitString[i].charAt(chNo) >= '0' && splitString[i].charAt(chNo) <= '9' || splitString[i].charAt(chNo) >= 'A' && splitString[i].charAt(chNo) <= 'F') continue;
                throw new Exception("Outside valid ASCII Range - \"" + splitString[i] + "\"");
            }
            results[i] = (byte)(Integer.parseInt(splitString[i], 16) & 0xFF);
        }
        return results;
    }

    public void initReceiveState(byte[] msg) {
    }

    public void initReceiveState(Message msg) {
    }

    protected ReceivedMessage receive() throws Exception {
        if (this.rawLog.isTraceOn()) {
            this.rawLog.trace("receive()");
        }
        this.rcv_responseOk = false;
        this.rcv_done = false;
        this.rcv_msg = null;
        this.rcv_messageInput = null;
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace("MessageSent In Receive = " + (this.sentMessage != null ? ByteArrayUtil.toHexString((byte[])this.sentMessage.getBytes()) : "null"));
        }
        boolean collisionMarkerRead = false;
        while (!this.rcv_done) {
            this.rcv_responseOk = false;
            this.rcv_messageInput = this.getSingleMessageInput();
            if (this.rcv_messageInput == null) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("Comm receiver shutdown");
                }
                return null;
            }
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace("Single Message Input = " + (this.sentMessage != null ? ByteArrayUtil.toHexString((byte[])this.sentMessage.getBytes()) : "null"));
            }
            if (this.sentMessage != null && (this.sentMessage instanceof MbusReqUd1Message || this.sentMessage instanceof MbusReqUd2Message) && this.rcv_messageInput[0] == 104) {
                this.rcv_done = true;
                if (!MbusToolkit.isTraceOn()) continue;
                MbusToolkit.trace("UD1 or UD2, with input beginning 0x68 found");
                continue;
            }
            if (this.sentMessage != null && !(this.sentMessage instanceof MbusReqUd1Message) && !(this.sentMessage instanceof MbusReqUd2Message)) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("Sent message not UD1 or UD2");
                }
                String messageInputString = new String(this.rcv_messageInput);
                String sentMessageString = new String(this.sentMessage.getBytes());
                if (sentMessageString.equals(messageInputString)) {
                    if (MbusToolkit.isTraceOn()) {
                        MbusToolkit.trace("Echo response received");
                    }
                    this.rcv_messageInput = new byte[1];
                    this.rcv_messageInput[0] = -27;
                    this.rcv_done = true;
                    this.rcv_responseOk = true;
                    continue;
                }
                if (this.rcv_messageInput[0] == -27) {
                    if (MbusToolkit.isTraceOn()) {
                        MbusToolkit.trace("0xE5 received, NOT from a UD1 or UD2");
                    }
                    this.rcv_done = true;
                    this.rcv_responseOk = true;
                    continue;
                }
                for (int colNo = 0; colNo < this.collisionDetectionCharacters.length; ++colNo) {
                    if (this.rcv_messageInput[0] != this.collisionDetectionCharacters[colNo]) continue;
                    if (MbusToolkit.isTraceOn()) {
                        MbusToolkit.trace("Received collision detection marker 0x" + TextUtil.byteToHexString((int)this.rcv_messageInput[0]));
                    }
                    collisionMarkerRead = true;
                    this.rcv_done = true;
                    this.rcv_responseOk = true;
                }
                continue;
            }
            if (this.rcv_messageInput[0] != -27) continue;
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace("0xE5 received");
            }
            this.rcv_done = true;
            this.rcv_responseOk = true;
        }
        if (this.rcv_messageInput != null && this.rcv_messageInput.length > 0 && this.rcv_messageInput[0] == -27 && MbusToolkit.isTraceOn()) {
            MbusToolkit.trace("0xE5 received");
        }
        this.rcv_msg = new MbusReceivedMessage(this.rcv_messageInput);
        this.rcv_msg.setSuccessfulResponse(this.rcv_responseOk);
        if (collisionMarkerRead) {
            this.rcv_msg.setCollisionFlag(true);
        }
        if (this.rcv_messageInput.length > 4) {
            byte checksum;
            byte[] testData = this.rcv_msg.getBytes();
            byte inputChksum = testData[testData.length - 2];
            if (inputChksum != (checksum = MbusCrcGenerator.mBus(this.rcv_msg.getBytes()))) {
                this.rcv_msg.setSuccessfulResponse(false);
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("Input Chksum= " + inputChksum + " Should be= " + checksum);
                    for (int i = 0; i < this.rcv_msg.getLength(); ++i) {
                        MbusToolkit.trace("index = " + i + " value = " + testData[i] + " raw value = " + testData[i] + " char = '" + (char)testData[i] + "'");
                    }
                }
            } else {
                this.rcv_msg.setSuccessfulResponse(true);
                this.messageSent(null);
            }
        }
        return this.rcv_msg;
    }

    private void resetSingleMessageInputVariables() {
        this.smi_done = false;
        this.smi_firstChar = true;
        this.smi_length = 4;
        this.smi_lengthNextChar = false;
        this.smi_charIn = -1;
        this.smi_newChar = false;
        this.smi_numberOfBytesInput = 0;
        this.smi_byteMessage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getSingleMessageInput() throws Exception {
        this.resetSingleMessageInputVariables();
        int lastLengthRead = -1;
        try {
            while (true) {
                block36: {
                    block33: {
                        block32: {
                            block35: {
                                block34: {
                                    if (this.smi_done) {
                                        if (this.smi_numberOfBytesInput <= 0) return this.smi_byteMessage;
                                        this.smi_byteMessage = new byte[this.smi_numberOfBytesInput];
                                        System.arraycopy(this.smi_inputBuffer, 0, this.smi_byteMessage, 0, this.smi_numberOfBytesInput);
                                        return this.smi_byteMessage;
                                    }
                                    if (this.getInputStream() == null) {
                                        if (!this.isAlive()) {
                                            return null;
                                        }
                                        Thread.sleep(1000L);
                                        continue;
                                    }
                                    this.smi_charIn = this.getInputStream().read();
                                    this.smi_newChar = this.smi_charIn != -1;
                                    this.smi_charIn &= 0xFF;
                                    if (!this.smi_newChar) break block33;
                                    Object object = this.resetRequestLock;
                                    synchronized (object) {
                                        if (this.resetRequested) {
                                            if (this.lastCharReadTicks + this.maxDataReceivedGapTimeMs < this.resetRequestedTicks && !this.smi_firstChar) {
                                                this.smi_done = false;
                                                this.smi_firstChar = true;
                                                this.smi_length = 4;
                                                this.smi_lengthNextChar = false;
                                                this.smi_numberOfBytesInput = 0;
                                                this.smi_byteMessage = null;
                                                lastLengthRead = -1;
                                                this.rawLog.warning("Reception system reset - mid-frame reading - last byte read outside of expected time tolerance");
                                            }
                                            this.resetRequested = false;
                                        }
                                    }
                                    this.lastCharReadTicks = Clock.ticks();
                                    if (this.rawLog.isTraceOn()) {
                                        this.rawLog.trace("RX : 0x" + TextUtil.byteToHexString((int)this.smi_charIn) + " [" + this.lastCharReadTicks + "]");
                                    }
                                    if (!this.smi_firstChar) break block34;
                                    if (this.rawLog.isTraceOn()) {
                                        this.rawLog.trace("Reading first character of response");
                                    }
                                    this.smi_firstChar = false;
                                    if (this.smi_charIn == 229) {
                                        this.smi_length = 1;
                                        this.smi_done = true;
                                        this.smi_numberOfBytesInput = 1;
                                        this.smi_inputBuffer[0] = (byte)this.smi_charIn;
                                        break block32;
                                    } else if (!this.streamPositionRecovery) {
                                        switch (this.smi_charIn) {
                                            case 16: {
                                                this.smi_length = 5;
                                                break;
                                            }
                                            case 104: {
                                                this.smi_lengthNextChar = true;
                                                break;
                                            }
                                            default: {
                                                this.smi_length = 1;
                                                this.smi_done = true;
                                                this.smi_numberOfBytesInput = 1;
                                                this.smi_inputBuffer[0] = (byte)this.smi_charIn;
                                                break;
                                            }
                                        }
                                        break block32;
                                    } else {
                                        switch (this.smi_charIn) {
                                            case 104: {
                                                this.smi_lengthNextChar = true;
                                                break;
                                            }
                                            default: {
                                                this.smi_length = 1;
                                                this.smi_done = true;
                                                this.smi_numberOfBytesInput = 1;
                                                this.smi_inputBuffer[0] = (byte)this.smi_charIn;
                                                break;
                                            }
                                        }
                                    }
                                    break block32;
                                }
                                if (!this.smi_lengthNextChar) break block32;
                                if (lastLengthRead == -1) break block35;
                                if ((lastLengthRead & 0xFF) == this.smi_charIn) {
                                    this.smi_lengthNextChar = false;
                                    this.smi_length = this.smi_charIn + 6;
                                    this.streamPositionRecovery = false;
                                    if (this.rawLog.isTraceOn()) {
                                        this.rawLog.trace("First / Second length check matched: 0x" + TextUtil.byteToHexString((int)this.smi_charIn));
                                    }
                                    break block32;
                                } else {
                                    this.rawLog.warning("First / Second length check failed: 0x" + TextUtil.byteToHexString((int)this.smi_charIn) + " != " + TextUtil.byteToHexString((int)(lastLengthRead & 0xFF)));
                                    this.streamPositionRecovery = true;
                                    this.resetSingleMessageInputVariables();
                                    lastLengthRead = -1;
                                    continue;
                                }
                            }
                            lastLengthRead = this.smi_charIn;
                        }
                        this.smi_inputBuffer[this.smi_numberOfBytesInput] = (byte)this.smi_charIn;
                        ++this.smi_numberOfBytesInput;
                        if (this.smi_numberOfBytesInput < this.smi_length) continue;
                        break block36;
                    }
                    if (!this.isAlive()) {
                        return null;
                    }
                    if (this.getComm() instanceof MbusSocketComm) {
                        throw new SocketException("End of stream.");
                    }
                    if (this.lastEOFMarkerTicks > Clock.ticks() - 100L) {
                        Thread.sleep(1000L);
                        if (!this.rawLog.isTraceOn()) continue;
                        this.rawLog.trace("Reception EOF Protection Complete");
                        continue;
                    }
                    this.lastEOFMarkerTicks = Clock.ticks();
                    continue;
                }
                this.smi_done = true;
                if (!this.rawLog.isTraceOn()) continue;
                this.rawLog.trace("Read required number of bytes " + this.smi_length);
            }
        }
        catch (SocketException e) {
            try {
                Thread.sleep(5000L);
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("Comm receiver Socket Exception " + e);
                }
                this.handleSocketExceptionIfNeeded(e);
                return this.smi_byteMessage;
            }
            catch (InterruptedException ie) {
                if (!MbusToolkit.isTraceOn()) return null;
                MbusToolkit.trace("Comm receiver interrupted during msg read");
                return null;
            }
        }
    }

    private void handleSocketExceptionIfNeeded(SocketException e) {
        if (this.isAlive() && this.getComm() instanceof MbusSocketComm) {
            ((MbusSocketComm)this.getComm()).onReceiveError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void messagePendingTx() {
        Object object = this.resetRequestLock;
        synchronized (object) {
            this.resetRequested = true;
            this.resetRequestedTicks = Clock.ticks();
        }
        if (this.rawLog.isTraceOn()) {
            this.rawLog.trace("Pre-Dispatch Message Receiver Notification [" + this.resetRequestedTicks + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReceiveBufferTimeout(BRelTime timeout) {
        Object object = this.resetRequestLock;
        synchronized (object) {
            this.maxDataReceivedGapTimeMs = timeout.getMillis();
        }
        if (this.rawLog.isTraceOn()) {
            this.rawLog.trace("Maximum time gap since last byte received for buffer reset = " + timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void messageSent(MbusMessage data) {
        Object object = this.messageSentLock;
        synchronized (object) {
            this.sentMessage = data;
        }
        if (this.rawLog.isTraceOn()) {
            this.rawLog.trace("MessageSent Output = " + (this.sentMessage != null ? ByteArrayUtil.toHexString((byte[])this.sentMessage.getBytes()) : "null"));
        }
    }
}

