/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.db;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusConfig;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.db.BMbusDeviceData;
import com.tridium.mbus.db.BMbusPointData;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.enums.BMbusDeviceTypeId;
import com.tridium.mbus.enums.BMbusFunction;
import com.tridium.mbus.enums.BMbusOrthogonalDescription;
import com.tridium.mbus.enums.BMbusUnit;
import com.tridium.mbus.messages.MbusReceivedLongFrame;
import com.tridium.mbus.utils.MbusToolkit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.collection.Tables;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="statusMessage", type="String", defaultValue="", flags=1), @NiagaraProperty(name="detectedDevices", type="BMbusDeviceData", defaultValue="new BMbusDeviceData()", flags=4), @NiagaraProperty(name="filterStorageNumbers", type="boolean", defaultValue="true", flags=4)})
public final class BMbusNetworkDatabase
extends BComponent {
    @Generated
    public static final Property statusMessage = BMbusNetworkDatabase.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property detectedDevices = BMbusNetworkDatabase.newProperty((int)4, (BValue)new BMbusDeviceData(), null);
    @Generated
    public static final Property filterStorageNumbers = BMbusNetworkDatabase.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMbusNetworkDatabase.class);
    private boolean transientDataAdded = false;
    private Thread restorationThread = null;
    private BAbstractMbusNetwork network = null;
    private BJob activeDiscovery = null;
    private static final Lexicon lex = Lexicon.make(BMbusNetworkDatabase.class);
    private static final BIcon icon = BIcon.std((String)"database.png");

    @Generated
    public String getStatusMessage() {
        return this.getString(statusMessage);
    }

    @Generated
    public void setStatusMessage(String v) {
        this.setString(statusMessage, v, null);
    }

    @Generated
    public BMbusDeviceData getDetectedDevices() {
        return (BMbusDeviceData)this.get(detectedDevices);
    }

    @Generated
    public void setDetectedDevices(BMbusDeviceData v) {
        this.set(detectedDevices, (BValue)v, null);
    }

    @Generated
    public boolean getFilterStorageNumbers() {
        return this.getBoolean(filterStorageNumbers);
    }

    @Generated
    public void setFilterStorageNumbers(boolean v) {
        this.setBoolean(filterStorageNumbers, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.network = (BAbstractMbusNetwork)this.getParent();
        this.setStatusMessage(lex.getText("MbusNetworkManager.statusAwaitingStart"));
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BAbstractMbusNetwork;
    }

    public BIcon getIcon() {
        return icon;
    }

    public BMbusDeviceData[] getDynamicDeviceData() {
        Property[] props = this.getDynamicPropertiesArray();
        Array a = new Array(BMbusDeviceData.class);
        for (int i = 0; i < props.length; ++i) {
            if (!props[i].getType().equals(BMbusDeviceData.TYPE)) continue;
            a.add((Object)((BMbusDeviceData)this.get(props[i])));
        }
        return (BMbusDeviceData[])a.trim();
    }

    private static String constructDeviceName(int newPrimaryAddress, String newSecondaryAddress) {
        String outputName = "";
        outputName = newPrimaryAddress < 0 || newPrimaryAddress > 250 ? detectedDevices.getName() + newSecondaryAddress + "S?" : detectedDevices.getName() + Integer.valueOf(newPrimaryAddress).toString() + "P?";
        return outputName;
    }

    public void removeDevice(int primaryAddress, String secondaryAddress) {
        String name = BMbusNetworkDatabase.constructDeviceName(primaryAddress, secondaryAddress);
        name = name.substring(0, name.length() - 1);
        this.remove(name);
    }

    public BOrd addDevice(BMbusDeviceData inputData) {
        BOrd newDeviceHandle = BOrd.NULL;
        String name = BMbusNetworkDatabase.constructDeviceName(inputData.getPrimaryAddress(), inputData.getSecondaryAddress());
        inputData.setJustDetected(true);
        if (inputData.isMounted()) {
            if (!inputData.getName().equals(inputData.getName())) {
                Property idProp = this.getProperty(inputData.getName());
                this.rename(idProp, name);
            }
        } else if (this.network.savesActive()) {
            this.add(name, (BValue)inputData, 3);
            this.setTransientDataStored();
        } else {
            this.add(name, (BValue)inputData, 1);
        }
        newDeviceHandle = inputData.getHandleOrd();
        StringBuilder buff = new StringBuilder();
        buff.append(this.network.getSlotPathOrd().toString());
        buff.append("|bql:select from mbus:MbusDevice where primaryAddress=");
        buff.append(inputData.getPrimaryAddress());
        buff.append(" and secondaryAddress='");
        buff.append(inputData.getSecondaryAddress());
        buff.append("'");
        BITable result = (BITable)BOrd.make((String)buff.toString()).get((BObject)this.network);
        Tables.slurp((BITable)result);
        try (TableCursor cursor = result.cursor();){
            while (cursor.next()) {
                BMbusDevice d = (BMbusDevice)cursor.row().rowObject();
                d.setIdentNumber(inputData.getIdentNumber());
                d.setManufacturer(inputData.getManufacturer());
                d.setVersionNumber(inputData.getVersionNumber());
                d.setDeviceTypeId(inputData.getDeviceTypeId());
            }
        }
        return newDeviceHandle;
    }

    public void clearAllDetectedDevices() {
        this.removeAll();
    }

    public boolean doesDeviceExistAlready(int newPrimaryAddress, String newSecondaryAddress, String inputModelName) {
        BMbusDeviceData[] currentDevices = this.getDynamicDeviceData();
        if (currentDevices.length > 0) {
            for (int i = 0; i < currentDevices.length; ++i) {
                if (inputModelName != null && !inputModelName.equals("") && inputModelName.equals(currentDevices[i].getModelName())) {
                    return true;
                }
                int primaryAddress = currentDevices[i].getPrimaryAddress();
                if (currentDevices[i].getAddressMode() == BMbusAddressing.primary && newPrimaryAddress >= 0 && newPrimaryAddress <= 250) {
                    if (primaryAddress != newPrimaryAddress) continue;
                    currentDevices[i].setJustDetected(true);
                    return true;
                }
                if (!currentDevices[i].getSecondaryAddress().equals(newSecondaryAddress)) continue;
                currentDevices[i].setJustDetected(true);
                return true;
            }
        }
        return false;
    }

    public void initialiseDelay(int seconds) {
        Date entryDate = new Date();
        long entryTime = entryDate.getTime() / 1000L;
        boolean delay = true;
        while (delay) {
            Date currentDate = new Date();
            long currentTime = currentDate.getTime() / 1000L;
            if (currentTime - entryTime <= (long)seconds) continue;
            delay = false;
        }
    }

    public int addDeviceData(HashSet<String> handleOrdsOfDeviceEntries, MbusReceivedLongFrame message, int cycleNumber, BMbusBaudRate baudRate, BMbusDevice device, BMbusAddressing addressMode, BMbusConfig txRxMbusConfig) {
        if (this.network != null && this.network.getInhibitDatabaseUpdate() && this.activeDiscovery == null) {
            return 0;
        }
        int recordQty = 0;
        int recordsAdded = 0;
        if (message == null) {
            return 0;
        }
        int address = message.getPrimaryAddress();
        String identNumber = message.getIdentNumber();
        String manufacturer = message.getManufacturer();
        int versionNumber = message.getVersionNumber();
        BMbusDeviceTypeId deviceTypeId = message.getDeviceTypeId();
        ArrayList<BMbusPointData> data = message.getData();
        String secondary = message.getSecondaryAddress();
        String modelName = "";
        int readoutModeNumber = 0;
        if (device != null) {
            modelName = device.getModelName();
            readoutModeNumber = device.getReadoutModeNumber();
        }
        recordQty = data.size();
        BMbusPointData[] pointData = new BMbusPointData[recordQty];
        for (int index = 0; index < data.size(); ++index) {
            pointData[index] = data.get(index);
            pointData[index].setCycleNumber(cycleNumber);
            if (!MbusToolkit.isTraceOn()) continue;
            MbusToolkit.trace("Units = " + (Object)((Object)pointData[index].getUnit()));
            MbusToolkit.trace("Description= " + pointData[index].getDescription());
            MbusToolkit.trace("Ortho = " + (Object)((Object)pointData[index].getOrthogonalDescription()));
            MbusToolkit.trace("Rec = " + pointData[index].getRecordNumber());
            MbusToolkit.trace("Cycle = " + pointData[index].getCycleNumber());
            MbusToolkit.trace("Exp = " + pointData[index].getExponent());
            MbusToolkit.trace("NumberType = " + (Object)((Object)pointData[index].getNumberType()));
            MbusToolkit.trace("StNum = " + pointData[index].getStorageNumber());
            MbusToolkit.trace("Function = " + (Object)((Object)pointData[index].getFunction()));
            MbusToolkit.trace("Slot = " + pointData[index].getMessageSlotNumber());
            MbusToolkit.trace("Mode = " + readoutModeNumber);
            MbusToolkit.trace("Model Name = " + modelName);
        }
        if (this.doesDeviceExistAlready(address, secondary, modelName)) {
            BMbusDeviceData existingDeviceData = this.getSpecificDeviceInformation(address, secondary, modelName);
            boolean readData = false;
            if (existingDeviceData != null) {
                existingDeviceData.setManufacturer(manufacturer);
                existingDeviceData.setVersionNumber(versionNumber);
                existingDeviceData.setIdentNumber(identNumber);
                existingDeviceData.setDeviceTypeId(deviceTypeId);
                existingDeviceData.setJustDetected(true);
                for (int i = 0; i < pointData.length; ++i) {
                    String inputDescriptionHold = pointData[i].getDescription();
                    BMbusOrthogonalDescription inputOrthoDescriptionHold = pointData[i].getOrthogonalDescription();
                    BMbusUnit inputUnitHold = pointData[i].getUnit();
                    int inputMessageSlotNumber = pointData[i].getMessageSlotNumber();
                    int inputRecordNumberHold = pointData[i].getRecordNumber();
                    long inputStorageNumber = pointData[i].getStorageNumber();
                    BMbusFunction inputFunction = pointData[i].getFunction();
                    int inputExponent = pointData[i].getExponent();
                    if (!this.getFilterStorageNumbers() || inputStorageNumber >= 0L && inputStorageNumber < 2L) {
                        BMbusPointData[] existingPointData = new BMbusPointData[]{};
                        if (!existingDeviceData.getPointDataInvalid()) {
                            existingPointData = existingDeviceData.getDynamicPointData();
                        }
                        boolean match = false;
                        for (int j = 0; j < existingPointData.length; ++j) {
                            if (!existingPointData[j].getUnit().equals((Object)inputUnitHold) || !existingPointData[j].getDescription().equals(inputDescriptionHold) || existingPointData[j].getRecordNumber() != inputRecordNumberHold || existingPointData[j].getFunction() != inputFunction || existingPointData[j].getMessageSlotNumber() != inputMessageSlotNumber || (long)existingPointData[j].getStorageNumber() != inputStorageNumber || existingPointData[j].getDeviceMode() != readoutModeNumber || !existingPointData[j].getOrthogonalDescription().equals((Object)inputOrthoDescriptionHold)) continue;
                            if (MbusToolkit.isTraceOn()) {
                                MbusToolkit.trace("Matching Units = " + (Object)((Object)inputUnitHold));
                                MbusToolkit.trace("Matching Description = " + inputDescriptionHold);
                                MbusToolkit.trace("Matching Ortho = " + (Object)((Object)inputOrthoDescriptionHold));
                                MbusToolkit.trace("Matching Rec = " + inputRecordNumberHold);
                                MbusToolkit.trace("Matching Cycle = " + cycleNumber);
                                MbusToolkit.trace("Matching Exp = " + existingPointData[j].getExponent());
                                MbusToolkit.trace("Matching NumberType = " + (Object)((Object)existingPointData[j].getNumberType()));
                                MbusToolkit.trace("Matching StNum = " + existingPointData[j].getStorageNumber());
                                MbusToolkit.trace("Matching Function = " + (Object)((Object)existingPointData[j].getFunction()));
                                MbusToolkit.trace("Matching Slot = " + inputMessageSlotNumber);
                                MbusToolkit.trace("Matching Mode = " + existingPointData[j].getDeviceMode());
                            }
                            match = true;
                            break;
                        }
                        if (!match) {
                            if (MbusToolkit.isTraceOn()) {
                                MbusToolkit.trace("BMbusDeviceData: adding in " + inputDescriptionHold + ", units = " + (Object)((Object)inputUnitHold) + ", ortho = " + (Object)((Object)inputOrthoDescriptionHold) + ", function = " + (Object)((Object)inputFunction) + ", exponent = " + inputExponent + ", store = " + inputStorageNumber + ", rec = " + inputRecordNumberHold + ", cycle = " + cycleNumber + ", slot = " + inputMessageSlotNumber + ", mode = " + readoutModeNumber);
                            }
                            pointData[i].setRecordNumber(inputRecordNumberHold);
                            ++recordsAdded;
                            pointData[i].setDeviceMode(readoutModeNumber);
                            if (this.network.savesActive()) {
                                existingDeviceData.add("pointData?", (BValue)pointData[i], 3);
                                this.setTransientDataStored();
                            } else {
                                existingDeviceData.add("pointData?", (BValue)pointData[i], 1);
                            }
                        }
                    }
                    readData = true;
                }
                if (readData && txRxMbusConfig != null) {
                    existingDeviceData.setTxRxMbusConfig((BMbusConfig)txRxMbusConfig.newCopy());
                }
                if (recordsAdded > 0 && existingDeviceData.getBaudRate().getOrdinal() == 300 && baudRate.getOrdinal() > existingDeviceData.getBaudRate().getOrdinal()) {
                    existingDeviceData.setBaudRate((BMbusBaudRate)baudRate.newCopy());
                }
                String newDeviceHandleOrd = this.addDevice(existingDeviceData).toString();
                if (handleOrdsOfDeviceEntries != null) {
                    handleOrdsOfDeviceEntries.add(newDeviceHandleOrd);
                }
            }
        } else {
            boolean fcBitState = this.network.getSearchFcBitState();
            boolean fcBitInUse = this.network.getSearchFcBitInUse();
            BMbusDeviceData dataHold = new BMbusDeviceData(address, secondary, identNumber, manufacturer, versionNumber, deviceTypeId, recordQty < 1 ? BMbusBaudRate.baud300 : baudRate, new BMbusPointData[0], fcBitState, fcBitInUse, addressMode);
            for (int pd = 0; pd < pointData.length; ++pd) {
                int currentStorageNumber = pointData[pd].getStorageNumber();
                if (this.getFilterStorageNumbers() && (currentStorageNumber < 0 || currentStorageNumber >= 2)) continue;
                dataHold.add("pointData?", (BValue)pointData[pd], 1);
            }
            if (txRxMbusConfig != null) {
                dataHold.setTxRxMbusConfig((BMbusConfig)txRxMbusConfig.newCopy(true));
            }
            dataHold.setJustDetected(true);
            String newDeviceHandleOrd = this.addDevice(dataHold).toString();
            if (handleOrdsOfDeviceEntries != null) {
                handleOrdsOfDeviceEntries.add(newDeviceHandleOrd);
            }
            recordsAdded = recordQty;
            this.network.setSearchFcBitState(false);
        }
        return recordsAdded;
    }

    public BMbusDeviceData getSpecificDeviceInformation(BMbusDevice device) {
        return this.getSpecificDeviceInformation(device.getPrimaryAddress(), device.getSecondaryAddress(), device.getModelName());
    }

    public BMbusDeviceData getSpecificDeviceInformation(int inputAddress, String inputSecondary, String modelName) {
        BMbusDeviceData[] currentDevices = this.getDynamicDeviceData();
        if (currentDevices.length > 0) {
            for (int i = 0; i < currentDevices.length; ++i) {
                if (!modelName.equals("") && currentDevices[i].getModelName().equals(modelName)) {
                    return currentDevices[i];
                }
                if (!(currentDevices[i].getAddressMode() == BMbusAddressing.primary ? currentDevices[i].getPrimaryAddress() == inputAddress : currentDevices[i].getSecondaryAddress().equals(inputSecondary))) continue;
                return currentDevices[i];
            }
        }
        return null;
    }

    public void removeDevicePointInformation(int inputAddress, String inputSecondary, String modelName) {
        BMbusDeviceData[] currentDevices = this.getDynamicDeviceData();
        if (currentDevices.length > 0) {
            for (int i = 0; i < currentDevices.length; ++i) {
                if ((modelName.equals("") || !currentDevices[i].getModelName().equals(modelName)) && (currentDevices[i].getPrimaryAddress() != inputAddress || !currentDevices[i].getSecondaryAddress().equals(inputSecondary))) continue;
                currentDevices[i].setPointDataInvalid(true);
                currentDevices[i].removeAll();
                break;
            }
        }
    }

    public void rationalise(BMbusDevice inputDevice) {
        BMbusDeviceData[] currentDevices = this.getDynamicDeviceData();
        BMbusPointData[] inputPointData = null;
        String inputName = "";
        if (!inputDevice.getModelName().equals("") && currentDevices.length > 1) {
            int i;
            for (i = 0; i < currentDevices.length; ++i) {
                if (currentDevices[i].getPrimaryAddress() != inputDevice.getPrimaryAddress() || !currentDevices[i].getSecondaryAddress().equals(inputDevice.getSecondaryAddress())) continue;
                currentDevices[i].setModelName(inputDevice.getModelName());
                inputPointData = currentDevices[i].getDynamicPointData();
                inputName = currentDevices[i].getName();
                break;
            }
            if (inputPointData == null) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("No matching device found in database - rationalise for " + (inputDevice.getSlotPathOrd() == null ? "unknown" : inputDevice.getSlotPathOrd().toString()) + " cancelled");
                }
                return;
            }
            for (i = 0; i < currentDevices.length; ++i) {
                if (!currentDevices[i].getModelName().equals(inputDevice.getModelName()) || currentDevices[i].getPrimaryAddress() == inputDevice.getPrimaryAddress() && currentDevices[i].getSecondaryAddress().equals(inputDevice.getSecondaryAddress())) continue;
                BMbusPointData[] masterPointData = currentDevices[i].getDynamicPointData();
                String masterName = currentDevices[i].getName();
                for (int j = 0; j < inputPointData.length; ++j) {
                    boolean match = false;
                    for (int k = 0; k < masterPointData.length; ++k) {
                        if (!masterPointData[k].getUnit().equals((Object)inputPointData[j].getUnit()) || !masterPointData[k].getDescription().equals(inputPointData[j].getDescription()) || masterPointData[k].getRecordNumber() != inputPointData[j].getRecordNumber() || masterPointData[k].getCycleNumber() != inputPointData[j].getCycleNumber() || masterPointData[k].getMessageSlotNumber() != inputPointData[j].getMessageSlotNumber() || masterPointData[k].getStorageNumber() != inputPointData[j].getStorageNumber() || masterPointData[k].getDeviceMode() != inputPointData[j].getDeviceMode() || !masterPointData[k].getOrthogonalDescription().equals((Object)inputPointData[j].getOrthogonalDescription())) continue;
                        match = true;
                        break;
                    }
                    if (match) continue;
                    if (this.network.savesActive()) {
                        currentDevices[i].add("pointData?", (BValue)inputPointData[j], 3);
                        this.setTransientDataStored();
                        continue;
                    }
                    currentDevices[i].add("pointData?", (BValue)inputPointData[j], 1);
                }
                this.remove(masterName);
                this.addDevice(currentDevices[i]);
                this.remove(inputName);
                break;
            }
        }
    }

    public void clearJustDetected() {
        BMbusDeviceData[] currentDevices = this.getDynamicDeviceData();
        if (currentDevices.length > 0) {
            for (int i = 0; i < currentDevices.length; ++i) {
                currentDevices[i].setJustDetected(false);
            }
        }
    }

    public void setJustDetected() {
        BMbusDeviceData[] currentDevices = this.getDynamicDeviceData();
        if (currentDevices.length > 0) {
            for (int i = 0; i < currentDevices.length; ++i) {
                currentDevices[i].setJustDetected(true);
            }
        }
    }

    private void setTransientDataStored() {
        this.transientDataAdded = true;
    }

    private void cancelRestorationThread() {
        if (this.restorationThread != null) {
            this.restorationThread.interrupt();
            this.restorationThread = null;
        }
    }

    public void persistTransientEntries() throws InterruptedException {
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace("Updating internal transient DB data to non-transient");
        }
        BMbusNetworkDatabase.restoreChildren((BObject)this);
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace("Completed updating internal transient DB data to non-transient");
        }
        this.transientDataAdded = false;
    }

    public void startRestoration() {
        this.cancelRestorationThread();
        if (this.transientDataAdded) {
            this.restorationThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        BMbusNetworkDatabase.this.persistTransientEntries();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            this.restorationThread.setName(this.network.getHandleOrd() + "-DB-Restoration");
            this.restorationThread.start();
        } else if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace("No internal transient DB data to transform to non-transient");
        }
    }

    private static void restoreChildren(BObject element) throws InterruptedException {
        if (element instanceof BComplex) {
            SlotCursor sc = ((BComplex)element).getProperties();
            while (sc.next()) {
                if (Thread.interrupted()) {
                    throw new InterruptedException("Thread Interrupted");
                }
                int currentFlags = ((BComplex)element).getFlags(sc.slot());
                ((BComplex)element).setFlags(sc.slot(), currentFlags & 0xFFFFFFFD);
                BMbusNetworkDatabase.restoreChildren((BObject)sc.get());
            }
        }
    }

    public void spy(SpyWriter out) throws Exception {
        block2: {
            super.spy(out);
            out.startProps("Database Update Management");
            try {
                boolean updatesAllowed = this.network == null || !this.network.getInhibitDatabaseUpdate() || this.activeDiscovery != null;
                out.prop((Object)"updatesAllowed", (Object)String.valueOf(updatesAllowed));
                out.prop((Object)"activeDiscovery", (Object)(this.activeDiscovery == null ? "None" : this.activeDiscovery.getName()));
                out.prop((Object)"networkBasedInhibit", (Object)(this.network != null ? String.valueOf(this.network.getInhibitDatabaseUpdate()) : "Unknown"));
            }
            catch (Exception e) {
                if (!MbusToolkit.isTraceOn()) break block2;
                MbusToolkit.trace("Exception occurred during spy operation", e);
            }
        }
        out.endProps();
    }

    public void setActiveDiscovery(BJob discoveryJob) {
        this.activeDiscovery = discoveryJob;
    }

    public void cancelActiveDiscovery(BJob discoveryJob) {
        if (this.activeDiscovery != null && this.activeDiscovery.equals((Object)discoveryJob)) {
            this.activeDiscovery = null;
        }
    }
}

