/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.jobs;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusTcpIpNetwork;
import com.tridium.mbus.actionArgSets.BPrimaryDiscoverOptions;
import com.tridium.mbus.db.BMbusDeviceData;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.jobs.BMbusDeviceSearchJob;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusToolkit;
import java.util.HashSet;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.serial.BBaudRate;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="discoveryOptions", type="BPrimaryDiscoverOptions", defaultValue="new BPrimaryDiscoverOptions()"), @NiagaraProperty(name="singleDeviceScan", type="boolean", defaultValue="false")})
@NiagaraAction(name="handleNewPrimaryAddressFound", parameterType="BInteger", defaultValue="BInteger.make(-1)")
public class BMbusPrimaryDeviceSearchJob
extends BSimpleJob {
    @Generated
    public static final Property discoveryOptions = BMbusPrimaryDeviceSearchJob.newProperty((int)0, (BValue)new BPrimaryDiscoverOptions(), null);
    @Generated
    public static final Property singleDeviceScan = BMbusPrimaryDeviceSearchJob.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Action handleNewPrimaryAddressFound = BMbusPrimaryDeviceSearchJob.newAction((int)0, (BValue)BInteger.make((int)-1), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMbusPrimaryDeviceSearchJob.class);
    protected BBaudRate currentScanBaudRate = null;
    protected final Object addressesToScanLock = new Object();
    protected Array<BInteger> addressesToScan = new Array(BInteger.class);
    protected BSimpleJob activeChildJob = null;
    protected BAbstractMbusNetwork networkRef;
    protected double baseProgress = 0.0;
    protected double progressPerScan = 100.0;

    @Generated
    public BPrimaryDiscoverOptions getDiscoveryOptions() {
        return (BPrimaryDiscoverOptions)this.get(discoveryOptions);
    }

    @Generated
    public void setDiscoveryOptions(BPrimaryDiscoverOptions v) {
        this.set(discoveryOptions, (BValue)v, null);
    }

    @Generated
    public boolean getSingleDeviceScan() {
        return this.getBoolean(singleDeviceScan);
    }

    @Generated
    public void setSingleDeviceScan(boolean v) {
        this.setBoolean(singleDeviceScan, v, null);
    }

    @Generated
    public void handleNewPrimaryAddressFound(BInteger parameter) {
        this.invoke(handleNewPrimaryAddressFound, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMbusPrimaryDeviceSearchJob() {
    }

    public BMbusPrimaryDeviceSearchJob(BAbstractMbusNetwork networkRef) {
        this.networkRef = networkRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandleNewPrimaryAddressFound(BInteger addr) {
        if (addr.getInt() < 0 || addr.getInt() > 250) {
            return;
        }
        Object object = this.addressesToScanLock;
        synchronized (object) {
            this.addressesToScan.remove((Object)addr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        String commLock = "PrimaryDeviceSearch" + this.getHandle();
        try {
            this.doCommsLockedRun(cx, commLock);
        }
        catch (Throwable e) {
            if (MbusLogInputOutput.log.isTraceOn()) {
                MbusLogInputOutput.log.trace("Exception occurred during doCommsLockedRun", e);
            }
            this.networkRef.unlockSends(commLock);
            this.networkRef = null;
            this.activeChildJob = null;
            this.currentScanBaudRate = null;
            this.addressesToScan = null;
            if (e instanceof JobCancelException) {
                throw (JobCancelException)e;
            }
        }
        finally {
            this.networkRef.unlockSends(commLock);
            this.networkRef = null;
            this.activeChildJob = null;
            this.currentScanBaudRate = null;
            this.addressesToScan = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void doCommsLockedRun(Context cx, Object commLock) throws Exception {
        this.log().message(MbusToolkit.getText("MbusNetworkDeviceSearch.startingScan"));
        Object[] baudRatesToScan = this.getDiscoveryOptions().getBaudRates().getChildren(BBaudRate.class);
        this.networkRef.getNetworkDatabase().setActiveDiscovery((BJob)this);
        if (baudRatesToScan.length == 0) {
            if (!(this.networkRef instanceof BMbusTcpIpNetwork)) {
                this.log().message(MbusToolkit.getText("MbusNetworkDeviceSearch.noBaudRatesSpecified"));
                throw new Exception("Baud rates must be set");
            }
            this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.tcpipConverterSlowBaudSet", new Object[]{BMbusBaudRate.baud300.getTypeDisplayName(null)}));
            baudRatesToScan = new BBaudRate[]{BMbusBaudRate.baud300};
        } else {
            this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.baudRatesToScan", new Object[]{String.valueOf(baudRatesToScan.length)}));
            for (int i = 0; i < baudRatesToScan.length; ++i) {
                this.log().message("-> " + ((BBaudRate)baudRatesToScan[i]).getDisplayTag(cx));
            }
        }
        this.networkRef.lockSends(commLock);
        this.addressesToScan = this.getDiscoveryOptions().getAddrRange().getRangeAsBIntegerArray();
        this.progressPerScan = 100.0 / (double)baudRatesToScan.length;
        HashSet<String> databaseEntries = new HashSet<String>();
        for (int brIdx = 0; brIdx < baudRatesToScan.length && this.getJobState().equals((Object)BJobState.running); ++brIdx) {
            this.currentScanBaudRate = (BBaudRate)baudRatesToScan[brIdx];
            if (!this.getSingleDeviceScan()) {
                int[] primaryAddressesToScan = this.getAddressesToScan();
                this.activeChildJob = new BMbusDeviceSearchJob(this.networkRef, primaryAddressesToScan, this.log());
            } else {
                this.activeChildJob = new BMbusDeviceSearchJob(this.networkRef, new int[]{254}, this.log());
            }
            ((BMbusDeviceSearchJob)this.activeChildJob).setOverrideTxTimings(this.getDiscoveryOptions().getTxRxProfile().getMBusTxTimings());
            ((BMbusDeviceSearchJob)this.activeChildJob).overrideCommLock(commLock);
            BLink activeChildJobLink = this.linkTo((BComponent)this.activeChildJob, (Slot)BMbusDeviceSearchJob.deviceFoundAtAddress, (Slot)handleNewPrimaryAddressFound);
            if (this.currentScanBaudRate instanceof BMbusBaudRate) {
                this.networkRef.setSearchBaudRate((BMbusBaudRate)this.currentScanBaudRate);
            }
            this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.startingBaudRateScan", new Object[]{this.currentScanBaudRate}));
            this.activeChildJob.submit(cx);
            BJobState finalJobState = this.waitForFinalState((BJob)this.activeChildJob);
            while (finalJobState == BJobState.running) {
                finalJobState = this.waitForFinalState((BJob)this.activeChildJob);
            }
            switch (finalJobState.getOrdinal()) {
                case 4: {
                    this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.completedScanAtBaud", new Object[]{this.currentScanBaudRate}));
                    break;
                }
                case 5: {
                    this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.failedScanAtBaud", new Object[]{this.currentScanBaudRate}));
                    break;
                }
                case 3: {
                    this.log().message(MbusToolkit.lex.getText("MbusNetworkDeviceSearch.cancelledScanAtBaud", new Object[]{this.currentScanBaudRate}));
                    break;
                }
            }
            this.remove((BComplex)activeChildJobLink);
            this.baseProgress = 100.0 / (double)baudRatesToScan.length * (double)(brIdx + 1);
            this.progress((int)this.baseProgress);
            if (this.getSingleDeviceScan() && ((BMbusDeviceSearchJob)this.activeChildJob).getNumberOfDetectedDevices() > 0) {
                this.progress(100);
                databaseEntries.addAll(((BMbusDeviceSearchJob)this.activeChildJob).getDetectedDevicesHandleOrds());
                break;
            }
            databaseEntries.addAll(((BMbusDeviceSearchJob)this.activeChildJob).getDetectedDevicesHandleOrds());
        }
        this.networkRef.getNetworkDatabase().cancelActiveDiscovery((BJob)this);
        this.networkRef.getNetworkDatabase().clearJustDetected();
        Object[] dbHandleOrds = databaseEntries.toArray();
        for (int i = 0; i < dbHandleOrds.length; ++i) {
            ((BMbusDeviceData)BOrd.make((String)((String)dbHandleOrds[i])).get((BObject)this)).setJustDetected(true);
        }
        this.currentScanBaudRate = null;
        this.addressesToScan = null;
        this.currentScanBaudRate = null;
        this.activeChildJob = null;
        if (this.getJobState().equals((Object)BJobState.canceling)) {
            throw new JobCancelException();
        }
    }

    public BJobState waitForFinalState(BJob jobToMonitor) {
        switch (jobToMonitor.getJobState().getOrdinal()) {
            case 3: {
                return BJobState.canceled;
            }
            case 4: {
                return BJobState.success;
            }
            case 5: {
                return BJobState.failed;
            }
            case 0: {
                return BJobState.unknown;
            }
        }
        JobMonitor jobMon = new JobMonitor(jobToMonitor, (BJob)this);
        jobMon.subscribe((BComponent)jobToMonitor);
        jobMon.waitForFinalState();
        jobMon.unsubscribe((BComponent)jobToMonitor);
        return jobToMonitor.getJobState();
    }

    public void doCancel(Context cx) {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        }
        if (this.activeChildJob != null) {
            this.activeChildJob.doCancel(cx);
        }
        super.doCancel(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] getAddressesToScan() {
        int[] result;
        if (this.addressesToScan == null) {
            return new int[0];
        }
        Object object = this.addressesToScanLock;
        synchronized (object) {
            result = new int[this.addressesToScan.size()];
            Object[] internalArrayRef = this.addressesToScan.array();
            for (int i = 0; i < this.addressesToScan.size(); ++i) {
                result[i] = ((BInteger)internalArrayRef[i]).getInt();
            }
        }
        return result;
    }

    protected class JobMonitor
    extends Subscriber {
        private final Object threadLock = new Object();
        BJob jobToMonitor;
        BJob blockedJob;

        public JobMonitor(BJob jobToMonitor, BJob blockedJob) {
            this.jobToMonitor = jobToMonitor;
            this.blockedJob = blockedJob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void event(BComponentEvent event) {
            if (event.getSlotName().equals(BJob.jobState.getName())) {
                Object object = this.threadLock;
                synchronized (object) {
                    this.threadLock.notifyAll();
                }
            } else if (event.getSlotName().equals(BJob.progress.getName())) {
                int progress = (int)(BMbusPrimaryDeviceSearchJob.this.baseProgress + BMbusPrimaryDeviceSearchJob.this.progressPerScan / 100.0 * ((BInteger)event.getValue()).getDouble());
                if (((BInteger)event.getValue()).getDouble() > 100.0) {
                    progress = (int)(BMbusPrimaryDeviceSearchJob.this.baseProgress + 100.0 / BMbusPrimaryDeviceSearchJob.this.progressPerScan);
                }
                this.blockedJob.progress(progress);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForFinalState() {
            Object object = this.threadLock;
            synchronized (object) {
                while (this.jobToMonitor.getJobState() == BJobState.running) {
                    try {
                        this.threadLock.wait(10000L);
                        this.blockedJob.heartbeat();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

