/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.utils;

public final class MbusCrcGenerator {
    private MbusCrcGenerator() {
    }

    public static byte mBus(byte[] input) {
        if (input.length == 5) {
            return MbusCrcGenerator.shortFrameChecksum(input);
        }
        return MbusCrcGenerator.controlLongFrameChecksum(input);
    }

    private static byte shortFrameChecksum(byte[] input) {
        int checksum = 0;
        for (int i = 1; i < input.length - 2; ++i) {
            checksum = checksum + input[i] & 0xFF;
        }
        return (byte)(checksum & 0xFF);
    }

    private static byte controlLongFrameChecksum(byte[] input) {
        int checksum = 0;
        for (int i = 4; i < input.length - 2; ++i) {
            checksum = checksum + input[i] & 0xFF;
        }
        return (byte)(checksum & 0xFF);
    }
}

