/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.utils;

import com.tridium.mbus.db.BMbusPointData;
import com.tridium.mbus.enums.BMbusDescription;
import com.tridium.mbus.enums.BMbusFunction;
import com.tridium.mbus.enums.BMbusOrthogonalDescription;
import com.tridium.mbus.enums.BMbusUnit;
import com.tridium.mbus.messages.MbusReceivedLongFrame;
import com.tridium.mbus.utils.MbusDateCalculator;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusSortedDataInformation;
import com.tridium.mbus.utils.MbusToolkit;
import java.util.ArrayList;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;

public final class MbusDataSort {
    private MbusDataSort() {
    }

    public static MbusSortedDataInformation[] sort(MbusReceivedLongFrame input, BMbusUnit inputUnit, String inputDescription, BMbusOrthogonalDescription inputOrthoDescription, int inputSlotNumber, int inputRecordNumber, int inputStorageNumber, BMbusFunction inputFunction, int inputExponent, boolean pointTypeData) {
        ArrayList<BMbusPointData> data = input.getData();
        int dataRecordQty = data.size();
        int minStorageNumber = 0;
        if (!pointTypeData && inputStorageNumber != 0) {
            if (inputStorageNumber < 0) {
                minStorageNumber = -1;
            }
            BAbsTime[] dateHold = new BAbsTime[dataRecordQty];
            int[] dateStorageNumbers = new int[dataRecordQty];
            for (int j = 0; j < dataRecordQty; ++j) {
                dateHold[j] = BAbsTime.now();
                dateStorageNumbers[j] = 0;
            }
            BStatusValue[] valueHold = new BStatusValue[dataRecordQty];
            int[] orderHold = new int[dataRecordQty];
            int numberOfValues = 0;
            boolean storageBlockDetected = false;
            int storageBlockIndex = 0;
            int storageBlockLength = 0;
            int storageDateIndex = -1;
            int storageIntervalIndex = -1;
            int numberOfDates = 0;
            for (int i = 0; i < dataRecordQty; ++i) {
                int dateStorageNumber;
                BMbusPointData dataInformation = data.get(i);
                if (dataInformation.getRecordNumber() != inputRecordNumber) continue;
                if (dataInformation.getDescription().equals(BMbusDescription.sizeOfStorageBlock.toString())) {
                    storageBlockDetected = true;
                    storageBlockIndex = i;
                    storageBlockLength = (int)((BStatusNumeric)dataInformation.getValue()).getNumeric();
                    continue;
                }
                if (dataInformation.getUnit().equals((Object)inputUnit) && dataInformation.getDescription().equals(inputDescription) && dataInformation.getStorageNumber() > minStorageNumber && dataInformation.getFunction().equals((Object)inputFunction) && dataInformation.getOrthogonalDescription().equals((Object)inputOrthoDescription)) {
                    valueHold[numberOfValues] = dataInformation.getValue();
                    orderHold[numberOfValues] = dataInformation.getStorageNumber();
                    ++numberOfValues;
                    if (!storageBlockDetected || i >= storageBlockIndex + 3 && i <= storageBlockIndex + 2 + storageBlockLength) continue;
                    storageBlockDetected = false;
                    storageBlockIndex = 0;
                    storageBlockLength = 0;
                    continue;
                }
                if (storageBlockDetected) {
                    if (dataInformation.getDescription().equals(BMbusDescription.date.toString())) {
                        storageDateIndex = i;
                        continue;
                    }
                    if (!dataInformation.getDescription().equals(BMbusDescription.storageInterval.toString())) continue;
                    storageIntervalIndex = i;
                    continue;
                }
                if (!dataInformation.getDescription().equals(BMbusDescription.date.toString()) && !dataInformation.getDescription().equals(BMbusDescription.dateAndTime.toString()) && !dataInformation.getOrthogonalDescription().equals((Object)BMbusOrthogonalDescription.startDate) || (dateStorageNumber = dataInformation.getStorageNumber()) <= minStorageNumber) continue;
                dateHold[numberOfDates] = BAbsTime.make((long)((long)((BStatusNumeric)dataInformation.getValue()).getValue()));
                dateStorageNumbers[numberOfDates] = dateStorageNumber;
                ++numberOfDates;
            }
            if (MbusToolkit.isTraceOn()) {
                MbusToolkit.trace("MBUSDATASORT: NumberOfValues= " + numberOfValues + " Number of Dates= " + numberOfDates + " Storage block detected= " + storageBlockDetected);
            }
            MbusSortedDataInformation[] sortedData = null;
            if (numberOfValues > 1) {
                BAbsTime currentDate = BAbsTime.now();
                BStatusValue currentValue = null;
                sortedData = new MbusSortedDataInformation[numberOfValues];
                int currentIndex = 0;
                if (!storageBlockDetected) {
                    for (int m = 0; m < numberOfValues; ++m) {
                        MbusSortedDataInformation dataHold;
                        currentIndex = orderHold[m];
                        currentValue = valueHold[m];
                        currentDate = BAbsTime.now();
                        for (int n = 0; n < numberOfDates; ++n) {
                            if (dateStorageNumbers[n] != currentIndex) continue;
                            currentDate = dateHold[n];
                            break;
                        }
                        sortedData[numberOfValues - 1 - m] = dataHold = new MbusSortedDataInformation(currentValue, currentDate);
                    }
                } else {
                    BAbsTime startDate = BAbsTime.now();
                    if (storageDateIndex > -1) {
                        BMbusPointData dataInformation = data.get(storageDateIndex);
                        startDate = BAbsTime.make((long)((long)((BStatusNumeric)dataInformation.getValue()).getValue()));
                    }
                    int intervalValue = 1;
                    BMbusUnit intervalUnits = BMbusUnit.seconds;
                    if (storageIntervalIndex > -1) {
                        BMbusPointData dataInformation = data.get(storageIntervalIndex);
                        intervalValue = (int)((BStatusNumeric)dataInformation.getValue()).getValue();
                        intervalUnits = dataInformation.getUnit();
                    }
                    for (int n = 0; n < numberOfValues; ++n) {
                        MbusSortedDataInformation dataHold;
                        currentIndex = orderHold[n];
                        currentValue = valueHold[n];
                        BAbsTime intervalDate = MbusDateCalculator.calc(startDate, intervalUnits, intervalValue, numberOfValues - currentIndex);
                        sortedData[currentIndex - 1] = dataHold = new MbusSortedDataInformation(currentValue, intervalDate);
                    }
                }
            } else {
                if (numberOfValues == 1) {
                    sortedData = new MbusSortedDataInformation[]{new MbusSortedDataInformation(valueHold[0], BAbsTime.now())};
                }
                return sortedData;
            }
            return sortedData;
        }
        if (MbusToolkit.isTraceOn()) {
            MbusLogInputOutput.log.trace("MBUSDATASORT: In Single Value");
        }
        MbusSortedDataInformation[] singleValue = null;
        for (int i = 0; i < dataRecordQty; ++i) {
            BMbusPointData dataInformation = data.get(i);
            if (!dataInformation.getUnit().equals((Object)inputUnit) || !dataInformation.getDescription().equals(inputDescription) || !dataInformation.getFunction().equals((Object)inputFunction) || dataInformation.getRecordNumber() != inputRecordNumber || dataInformation.getStorageNumber() != inputStorageNumber || !dataInformation.getOrthogonalDescription().equals((Object)inputOrthoDescription) || inputStorageNumber <= 0 && dataInformation.getMessageSlotNumber() != inputSlotNumber) continue;
            singleValue = new MbusSortedDataInformation[]{new MbusSortedDataInformation(dataInformation.getValue(), BAbsTime.now())};
        }
        return singleValue;
    }
}

