/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.utils;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.util.Lexicon;

public final class MbusToolkit {
    public static final Lexicon lex = Lexicon.make(MbusToolkit.class);
    private static Logger logger = Logger.getLogger("MBusNetwork_unknown");

    private MbusToolkit() {
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger newLog) {
        if (!newLog.getName().equals("null_none")) {
            logger = newLog;
        }
    }

    public static boolean isTraceOn() {
        if (logger != null) {
            return logger.isLoggable(Level.FINE);
        }
        return false;
    }

    public static void trace(String str) {
        MbusToolkit.trace(str, null);
    }

    public static void trace(String str, Exception e) {
        if (logger != null) {
            logger.log(Level.FINE, str, e);
        } else {
            System.err.println("Log is null when logging \"" + str + "\" with exception " + e);
        }
    }

    public static void error(String str) {
        MbusToolkit.error(str, null);
    }

    public static void error(String str, Throwable t) {
        if (logger != null) {
            logger.log(Level.SEVERE, str, t);
        } else {
            System.err.println("Log is null when logging \"" + str + "\" with throwable " + t);
        }
    }

    public static String getText(String str) {
        return lex.getText(str);
    }
}

