/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.server;

import com.tridium.history.rollup.BHistoryRollupRecord;
import com.tridium.obix.naming.ObixTarget;
import com.tridium.obix.server.BObixAgent;
import com.tridium.obix.util.ObixUtils;
import com.tridium.obix.util.Obj;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.BTrendRecord;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.io.BIObixAgent;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

@NiagaraType(agent={@AgentOn(types={"history:IHistory"}, requiredPermissions="r")})
public class BObixHistoryAgent
extends BObixAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BObixHistoryAgent.class);
    private static final BTime LAST_INSTANT = BTime.make((int)23, (int)59, (int)59, (int)999);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void encodeFinishing() throws Exception {
        super.encodeFinishing();
        BIHistory history = (BIHistory)this.getTarget().get();
        ObixEncoder out = this.getEncoder();
        String href = out.getHref();
        BTimeZone tz = history.getConfig().getTimeZone();
        Obj obj = new Obj();
        try (HistorySpaceConnection conn = ((BHistorySpace)history.getSpace()).getConnection(null);){
            obj.initInt("count", conn.getRecordCount(history));
            obj.write(out, false);
            obj.initAbstime("start", ObixUtils.dateTime(BAbsTime.make((BAbsTime)conn.getFirstTimestamp(history), (BTimeZone)tz))).setTz(tz.getId());
            obj.write(out, false);
            obj.initAbstime("end", ObixUtils.dateTime(BAbsTime.make((BAbsTime)conn.getLastTimestamp(history), (BTimeZone)tz))).setTz(tz.getId());
            obj.write(out, false);
        }
        obj.initOp("query", "/obix/def/obix:HistoryFilter", "/obix/def/obix:HistoryQueryOut");
        obj.setHref(out.getChildHref(href, "~historyQuery"));
        obj.write(out, false);
        obj.initOp("rollup", "/obix/def/obix:HistoryRollupIn", "/obix/def/obix:HistoryRollupOut");
        obj.setHref(out.getChildHref(href, "~historyRollup"));
        obj.write(out, false);
        obj.initFeed("feed", "/obix/def/obix:HistoryFilter", "/obix/def/obix:HistoryRecord");
        obj.setHref(out.getChildHref(href, "~historyFeed"));
        obj.write(out, false);
        obj.initOp("append", "/obix/def/obix:HistoryAppendIn", "/obix/def/obix:HistoryAppendOut");
        obj.setHref(out.getChildHref(href, "~historyAppend"));
        obj.write(out, false);
        BAbsTime now = BAbsTime.now();
        now = BAbsTime.make((BAbsTime)now, (BTimeZone)tz);
        String obixNow = ObixUtils.dateTime(now);
        obj.initRef("unboundedQuery", "~historyQuery?limit=1000");
        obj.write(out, false);
        BAbsTime todayStart = BAbsTime.make((BAbsTime)now, (BTime)BTime.MIDNIGHT);
        todayStart = BAbsTime.make((BAbsTime)todayStart, (BTimeZone)tz);
        obj.initRef("today", "~historyQuery?start=" + ObixUtils.dateTime(todayStart) + "&end=" + obixNow);
        obj.write(out, false);
        BAbsTime yesterdayNow = now.subtract(BRelTime.DAY);
        yesterdayNow = BAbsTime.make((BAbsTime)yesterdayNow, (BTimeZone)tz);
        obj.initRef("last24Hours", "~historyQuery?start=" + ObixUtils.dateTime(yesterdayNow) + "&end=" + obixNow);
        obj.write(out, false);
        BAbsTime yesterdayStart = todayStart.subtract(BRelTime.DAY);
        BAbsTime yesterdayEnd = BAbsTime.make((BAbsTime)yesterdayStart, (BTime)LAST_INSTANT);
        yesterdayStart = BAbsTime.make((BAbsTime)yesterdayStart, (BTimeZone)tz);
        yesterdayEnd = BAbsTime.make((BAbsTime)yesterdayEnd, (BTimeZone)tz);
        obj.initRef("yesterday", "~historyQuery?start=" + ObixUtils.dateTime(yesterdayStart) + "&end=" + ObixUtils.dateTime(yesterdayEnd));
        obj.write(out, false);
        BAbsTime weekStart = now;
        while (weekStart.getWeekday() != BWeekday.sunday) {
            weekStart = weekStart.prevDay();
        }
        weekStart = BAbsTime.make((BAbsTime)weekStart, (BTime)BTime.MIDNIGHT);
        weekStart = BAbsTime.make((BAbsTime)weekStart, (BTimeZone)tz);
        obj.initRef("weekToDate", "~historyQuery?start=" + ObixUtils.dateTime(weekStart) + "&end=" + obixNow);
        obj.write(out, false);
        BAbsTime weekEnd = now;
        while (weekEnd.getWeekday() != BWeekday.sunday) {
            weekEnd = weekEnd.prevDay();
        }
        weekEnd = weekEnd.prevDay();
        weekStart = weekEnd = BAbsTime.make((BAbsTime)weekEnd, (BTime)LAST_INSTANT);
        while (weekStart.getWeekday() != BWeekday.sunday) {
            weekStart = weekStart.prevDay();
        }
        weekStart = BAbsTime.make((BAbsTime)weekStart, (BTimeZone)tz);
        weekEnd = BAbsTime.make((BAbsTime)weekEnd, (BTimeZone)tz);
        obj.initRef("lastWeek", "~historyQuery?start=" + ObixUtils.dateTime(weekStart) + "&end=" + ObixUtils.dateTime(weekEnd));
        obj.write(out, false);
        BAbsTime yesterweekNow = yesterdayNow.prevDay().prevDay().prevDay().prevDay().prevDay().prevDay();
        yesterweekNow = BAbsTime.make((BAbsTime)yesterweekNow, (BTimeZone)tz);
        obj.initRef("last7Days", "~historyQuery?start=" + ObixUtils.dateTime(yesterweekNow) + "&end=" + obixNow);
        obj.write(out, false);
        BAbsTime monthStart = BAbsTime.make((int)now.getYear(), (BMonth)now.getMonth(), (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)now.getTimeZone());
        monthStart = BAbsTime.make((BAbsTime)monthStart, (BTimeZone)tz);
        obj.initRef("monthToDate", "~historyQuery?start=" + ObixUtils.dateTime(monthStart) + "&end=" + obixNow);
        obj.write(out, false);
        BAbsTime lastMonthStart = now.prevMonth();
        lastMonthStart = BAbsTime.make((int)lastMonthStart.getYear(), (BMonth)lastMonthStart.getMonth(), (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)lastMonthStart.getTimeZone());
        BAbsTime lastMonthEnd = BAbsTime.make((int)lastMonthStart.getYear(), (BMonth)lastMonthStart.getMonth(), (int)BAbsTime.getDaysInMonth((int)lastMonthStart.getYear(), (BMonth)lastMonthStart.getMonth()), (int)LAST_INSTANT.getHour(), (int)LAST_INSTANT.getMinute(), (int)LAST_INSTANT.getSecond(), (int)LAST_INSTANT.getMillisecond(), (BTimeZone)lastMonthStart.getTimeZone());
        lastMonthStart = BAbsTime.make((BAbsTime)lastMonthStart, (BTimeZone)tz);
        lastMonthEnd = BAbsTime.make((BAbsTime)lastMonthEnd, (BTimeZone)tz);
        obj.initRef("lastMonth", "~historyQuery?start=" + ObixUtils.dateTime(lastMonthStart) + "&end=" + ObixUtils.dateTime(lastMonthEnd));
        obj.write(out, false);
        BAbsTime yearStart = BAbsTime.make((int)now.getYear(), (BMonth)BMonth.january, (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)now.getTimeZone());
        yearStart = BAbsTime.make((BAbsTime)yearStart, (BTimeZone)tz);
        obj.initRef("yearToDate (limit=1000)", "~historyQuery?start=" + ObixUtils.dateTime(yearStart) + "&end=" + obixNow + "&limit=1000");
        obj.write(out, false);
        BAbsTime lastYearStart = BAbsTime.make((int)(now.getYear() - 1), (BMonth)BMonth.january, (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)now.getTimeZone());
        BAbsTime lastYearEnd = BAbsTime.make((int)lastYearStart.getYear(), (BMonth)BMonth.december, (int)BAbsTime.getDaysInMonth((int)lastYearStart.getYear(), (BMonth)BMonth.december), (int)LAST_INSTANT.getHour(), (int)LAST_INSTANT.getMinute(), (int)LAST_INSTANT.getSecond(), (int)LAST_INSTANT.getMillisecond(), (BTimeZone)lastMonthStart.getTimeZone());
        lastYearStart = BAbsTime.make((BAbsTime)lastYearStart, (BTimeZone)tz);
        lastYearEnd = BAbsTime.make((BAbsTime)lastYearEnd, (BTimeZone)tz);
        obj.initRef("lastYear (limit=1000)", "~historyQuery?start=" + ObixUtils.dateTime(lastYearStart) + "&end=" + ObixUtils.dateTime(lastYearEnd) + "&limit=1000");
        obj.write(out, false);
    }

    @Override
    public String processAttr(String name, String value) {
        if (name.equals("is")) {
            return BIObixAgent.addToList(value, "obix:History");
        }
        return value;
    }

    public static boolean isHidden(BHistoryRecord rec) {
        if (rec instanceof BTrendRecord) {
            return ((BTrendRecord)rec).getTrendFlags().getBit(4);
        }
        return false;
    }

    static QueryResults iterateQueryResults(ObixEncoder out, BITable<BHistoryRecord> results, BInteger limit, OrdTarget cx, BTimeZone tz) {
        return BObixHistoryAgent.iterateQueryResults(out, results, limit, cx, BFacets.make((String)"TimeZone", (BIDataValue)tz));
    }

    static QueryResults iterateQueryResults(ObixEncoder out, BITable<BHistoryRecord> results, BInteger limit, OrdTarget cx, BFacets valueFacets, BTimeZone tz) {
        BFacets f = BFacets.NULL;
        if (valueFacets != null) {
            f = tz != null ? BFacets.make((BFacets)valueFacets, (String)"TimeZone", (BIDataValue)tz) : valueFacets;
        } else if (tz != null) {
            f = BFacets.make((String)"TimeZone", (BIDataValue)tz);
        }
        return BObixHistoryAgent.iterateQueryResults(out, results, limit, cx, f);
    }

    private static QueryResults iterateQueryResults(ObixEncoder out, BITable<BHistoryRecord> results, BInteger limit, OrdTarget cx, BFacets facets) {
        int count = 0;
        BHistoryRecord first = null;
        BHistoryRecord last = null;
        try (TableCursor cur = results.cursor();){
            BHistoryRecord rec = null;
            int max = Integer.MAX_VALUE;
            if (limit != null) {
                max = limit.getInt();
            }
            if (cur.next()) {
                rec = (BHistoryRecord)cur.get();
            }
            if (rec != null) {
                last = first = (BHistoryRecord)rec.newCopy(true);
            }
            boolean isIncludeHiddenRecords = out.isIncludeHiddenRecords();
            while (count < max && rec != null) {
                if (isIncludeHiddenRecords || !BObixHistoryAgent.isHidden(rec)) {
                    ++count;
                    if (last.getTimestamp().isBefore(rec.getTimestamp())) {
                        last = (BHistoryRecord)rec.newCopy(true);
                    }
                    out.encode(new ObixTarget(cx, (BObject)rec, facets));
                    out.commit();
                }
                if (cur.next()) {
                    rec = (BHistoryRecord)cur.get();
                    continue;
                }
                rec = null;
            }
        }
        catch (Exception x) {
            out.encode(x);
        }
        QueryResults ret = new QueryResults();
        ret.count = count;
        ret.first = first;
        ret.last = last;
        return ret;
    }

    static RollupResults iterateRollupResults(ObixEncoder out, BITable<BHistoryRollupRecord> results, BInteger limit, OrdTarget cx) {
        int count = 0;
        BHistoryRollupRecord first = null;
        BHistoryRollupRecord last = null;
        try (TableCursor cur = results.cursor();){
            BHistoryRollupRecord rec = null;
            int max = Integer.MAX_VALUE;
            if (limit != null) {
                max = limit.getInt();
            }
            if (cur.next()) {
                rec = (BHistoryRollupRecord)cur.get();
            }
            if (rec != null) {
                last = first = (BHistoryRollupRecord)rec.newCopy(true);
            }
            while (count < max && rec != null) {
                ++count;
                if (last.getTimestamp().isBefore(rec.getTimestamp())) {
                    last = (BHistoryRollupRecord)rec.newCopy(true);
                }
                out.encode(new ObixTarget(cx, (BObject)rec));
                out.commit();
                if (cur.next()) {
                    rec = (BHistoryRollupRecord)cur.get();
                    continue;
                }
                rec = null;
            }
        }
        catch (Exception x) {
            out.encode(x);
        }
        RollupResults ret = new RollupResults();
        ret.count = count;
        ret.first = first;
        ret.last = last;
        return ret;
    }

    static class RollupResults {
        int count;
        BHistoryRollupRecord first;
        BHistoryRollupRecord last;

        RollupResults() {
        }
    }

    static class QueryResults {
        int count;
        BHistoryRecord first;
        BHistoryRecord last;

        QueryResults() {
        }
    }
}

