/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.server;

import com.tridium.obix.server.BObixHistoryAgent;
import com.tridium.obix.util.ContextWrapper;
import com.tridium.obix.util.ObixUtils;
import com.tridium.obix.util.Obj;
import javax.baja.collection.BITable;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryQuery;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.io.BIObixEncodable;
import javax.baja.obix.io.BIObixWatchable;
import javax.baja.obix.io.ObixDecoder;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.xml.XElem;

@NiagaraType
public class BObixHistoryFeed
extends BObject
implements BIObixEncodable,
BIObixWatchable {
    @Generated
    public static final Type TYPE = Sys.loadType(BObixHistoryFeed.class);
    BAbsTime end;
    String href;
    BAbsTime last;
    BInteger limit;
    BIHistory history;
    BAbsTime start;
    OrdTarget target;
    private static final BRelTime ONE_MILLI = BRelTime.make((long)1L);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BObixHistoryFeed() {
    }

    public BObixHistoryFeed(BIHistory history) {
        this.history = history;
    }

    @Override
    public void encode(ObixEncoder out, Context cx) {
        Obj obj = new Obj();
        obj.initFeed("feed", "obix:HistoryFilter", "obix:HistoryRecord");
        obj.setHref(out.getHref());
        obj.write(out, false);
    }

    @Override
    public String getWatchHref() {
        return this.href;
    }

    @Override
    public OrdTarget getWatchTarget(Context cx) {
        return this.target;
    }

    @Override
    public void watchCleanup() {
    }

    @Override
    public void watchInit(XElem uri, OrdTarget target) {
        this.href = uri.get("val");
        this.target = target;
        try {
            ObixDecoder in;
            BComponent filter;
            XElem arg = ObixUtils.child("in", uri);
            if (arg != null && (filter = (BComponent)(in = new ObixDecoder(arg, (Context)target)).decode()) != null) {
                this.limit = (BInteger)filter.get("limit");
                this.last = this.start = (BAbsTime)filter.get("start");
                this.end = (BAbsTime)filter.get("end");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void watchChanges(ObixEncoder out, Context cx) {
        BFacets valueFacets = (BFacets)this.history.getConfig().get("valueFacets");
        if (valueFacets != null) {
            ContextWrapper w = new ContextWrapper(cx);
            w.addFacets(valueFacets);
            cx = w;
        }
        BAbsTime now = Clock.time();
        try (HistorySpaceConnection conn = ((BHistorySpace)this.history.getSpace()).getConnection(HistoryQuery.makeExcludeArchiveDataContext(null));){
            BITable results = conn.timeQuery(this.history, this.last.add(ONE_MILLI), this.end);
            OrdTarget base = this.history.getOrdInSession().resolve(null, cx);
            out.setName(null);
            out.setHref(this.href);
            out.setEncodeIs(true);
            BTimeZone tz = this.history.getConfig().getTimeZone();
            BObixHistoryAgent.QueryResults res = BObixHistoryAgent.iterateQueryResults(out, (BITable<BHistoryRecord>)results, this.limit, base, valueFacets, tz);
            this.last = res.last == null ? now : res.last.getTimestamp();
        }
    }

    @Override
    public void watchRefresh(ObixEncoder out, Context cx) {
        BFacets valueFacets = (BFacets)this.history.getConfig().get("valueFacets");
        if (valueFacets != null) {
            ContextWrapper w = new ContextWrapper(cx);
            w.addFacets(valueFacets);
            cx = w;
        }
        BAbsTime now = Clock.time();
        try (HistorySpaceConnection conn = ((BHistorySpace)this.history.getSpace()).getConnection(HistoryQuery.makeExcludeArchiveDataContext(null));){
            BITable results = conn.timeQuery(this.history, this.start, this.end);
            OrdTarget base = this.history.getOrdInSession().resolve(null, cx);
            out.setName(null);
            out.setHref(this.href);
            out.setEncodeIs(true);
            BTimeZone tz = this.history.getConfig().getTimeZone();
            BObixHistoryAgent.QueryResults res = BObixHistoryAgent.iterateQueryResults(out, (BITable<BHistoryRecord>)results, this.limit, base, valueFacets, tz);
            this.last = res.last == null ? now : res.last.getTimestamp();
        }
    }
}

