/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.server;

import com.tridium.obix.server.BShortcutLobbyAgent;
import java.util.Vector;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"obixDriver:ObixLobby"}, requiredPermissions="r")})
public class BStationLobbyAgent
extends BShortcutLobbyAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BStationLobbyAgent.class);
    public static String lobbyName = "config";

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public BComponent getComponent() {
        return Sys.getStation();
    }

    @Override
    public String getLobbyName() {
        return lobbyName;
    }

    @Override
    protected String toOrdString(String uri, Context cx) {
        return "station:|" + this.decode(uri);
    }

    String decode(String uri) {
        if (uri.indexOf(124) >= 0) {
            String[] uris = this.parseOrds(uri);
            int i = uris.length;
            while (--i >= 0) {
                uris[i] = this.decodeSlotPath(uris[i]);
            }
            uri = this.mergeOrds(uris);
        } else {
            uri = this.decodeSlotPath(uri);
        }
        return uri;
    }

    String decodeSlotPath(String uri) {
        if (uri.isEmpty() || "/".equals(uri)) {
            return "slot:/";
        }
        if (!uri.contains(":")) {
            uri = "slot:" + uri;
        }
        if (uri.contains("slot:") && uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    String mergeOrds(String[] ords) {
        StringBuilder buf = new StringBuilder(ords[0]);
        int len = ords.length;
        for (int i = 1; i < len; ++i) {
            buf.append('|').append(ords[i]);
        }
        return buf.toString();
    }

    String[] parseOrds(String uri) {
        Vector<String> v = new Vector<String>();
        int i = uri.indexOf(124);
        while (i >= 0) {
            v.addElement(uri.substring(0, i));
            uri = uri.substring(++i);
            i = uri.indexOf(124);
        }
        if (uri != null && !uri.isEmpty()) {
            v.addElement(uri);
        }
        Object[] ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }
}

