/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.obix.watch;

import com.tridium.obix.util.BadUriErr;
import com.tridium.obix.watch.BObixWatch;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.io.BIObixWatchable;
import javax.baja.obix.io.ObixEncoder;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;

@NiagaraType
public class BWatchEntry
extends BObject
implements BIObixWatchable {
    @Generated
    public static final Type TYPE = Sys.loadType(BWatchEntry.class);
    BObixWatch watch;
    boolean changed;
    BComponent comp;
    String href;
    Slot slot;
    BWatchEntry next;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWatchEntry() {
    }

    public BWatchEntry(BObixWatch w) {
        this.watch = w;
    }

    public BComponent getComponent() {
        return this.comp;
    }

    @Override
    public String getWatchHref() {
        return this.href;
    }

    public Slot getSlot() {
        return this.slot;
    }

    @Override
    public OrdTarget getWatchTarget(Context cx) {
        return this.watch.getServer().resolve(this.href, cx);
    }

    @Override
    public void watchInit(XElem uri, OrdTarget target) {
        String str = uri.get("val");
        if (!str.endsWith("/")) {
            throw new BadUriErr("Watched URI must end with '/' - " + str);
        }
        this.href = str;
        this.comp = target.getComponent();
        this.slot = target.getSlotInComponent();
        this.watch.subscriber.subscribe(this);
    }

    @Override
    public void watchCleanup() {
        this.watch.subscriber.unsubscribe(this);
    }

    @Override
    public void watchChanges(ObixEncoder out, Context cx) {
        if (!this.changed) {
            return;
        }
        this.changed = false;
        out.setHref(this.href);
        out.encode(this.watch.getServer().resolve(this.href, cx));
        out.commit();
    }

    @Override
    public void watchRefresh(ObixEncoder out, Context cx) {
        this.changed = false;
        out.setHref(this.href);
        out.encode(this.watch.getServer().resolve(this.href, cx));
        out.commit();
    }
}

