/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.obix.driver.schedule;

import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.obix.driver.BObixClient;
import javax.baja.obix.driver.schedule.BObixScheduleDeviceExt;
import javax.baja.obix.driver.schedule.BObixScheduleDiscoveryResult;
import javax.baja.obix.driver.util.BObixDiscoveryJob;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import obix.Obj;
import obix.Uri;

@NiagaraType
@NiagaraAction(name="fetch", parameterType="BString", defaultValue="BString.make(\"\")", returnType="BObixScheduleDiscoveryResult")
public class BObixScheduleDiscoveryJob
extends BObixDiscoveryJob {
    @Generated
    public static final Action fetch = BObixScheduleDiscoveryJob.newAction((int)0, (BValue)BString.make((String)""), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BObixScheduleDiscoveryJob.class);
    private static final Uri LOBBY = new Uri("obix:Lobby");
    protected BValue args;
    protected BObixScheduleDeviceExt ext;

    @Generated
    public BObixScheduleDiscoveryResult fetch(BString parameter) {
        return (BObixScheduleDiscoveryResult)this.invoke(fetch, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BObixScheduleDiscoveryJob() {
    }

    public BObixScheduleDiscoveryJob(BObixScheduleDeviceExt ext, BValue args) {
        super(ext.getObixNetwork());
        this.ext = ext;
        this.args = args;
    }

    @Override
    public void doDiscover() {
        try {
            this.progress(25);
            BObixScheduleDiscoveryResult res = this.read(this.args.toString(null), Context.decoding);
            this.progress(75);
            this.addResult("result", (BValue)res);
            this.success();
        }
        catch (Throwable t) {
            this.failed(t);
        }
    }

    public BObixScheduleDiscoveryResult doFetch(BString href) {
        try {
            return this.read(href.getString(), Context.decoding);
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.failed(t);
            return null;
        }
    }

    public BObixScheduleDiscoveryResult getResult() {
        return (BObixScheduleDiscoveryResult)this.get("result");
    }

    protected BObixScheduleDiscoveryResult read(String href, Context cx) throws Exception {
        Obj obj = this.ext.getObixClient().obixRead(new Uri(href));
        return this.result(obj);
    }

    private BObixScheduleDiscoveryResult result(Obj obj) throws Exception {
        BObixClient client = this.ext.getObixClient();
        BObixScheduleDiscoveryResult res = new BObixScheduleDiscoveryResult();
        res.setHref(client.getRelativeUri(obj.getNormalizedHref()).get());
        if (obj.getName() != null) {
            res.setObixName(obj.getName());
        } else if (obj.is(LOBBY)) {
            res.setObixName("lobby");
        }
        if (obj.getIs() != null) {
            res.setSchedule(obj.getIs().contains(this.ext.getScheduleContract()));
        }
        Obj[] kids = obj.list();
        BComponent children = res.getKids();
        int count = 0;
        for (Obj kid : kids) {
            BObixScheduleDiscoveryResult hr;
            if (kid.isOp() || kid.isFeed()) continue;
            String name = kid.getName();
            if (name == null || name.isEmpty()) {
                name = kid.getDisplayName();
            }
            if (name == null || name.isEmpty()) {
                name = kid.getElement();
            }
            name = SlotPath.escape((String)name);
            name = name + "?";
            if (kid.isRef()) {
                Uri uri = kid.getNormalizedHref();
                if (uri == null) continue;
                children.add(name, (BValue)BString.make((String)uri.get()));
                ++count;
                continue;
            }
            if (kid.getHref() == null || (hr = this.result(kid)) == null) continue;
            children.add(name, (BValue)hr);
            ++count;
        }
        if (count == 0 && !res.getSchedule()) {
            return null;
        }
        return res;
    }
}

