/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.obix.io;

import com.tridium.obix.util.ObixUtils;
import com.tridium.obix.util.WrapperException;
import java.io.InputStream;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class ObixDecoder
implements Context {
    private static final String AX_CONTRACT = "/obix/def/";
    private static final int AX_CONTRACT_LEN = 10;
    private Context ctxt;
    private boolean debug = false;
    private BFacets facets;
    private InputStream in;
    private XElem root;
    private BEnumRange range = null;
    private boolean useNew = true;

    public ObixDecoder(XElem root, Context cx) throws Exception {
        this(root, cx, false);
    }

    private ObixDecoder(XElem root, Context cx, boolean debug) throws Exception {
        this.root = root;
        this.ctxt = cx;
        this.debug = debug;
    }

    public ObixDecoder(InputStream in, Context cx) throws Exception {
        this(in, cx, false);
    }

    private ObixDecoder(InputStream in, Context cx, boolean debug) throws Exception {
        this.in = in;
        this.ctxt = cx;
        this.debug = debug;
    }

    public void addFacets(BFacets facets) {
        this.facets = facets == null ? null : BFacets.make((BFacets)this.getFacets(), (BFacets)facets);
    }

    public Context getBase() {
        return this.ctxt;
    }

    public BObject getFacet(String name) {
        return this.getFacets().getFacet(name);
    }

    public BFacets getFacets() {
        if (this.facets != null) {
            return this.facets;
        }
        if (this.ctxt != null) {
            return this.ctxt.getFacets();
        }
        return null;
    }

    public String getLanguage() {
        return this.ctxt.getLanguage();
    }

    public BUser getUser() {
        return this.ctxt.getUser();
    }

    public BValue decode() throws Exception {
        BValue ret = this.useNew ? this.decodeNew() : this.decodeOld();
        return ret;
    }

    public BValue decode(BValue prototype) throws Exception {
        if (this.useNew) {
            return this.decodeNew(prototype);
        }
        return this.decodeOld(prototype);
    }

    private BValue decodeOld() throws Exception {
        return this.make(this.parse(), this);
    }

    private BValue decodeOld(BValue prototype) throws Exception {
        if (prototype == null) {
            return this.decode();
        }
        if (prototype.isComplex()) {
            return this.decode(this.parse(), prototype.asComplex().newCopy(true), this.ctxt);
        }
        return this.decode(this.parse(), prototype, this.ctxt);
    }

    private BValue decodeNew() throws Exception {
        return this.make2(this.parse(), this);
    }

    private BValue decodeNew(BValue prototype) throws Exception {
        if (prototype == null) {
            return this.decodeNew();
        }
        if (prototype.isComplex()) {
            return this.decode2(this.parse(), prototype.asComplex().newCopy(true), this.ctxt);
        }
        return this.decode2(this.parse(), prototype, this.ctxt);
    }

    public XElem getDocument() {
        return this.parse();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean on) {
        this.debug = on;
    }

    public boolean isUseNew() {
        return this.useNew;
    }

    public void setUseNew(boolean useNew) {
        this.useNew = useNew;
    }

    private XElem parse() {
        try {
            if (this.root == null) {
                XParser parser = XParser.make((InputStream)this.in);
                this.root = parser.parse(false);
                if (this.debug) {
                    ObixDecoder.d("PARSING:");
                    this.root.dump();
                }
            }
            return this.root;
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
    }

    private BValue decode(XElem src, BValue sink, Context cx) throws Exception {
        String name = src.name();
        if (name.equals("obj")) {
            if (sink instanceof BComplex) {
                BComplex cpx = sink.asComplex();
                XElem[] kids = src.elems();
                int len = kids == null ? 0 : kids.length;
                for (int i = 0; i < len; ++i) {
                    BValue made;
                    name = kids[i].get("name");
                    Property p = cpx.getProperty(name);
                    if (p != null) {
                        BValue tmp = cpx.get(p);
                        made = this.decode(kids[i], tmp, cx);
                        if (made == null || made == tmp) continue;
                        cpx.set(p, made);
                        continue;
                    }
                    if (cpx instanceof BComponent) {
                        made = this.make(kids[i], cx);
                        if (made == null) continue;
                        cpx.asComponent().add(name, made);
                        continue;
                    }
                    throw new IllegalStateException("Cannot translate: " + src);
                }
            }
            return sink;
        }
        if (name.equals("enum")) {
            BIEnum e = (BIEnum)sink;
            BEnumRange r = (BEnumRange)cx.getFacets().get("range");
            if (r == null) {
                r = e.getEnum().getRange();
            }
            return r.get(src.get("val", null));
        }
        if (name.equals("abstime")) {
            return ObixUtils.dateTime(src.get("val", null));
        }
        if (name.equals("reltime")) {
            return BRelTime.make((long)ObixUtils.duration(src.get("val", null)));
        }
        if (sink.isSimple()) {
            return (BValue)sink.asSimple().decodeFromString(src.get("val", null));
        }
        throw new IllegalStateException("Cannot translate: " + src);
    }

    private BValue make(XElem val, Context cx) throws Exception {
        if (val == null) {
            return null;
        }
        String name = val.name();
        if (name.equals("abstime")) {
            return ObixUtils.dateTime(val.get("val", null));
        }
        if (name.equals("bool")) {
            if (val.getb("null", false)) {
                return null;
            }
            return BBoolean.make((boolean)ObixUtils.bool(val.get("val", null)));
        }
        if (name.equals("enum")) {
            if (val.getb("null", false)) {
                return null;
            }
            BFacets f = cx.getFacets();
            BEnumRange r = (BEnumRange)f.get("range");
            if (r == null) {
                throw new IllegalStateException("Cannot translate: " + val);
            }
            return r.get(val.get("val", null));
        }
        if (name.equals("int")) {
            if (val.getb("null", false)) {
                return null;
            }
            return BInteger.make((int)Integer.parseInt(val.get("val", null)));
        }
        if (name.equals("list")) {
            BComponent list = new BComponent();
            XElem[] kids = val.elems();
            int len = kids == null ? 0 : kids.length;
            for (int i = 0; i < len; ++i) {
                BValue tmp = this.make(kids[i], cx);
                if (tmp == null) continue;
                list.add(kids[i].get("name", kids[i].name() + "?"), tmp);
            }
            return list;
        }
        if (name.equals("obj")) {
            BComponent comp = new BComponent();
            XElem[] kids = val.elems();
            int len = kids == null ? 0 : kids.length;
            for (int i = 0; i < len; ++i) {
                BValue tmp = this.make(kids[i], cx);
                if (tmp == null) continue;
                comp.add(kids[i].get("name", kids[i].name() + "?"), tmp);
            }
            return comp;
        }
        if (name.equals("real")) {
            if (val.getb("null", false)) {
                return null;
            }
            return BDouble.make((double)Double.parseDouble(val.get("val", null)));
        }
        if (name.equals("reltime")) {
            return BRelTime.make((long)ObixUtils.duration(val.get("val", null)));
        }
        if (name.equals("str")) {
            if (val.getb("null", false)) {
                return null;
            }
            return BString.make((String)val.get("val", null));
        }
        if (name.equals("uri")) {
            return BString.make((String)val.get("val", null));
        }
        throw new IllegalArgumentException("Invalid obj: " + val);
    }

    private BValue decode2(XElem src, BValue sink, Context cx) throws Exception {
        String name;
        BValue v;
        block16: {
            v = sink;
            name = src.name();
            String srcIs = src.get("is", "no contract");
            if (this.debug) {
                System.out.println("ObixDecoder.decode2(src=" + name + ", sink=" + sink + ", cx=" + cx + ", src is:" + srcIs);
            }
            try {
                BTypeSpec ts;
                if (srcIs.startsWith(AX_CONTRACT) && (ts = BTypeSpec.make((String)srcIs.substring(AX_CONTRACT.length()))) != null && ts != BTypeSpec.NULL) {
                    v = (BValue)ts.getInstance();
                }
            }
            catch (Exception e) {
                if (!this.debug) break block16;
                e.printStackTrace();
                System.out.println("Exception decoding source\n" + src + "\n using prototype\n" + sink + "\nusing default sink...");
            }
        }
        if (this.debug) {
            System.out.println("sink:" + sink.toDebugString() + " type=" + sink.getTypeDisplayName(null) + "\nv (snk):" + v.toDebugString() + " type=" + v.getTypeDisplayName(null));
        }
        if (name.equals("obj")) {
            if (v instanceof BComplex) {
                BComplex cpx = v.asComplex();
                XElem[] kids = src.elems();
                int len = kids == null ? 0 : kids.length;
                for (int i = 0; i < len; ++i) {
                    BValue made;
                    name = kids[i].get("name");
                    Property p = cpx.getProperty(name);
                    if (p != null) {
                        BValue tmp = cpx.get(p);
                        made = this.decode2(kids[i], tmp, cx);
                        if (made == null || made == tmp) continue;
                        cpx.set(p, made);
                        continue;
                    }
                    if (cpx instanceof BComponent) {
                        made = this.make2(kids[i], cx);
                        if (made == null) continue;
                        cpx.asComponent().add(name, made);
                        continue;
                    }
                    throw new IllegalStateException("Cannot translate: " + src);
                }
            }
            return v;
        }
        if (name.equals("enum")) {
            BIEnum e = (BIEnum)v;
            BEnumRange r = (BEnumRange)cx.getFacets().get("range");
            if (r == null) {
                r = e.getEnum().getRange();
            }
            if (v instanceof BDynamicEnum) {
                return BDynamicEnum.make((int)r.get(src.get("val", null)).getOrdinal(), (BEnumRange)r);
            }
            return r.get(src.get("val", null));
        }
        if (name.equals("abstime")) {
            return ObixUtils.dateTime(src.get("val", null));
        }
        if (name.equals("reltime")) {
            return BRelTime.make((long)ObixUtils.duration(src.get("val", null)));
        }
        if (v.isSimple()) {
            return (BValue)v.asSimple().decodeFromString(src.get("val", null));
        }
        throw new IllegalStateException("Cannot translate: " + src);
    }

    private BValue make2(XElem val, Context cx) throws Exception {
        return this.make2(val, cx, null);
    }

    private BValue make2(XElem val, Context cx, Type t) throws Exception {
        this.dbg("make2: val=" + val + " cx=" + cx + " t=" + t);
        try {
            if (val == null) {
                return null;
            }
            String is = val.get("is", null);
            String name = val.name();
            if (is != null && is.length() > 0) {
                String primary = null;
                int spc = is.indexOf(32);
                primary = spc < 0 ? is : is.substring(0, spc);
                if (primary.startsWith(AX_CONTRACT)) {
                    BTypeSpec ts = BTypeSpec.make((String)primary.substring(10));
                    BObject o = ts.getInstance();
                    if (o.isComplex()) {
                        BComplex ret = (BComplex)o;
                        this.setFromVal(ret, val);
                        XElem[] kids = val.elems();
                        int len = kids == null ? 0 : kids.length;
                        for (int i = 0; i < len; ++i) {
                            BValue tmp;
                            String sname = kids[i].get("name", "");
                            Slot s = ret.getSlot(sname);
                            if (s != null) {
                                if (!s.isProperty()) continue;
                                Property p = s.asProperty();
                                tmp = this.make2(kids[i], cx, p.getType());
                                if (tmp != null) {
                                    ret.set(p, tmp);
                                    continue;
                                }
                                this.dbg("!! make2 returned null for kid:");
                                if (!this.debug) continue;
                                kids[i].dump();
                                continue;
                            }
                            tmp = this.make2(kids[i], cx, null);
                            this.dbg("!!! adding dynamic slot: '" + tmp + "' type=" + (tmp != null ? tmp.getTypeDisplayName(null) : "null"));
                            ret.asComponent().add(sname, tmp);
                        }
                        return ret;
                    }
                    BSimple simple = (BSimple)o;
                    String s = val.get("val", null);
                    String sname = val.get("name", "");
                    BValue ret = (BValue)simple.decodeFromString(s);
                    this.dbg("simple with type '" + sname + "':\n  " + val + "\n  " + ret + " [" + ret.getType() + "]");
                    if (ret.getType().is(BFacets.TYPE) && sname.equals("facets")) {
                        this.range = (BEnumRange)((BFacets)ret).getFacet("range");
                    }
                    return ret;
                }
                this.dbg("Primary contract is not a Niagara definition: '" + primary + "'; using standard make()");
                return this.make(val, cx);
            }
            this.dbg("make2: non-contract case!!!");
            if (name.equals("abstime")) {
                return ObixUtils.dateTime(val.get("val", null));
            }
            if (name.equals("bool")) {
                if (val.getb("null", false)) {
                    return null;
                }
                return BBoolean.make((boolean)ObixUtils.bool(val.get("val", null)));
            }
            if (name.equals("enum")) {
                if (val.getb("null", false)) {
                    return null;
                }
                BFacets f = cx.getFacets();
                BEnumRange r = null;
                if (f != null) {
                    r = (BEnumRange)f.get("range");
                }
                if (r != null) {
                    return r.get(val.get("val", null));
                }
                String obixRange = val.get("range", null);
                if (obixRange != null && obixRange.startsWith(AX_CONTRACT)) {
                    int ndx = obixRange.lastIndexOf(47);
                    BTypeSpec ts = BTypeSpec.make((String)obixRange.substring(10, ndx));
                    BEnum e = (BEnum)ts.getInstance();
                    r = e.getRange();
                }
                if (r != null) {
                    return r.get(val.get("val", null));
                }
                throw new IllegalStateException("Cannot translate: " + val);
            }
            if (name.equals("int")) {
                if (val.getb("null", false)) {
                    return null;
                }
                return BInteger.make((int)Integer.parseInt(val.get("val", null)));
            }
            if (name.equals("list")) {
                this.dbg("\nmake2: list!\n  " + val);
                BComponent list = new BComponent();
                XElem[] kids = val.elems();
                int len = kids == null ? 0 : kids.length;
                for (int i = 0; i < len; ++i) {
                    BValue tmp = this.make2(kids[i], cx);
                    if (tmp == null) continue;
                    list.add(kids[i].get("name", kids[i].name() + "?"), tmp);
                }
                return list;
            }
            if (name.equals("real")) {
                if (val.getb("null", false)) {
                    return null;
                }
                return BDouble.make((double)Double.parseDouble(val.get("val", null)));
            }
            if (name.equals("reltime")) {
                return BRelTime.make((long)ObixUtils.duration(val.get("val", null)));
            }
            if (name.equals("str")) {
                this.dbg("\nmake2: string!\n  " + val);
                if (val.getb("null", false)) {
                    return null;
                }
                String s = val.get("val", null);
                if (t != null) {
                    return (BValue)((BSimple)t.getInstance()).decodeFromString(s);
                }
                return BString.make((String)val.get("val", null));
            }
            if (name.equals("uri")) {
                this.dbg("\nmake2: uri!\n  " + val);
                return BOrd.make((String)val.get("val", null));
            }
            if (name.equals("ref")) {
                this.dbg("make2: ref!\n  " + val);
                return this.make2(val, cx);
            }
            if (name.equals("obj")) {
                this.dbg("\nmake2: obj!\n  " + val);
                BComponent c = null;
                if (t != null) {
                    BValue v = (BValue)t.getInstance();
                    if (t.is(BSimple.TYPE)) {
                        return (BValue)v.asSimple().decodeFromString(val.get("val", ""));
                    }
                    if (t.is(BComponent.TYPE)) {
                        c = v.asComponent();
                    }
                } else {
                    c = new BComponent();
                }
                if (c == null) {
                    throw new IllegalStateException("Cannot decode non-contract typed BObject:" + val);
                }
                XElem[] kids = val.elems();
                int len = kids == null ? 0 : kids.length;
                for (int i = 0; i < len; ++i) {
                    BValue tmp = this.make2(kids[i], cx);
                    if (tmp == null) continue;
                    c.add(kids[i].get("name", kids[i].name() + "?"), tmp);
                }
                return c;
            }
            throw new IllegalArgumentException("Invalid obj: " + val);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.dbg("Exception in make2!: val=");
            val.dump();
            throw e;
        }
    }

    private void setFromVal(BComplex cpx, XElem val) {
        String sval = val.get("val", "");
        this.dbg("setFromVal: cpx=" + cpx + ", val=" + val + ", sval=" + sval);
        if (cpx instanceof BStatusValue) {
            if (cpx instanceof BStatusBoolean) {
                ((BStatusBoolean)cpx).setValue(BBoolean.decode((String)sval));
            } else if (cpx instanceof BStatusNumeric) {
                ((BStatusNumeric)cpx).setValue(BDouble.decode((String)sval));
            } else if (cpx instanceof BStatusEnum) {
                BEnumRange r = this.range;
                if (r == null) {
                    r = ((BStatusEnum)cpx).getValue().getRange();
                }
                if (r.isTag(sval)) {
                    ((BStatusEnum)cpx).setValue(r.get(sval));
                } else {
                    int i = 0;
                    try {
                        i = Integer.parseInt(sval);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    ((BStatusEnum)cpx).setValue(BDynamicEnum.make((int)i, (BEnumRange)r));
                }
            } else if (cpx instanceof BStatusString) {
                ((BStatusString)cpx).setValue(sval);
            }
            if (val.getb("null", false)) {
                ((BStatusValue)cpx).setStatusNull(true);
            }
        } else {
            this.dbg("setFromVal:don't know how to do anything to a " + cpx.getType() + " with " + sval);
        }
        this.dbg("setFromVal: cpx -> " + cpx);
    }

    private static final void d(String s) {
        System.out.println(s);
    }

    private final void dbg(String s) {
        if (this.debug) {
            System.out.println(s);
        }
    }
}

