/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.obix.io;

import com.tridium.obix.io.ObixBuffer;
import com.tridium.obix.util.BadUriErr;
import com.tridium.obix.util.ObixUtils;
import com.tridium.obix.util.Obj;
import com.tridium.obix.util.PermissionErr;
import com.tridium.obix.util.UnsupportedErr;
import com.tridium.obix.util.WrapperException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistorySpace;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.obix.io.BIObixAgent;
import javax.baja.obix.io.BIObixEncodable;
import javax.baja.security.AuthenticationException;
import javax.baja.security.PermissionException;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BMarker;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Type;
import javax.baja.tag.Tag;
import javax.baja.tag.Taggable;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualComponentSpace;
import javax.baja.xml.XWriter;

public class ObixEncoder {
    private Map<String, String> attrs = new ConcurrentHashMap<String, String>();
    private ObixBuffer buffer;
    private boolean contract = false;
    private boolean debug = false;
    private String docHref;
    private String docPath;
    private boolean facets = true;
    private String href;
    private int indent = 0;
    private boolean is = true;
    private String lobbyPath = "/obix";
    private String name;
    private boolean ref = false;
    private OutputStream out;
    private XWriter writer;
    private boolean forceNoRef = false;
    private boolean encodeSimpleContracts = false;
    private boolean includeHiddenRecords = false;

    public ObixEncoder(String lobbyPath, String docHref, OutputStream out) throws IOException {
        this.buffer = new ObixBuffer();
        this.docHref = docHref;
        this.href = docHref;
        this.lobbyPath = lobbyPath;
        this.out = out;
        this.writer = new XWriter((OutputStream)this.buffer);
        int i = docHref.indexOf(lobbyPath);
        if (i >= 0) {
            this.docPath = docHref.substring(i + lobbyPath.length());
        }
    }

    protected ObixEncoder(ObixEncoder base) throws IOException {
        base.getWriter().flush();
        this.attrs = base.attrs;
        this.buffer = new ObixBuffer();
        this.contract = base.contract;
        this.debug = base.debug;
        this.docHref = base.docHref;
        this.docPath = base.docPath;
        this.facets = base.facets;
        this.href = base.docHref;
        this.indent = base.indent;
        this.is = base.is;
        this.lobbyPath = base.lobbyPath;
        this.name = base.name;
        this.out = base.buffer;
        this.ref = base.ref;
        this.writer = new XWriter((OutputStream)this.buffer);
    }

    public Map<String, String> attributes() {
        return this.attrs;
    }

    public boolean isContract() {
        return this.contract;
    }

    public void setContract(boolean contract) {
        this.contract = contract;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean getEncodeIs() {
        return this.is;
    }

    public void setEncodeIs(boolean is) {
        this.is = is;
    }

    public boolean getEncodeFacets() {
        return this.facets;
    }

    public void setEncodeFacets(boolean facets) {
        this.facets = facets;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isRef() {
        return this.ref;
    }

    public void setRef(boolean ref) {
        this.ref = ref;
    }

    public void setForceNoRef(boolean forceNoRef) {
        this.forceNoRef = forceNoRef;
    }

    public boolean isForceNoRef() {
        return this.forceNoRef;
    }

    public String getChildHref(String parentHref, String childName) {
        if (childName == null) {
            return null;
        }
        if (this.docHref != null && parentHref != null && parentHref.equals(this.docHref) && parentHref.endsWith("/")) {
            return childName + "/";
        }
        if (parentHref == null) {
            return childName + "/";
        }
        return ObixUtils.concat(parentHref, childName + "/");
    }

    public String getDocHref() {
        return this.docHref;
    }

    public String getDocPath() {
        return this.docPath;
    }

    public String getLobbyPath() {
        return this.lobbyPath;
    }

    public void abort() {
        this.buffer.reset();
    }

    public void commit() {
        try {
            this.writer.flush();
            int size = this.buffer.size();
            if (size == 0) {
                return;
            }
            if (this.debug) {
                System.out.write(this.buffer.getBytes(), 0, size);
            }
            this.out.write(this.buffer.getBytes(), 0, size);
            this.out.flush();
            this.buffer.reset();
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
    }

    public int getIndent() {
        return this.indent;
    }

    public XWriter getWriter() {
        return this.writer;
    }

    public int indent() {
        return ++this.indent;
    }

    public int outdent() {
        if (this.indent == 0) {
            throw new IllegalStateException("Server error; attempt to outdent beyond doc root.");
        }
        return --this.indent;
    }

    public void encode(BComponent c) {
        this.encode(c.getOrdInSession().resolve());
    }

    public void encode(OrdTarget tgt) {
        if (!tgt.canRead()) {
            throw new PermissionErr(tgt.getUser().getName() + " cannot read this object");
        }
        this.encodeTarget(tgt);
    }

    public void encodeFully(BComponent c) {
        this.encodeSimpleContracts = true;
        this.forceNoRef = true;
        this.encode(c.getOrdInSession().resolve());
    }

    public void encodeFully(OrdTarget tgt) {
        this.encodeSimpleContracts = true;
        this.forceNoRef = true;
        if (!tgt.canRead()) {
            throw new PermissionErr(tgt.getUser().getName() + " cannot read this object");
        }
        this.encodeTarget(tgt);
    }

    public void encode(Throwable t) {
        String msg;
        this.writer.flush();
        this.abort();
        if (t instanceof WrapperException) {
            t = ((WrapperException)t).getWrapped();
        }
        if ((msg = t.getMessage()) == null || msg.trim().isEmpty()) {
            msg = t.toString();
        }
        Obj o = new Obj().initErr(this.href, msg);
        o.setHref(this.href);
        if (t instanceof BadUriErr) {
            o.setIs("obix:BadUriErr");
        } else if (t instanceof PermissionErr) {
            o.setIs("obix:PermissionErr");
        } else if (t instanceof UnsupportedErr) {
            o.setIs("obix:UnsupportedErr");
        } else if (t instanceof UnresolvedException) {
            o.setIs("obix:BadUriErr");
        } else if (t instanceof AuthenticationException) {
            o.setIs("obix:PermissionErr");
        } else if (t instanceof PermissionException) {
            o.setIs("obix:PermissionErr");
        } else {
            t.printStackTrace();
        }
        o.write(this, false);
    }

    public void encodeNull() {
        new Obj().setNull(Boolean.TRUE).write(this, false);
    }

    public boolean encodeSimpleContracts() {
        return this.encodeSimpleContracts;
    }

    public boolean isIncludeHiddenRecords() {
        return this.includeHiddenRecords;
    }

    public void setIncludeHiddenRecords(boolean include) {
        this.includeHiddenRecords = include;
    }

    protected void configChild(String parentHref, OrdTarget tgt) {
        this.reset();
        boolean virtual = false;
        String hrefName = null;
        try {
            Property[] props;
            Slot s;
            this.contract = false;
            BObject o = tgt.get();
            if (!this.forceNoRef) {
                boolean bl = this.ref = o instanceof BComponent || o instanceof BINavNode;
            }
            if (o instanceof BComplex) {
                this.name = ((BComplex)o).getName();
            }
            if (this.name == null && (s = tgt.getSlotInComponent()) instanceof Action) {
                this.name = s.getName();
            }
            if (this.name == null && (props = tgt.getPropertyPathInComponent()) != null) {
                this.name = props[props.length - 1].getName();
            }
            if (this.name == null && o instanceof BINavNode) {
                this.name = ((BINavNode)o).getNavName();
            }
            if (this.name != null) {
                if (o instanceof BVirtualComponent) {
                    virtual = true;
                } else if (tgt.getComponent() instanceof BVirtualComponent) {
                    virtual = true;
                }
                if (virtual) {
                    hrefName = this.name;
                    this.name = ObixUtils.ndUnescape(SlotPath.unescape((String)this.name));
                    this.href = this.getChildHref(parentHref, hrefName);
                } else {
                    this.href = this.getChildHref(parentHref, this.name);
                }
            } else {
                this.href = '|' + tgt.getOrd().encodeToString();
            }
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
    }

    protected void encodeTarget(OrdTarget tgt) {
        BObject o = tgt.get();
        if (o instanceof BIObixEncodable) {
            ((BIObixEncodable)o).encode(this, (Context)tgt);
            return;
        }
        Slot s = tgt.getSlotInComponent();
        if (s instanceof Action) {
            this.encodeOp(tgt);
        } else {
            this.encodeData(tgt);
        }
    }

    protected void encodeData(OrdTarget tgt) {
        try {
            BIObixAgent agent = this.getAgent(tgt);
            if (agent != null && !agent.encode(tgt, this)) {
                return;
            }
            BObject bob = tgt.get();
            Config cfg = new Config();
            Obj obj = new Obj();
            obj.setHref(this.href);
            obj.setName(this.name);
            if (bob.isNull()) {
                obj.setNull(Boolean.TRUE);
            }
            if (agent != null) {
                obj.addContract(agent.getContract());
                obj.addPrimaryContract(agent.getPrimaryContract());
            }
            ObixUtils.encode(this, obj, bob, tgt);
            BComplex p = tgt.getParent();
            Slot s = tgt.getSlotInComponent();
            if (p != null && s != null) {
                obj.setDisplayName(p.getDisplayName(s, null));
            }
            if (this.ref) {
                obj.makeRef();
                obj.write(this, false, agent);
                return;
            }
            OrdTarget[] kids = this.getKids(tgt, bob);
            if (agent != null) {
                kids = agent.getChildren(kids);
            }
            boolean isTagged = bob instanceof Taggable;
            if (agent == null && kids == null && !isTagged) {
                obj.write(this, false);
                return;
            }
            obj.write(this, true, agent);
            String parentHref = this.href;
            int len = kids == null ? 0 : kids.length;
            for (int i = 0; i < len; ++i) {
                this.configChild(parentHref, kids[i]);
                if (agent != null && !agent.encodeChild(kids[i], this)) continue;
                this.encodeTarget(kids[i]);
            }
            cfg.restore();
            if (agent != null) {
                agent.encodeFinishing();
            }
            obj.endElem(this);
        }
        catch (Exception x) {
            throw new WrapperException(x);
        }
    }

    protected void encodeMeta(Taggable tobj, BIObixAgent agent) {
        Obj meta = new Obj();
        meta.setElement("ref");
        String parent = this.href.substring(0, this.href.lastIndexOf("/"));
        parent = parent.substring(parent.lastIndexOf("/") + 1);
        meta.setHref("../" + parent + ";meta");
        meta.write(this, true);
        for (Tag tag : tobj.tags()) {
            Obj otag = new Obj();
            otag.setElement(this.elemFromTag(tag));
            otag.setName(tag.getId().getQName());
            otag.setVal(tag.getValue().toString());
            otag.write(this, false);
        }
        meta.endElem(this);
    }

    private String elemFromTag(Tag t) {
        BIDataValue val = t.getValue();
        if (val instanceof BMarker) {
            return "obj";
        }
        if (val instanceof BIBoolean) {
            return "bool";
        }
        if (val instanceof BIEnum) {
            return "enum";
        }
        if (val instanceof BINumeric) {
            return "real";
        }
        if (val instanceof BOrd) {
            return "uri";
        }
        System.out.println("*** ObixEncoder.elemFromTag(): using Obj.STR for val type " + val.getType());
        return "str";
    }

    protected void encodeOp(OrdTarget tgt) {
        Obj obj = new Obj();
        try {
            Action action = (Action)tgt.getSlotInComponent();
            obj.setElement("op");
            obj.setName(this.name);
            obj.setHref(this.href);
            BComponent c = tgt.getComponent();
            String dn = action.getDefaultDisplayName((Context)tgt);
            if (c != null) {
                dn = c.getDisplayName((Slot)action, null);
            }
            obj.setDisplayName(dn);
            Type t = action.getReturnType();
            if (t != null) {
                ObixUtils.encodeContracts(obj, t, this);
                obj.setOut(obj.getIs());
                obj.setIs(null);
            }
            if ((t = action.getParameterType()) != null) {
                ObixUtils.encodeContracts(obj, t, this);
                obj.setIn(obj.getIs());
                obj.setIs(null);
            }
        }
        catch (Exception x) {
            return;
        }
        obj.write(this, false);
    }

    protected OrdTarget[] getKids(OrdTarget parent, BObject parentVal) {
        BOrd parentOrd = parent.getOrd();
        BOrd childOrd = null;
        Vector<BOrd> v = null;
        if (parentVal instanceof BComplex) {
            BComplex cpx = (BComplex)parentVal;
            SlotCursor cur = cpx.getSlots();
            while (cur.next()) {
                BINavNode[] s = cur.slot();
                if (!this.canSee(cpx, (Slot)s)) continue;
                childOrd = BOrd.make((String)("slot:" + s.getName()));
                if (v == null) {
                    v = new Vector<BOrd>();
                }
                v.addElement(childOrd);
            }
        } else if (parentVal instanceof BINavNode) {
            BINavNode[] kids = ((BINavNode)parentVal).getNavChildren();
            if (parentVal instanceof BHistorySpace) {
                kids = ((BHistorySpace)parentVal).listDevices();
            }
            int len = kids.length;
            for (BINavNode kid : kids) {
                childOrd = BOrd.make((BOrd)parentOrd, (BOrd)kid.getNavOrd().relativizeToSession());
                if (parentVal instanceof BVirtualComponentSpace) {
                    childOrd = BOrd.make((String)ObixUtils.ndUnescape(childOrd.toString()));
                }
                if (v == null) {
                    v = new Vector();
                }
                v.addElement(childOrd);
            }
        }
        if (v == null) {
            return null;
        }
        Enumeration e = v.elements();
        Vector<OrdTarget> targets = null;
        while (e.hasMoreElements()) {
            childOrd = (BOrd)e.nextElement();
            try {
                OrdTarget ot = childOrd.resolve(parentVal, (Context)parent);
                if (!ot.canRead()) continue;
                if (targets == null) {
                    targets = new Vector<OrdTarget>();
                }
                targets.addElement(ot);
            }
            catch (Exception x) {
                x.printStackTrace();
                String str = childOrd.encodeToString();
                throw new RuntimeException("Cannot resolve " + str + ": " + x.getMessage());
            }
        }
        if (targets == null) {
            return null;
        }
        Object[] ret = new OrdTarget[targets.size()];
        targets.copyInto(ret);
        return ret;
    }

    boolean canSee(BComplex parent, Slot s) {
        if (s.isTopic()) {
            return false;
        }
        return !Flags.isHidden((BComplex)parent, (Slot)s);
    }

    private BIObixAgent getAgent(OrdTarget tgt) {
        BObject obj = tgt.get();
        if (obj instanceof BIObixAgent) {
            return (BIObixAgent)obj;
        }
        AgentList list = obj.getAgents((Context)tgt);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            AgentInfo info = list.get(i);
            if (!info.getAgentType().is(BIObixAgent.TYPE.getTypeInfo())) continue;
            return (BIObixAgent)info.getInstance();
        }
        return null;
    }

    private void reset() {
        this.attrs.clear();
        this.href = null;
        this.name = null;
        this.ref = false;
    }

    private class Config {
        boolean _contract;
        boolean _facets;
        String _href;
        boolean _is;
        String _name;
        boolean _ref;

        Config() {
            this._contract = ObixEncoder.this.contract;
            this._href = ObixEncoder.this.href;
            this._facets = ObixEncoder.this.facets;
            this._is = ObixEncoder.this.is;
            this._name = ObixEncoder.this.name;
            this._ref = ObixEncoder.this.ref;
        }

        void restore() {
            ObixEncoder.this.contract = this._contract;
            ObixEncoder.this.facets = this._facets;
            ObixEncoder.this.href = this._href;
            ObixEncoder.this.is = this._is;
            ObixEncoder.this.name = this._name;
            ObixEncoder.this.ref = this._ref;
        }
    }
}

