/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template;

import com.tridium.file.types.bog.BBogSpace;
import com.tridium.install.BVersion;
import com.tridium.tagdictionary.util.TagDictionaryUtil;
import com.tridium.template.BApplicationService;
import com.tridium.template.BConfigBinding;
import com.tridium.template.BPasswordBinding;
import com.tridium.template.BRelationInfo;
import com.tridium.template.BTemplateService;
import com.tridium.template.BTemplateState;
import com.tridium.template.TemplateConst;
import com.tridium.template.manifest.TemplateManifest;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.data.BIDataValue;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BComponentEventMask;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;
import javax.baja.tag.Relations;
import javax.baja.tag.Tags;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;
import javax.baja.util.BServiceContainer;
import javax.baja.util.BUuid;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="templateName", type="String", defaultValue="Template", flags=1), @NiagaraProperty(name="uID", type="BUuid", defaultValue="BUuid.DEFAULT", flags=1), @NiagaraProperty(name="version", type="BVersion", defaultValue="new BVersion()", flags=1), @NiagaraProperty(name="versionDate", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1), @NiagaraProperty(name="deployed", type="boolean", defaultValue="false", flags=7), @NiagaraProperty(name="propagated", type="boolean", defaultValue="false", flags=5), @NiagaraProperty(name="pxEditBindings", type="BVector", defaultValue="new BVector()", flags=5)})
@NiagaraAction(name="lateSubscribe", flags=4)
public class BTemplateConfig
extends BComponent {
    @Generated
    public static final Property templateName = BTemplateConfig.newProperty((int)1, (String)"Template", null);
    @Generated
    public static final Property uID = BTemplateConfig.newProperty((int)1, (BValue)BUuid.DEFAULT, null);
    @Generated
    public static final Property version = BTemplateConfig.newProperty((int)1, (BValue)new BVersion(), null);
    @Generated
    public static final Property versionDate = BTemplateConfig.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property deployed = BTemplateConfig.newProperty((int)7, (boolean)false, null);
    @Generated
    public static final Property propagated = BTemplateConfig.newProperty((int)5, (boolean)false, null);
    @Generated
    public static final Property pxEditBindings = BTemplateConfig.newProperty((int)5, (BValue)new BVector(), null);
    @Generated
    public static final Action lateSubscribe = BTemplateConfig.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTemplateConfig.class);
    private BTemplateService templateService;
    private static Lexicon lex = Lexicon.make((String)"template");
    public static final String ATTRIBUTE_PREFIX = "#";
    public static final String NAME_ATTRIBUTE = "#Name";
    public static final String DISPLAY_NAME_ATTRIBUTE = "#DisplayName";
    private Clock.Ticket subscribedTicket;
    private static int COMPOSITE_READONLY = 4097;
    private TargetSubscriber subscriber;
    private TemplateManifest manifest = null;
    private Array<Slot> inputSlots = null;
    private Array<Slot> outputSlots = null;
    private ArrayList<BRelationInfo> relations = null;
    private ArrayList<BPasswordBinding> passwords = null;
    private Array<Slot> unLinkedInputSlots = null;
    private Array<Slot> unLinkedOutputSlots = null;
    private ArrayList<BRelationInfo> unboundRelations = null;

    @Generated
    public String getTemplateName() {
        return this.getString(templateName);
    }

    @Generated
    public void setTemplateName(String v) {
        this.setString(templateName, v, null);
    }

    @Generated
    public BUuid getUID() {
        return (BUuid)this.get(uID);
    }

    @Generated
    public void setUID(BUuid v) {
        this.set(uID, (BValue)v, null);
    }

    @Generated
    public BVersion getVersion() {
        return (BVersion)this.get(version);
    }

    @Generated
    public void setVersion(BVersion v) {
        this.set(version, (BValue)v, null);
    }

    @Generated
    public BAbsTime getVersionDate() {
        return (BAbsTime)this.get(versionDate);
    }

    @Generated
    public void setVersionDate(BAbsTime v) {
        this.set(versionDate, (BValue)v, null);
    }

    @Generated
    public boolean getDeployed() {
        return this.getBoolean(deployed);
    }

    @Generated
    public void setDeployed(boolean v) {
        this.setBoolean(deployed, v, null);
    }

    @Generated
    public boolean getPropagated() {
        return this.getBoolean(propagated);
    }

    @Generated
    public void setPropagated(boolean v) {
        this.setBoolean(propagated, v, null);
    }

    @Generated
    public BVector getPxEditBindings() {
        return (BVector)this.get(pxEditBindings);
    }

    @Generated
    public void setPxEditBindings(BVector v) {
        this.set(pxEditBindings, (BValue)v, null);
    }

    @Generated
    public void lateSubscribe() {
        this.invoke(lateSubscribe, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Object getTemplateId() {
        if (this.getUID().equals((Object)BUuid.DEFAULT)) {
            return this.getTemplateName();
        }
        return this.getUID();
    }

    public void started() throws Exception {
        if (!this.isRunning()) {
            return;
        }
        try {
            BTemplateService service = this.getTemplateService();
            if (service != null) {
                service.register(this);
            }
            this.convertToBindings();
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
    }

    public void stopped() throws Exception {
        try {
            BTemplateService service = this.getTemplateService();
            if (service != null) {
                service.unregister(this);
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
    }

    public void atSteadyState() {
        this.propagateConfigurationIfNeeded();
        if (this.isRunning()) {
            BOrd ntplOrd = BOrd.NULL;
            try {
                if (this.getVersion().getVendor().isEmpty()) {
                    BComponent root = this.getParent().asComponent();
                    Optional optVendor = root.tags().get(TemplateConst.TEMPLATE_VENDOR_TAG_ID);
                    Optional optVersion = root.tags().get(TemplateConst.TEMPLATE_VERSION_TAG_ID);
                    if (optVendor.isPresent() && optVersion.isPresent()) {
                        this.setVersion(new BVersion(((BIDataValue)optVendor.get()).toString(), ((BIDataValue)optVersion.get()).toString()));
                    }
                    TemplateManifest manifest = this.getManifest();
                    if (!manifest.vendor.isEmpty()) {
                        FilePath ntplFilePath = new FilePath("^template/" + manifest.vendor).merge(this.getTemplateName() + ".ntpl");
                        ntplOrd = BOrd.make((OrdQuery)ntplFilePath);
                        ntplOrd.resolve();
                        this.get(this.add("ntplFile", (BValue)ntplOrd, 5));
                    }
                }
            }
            catch (UnresolvedException e) {
                BTemplateService.logger.warning(lex.getText("deploy.templateFileNotResolved", new Object[]{ntplOrd.toString()}));
            }
        }
    }

    private void propagateConfigurationIfNeeded() {
        if (!this.getPropagated()) {
            this.propagateConfiguration();
        }
    }

    public void propagateConfiguration() {
        BConfigBinding[] bindings;
        this.setPropagated(true);
        for (BConfigBinding binding : bindings = this.getConfigBindings()) {
            Property sourceProperty = this.getProperty(binding.getSourceSlot());
            String targetSlotOrAttribute = binding.getTargetSlot();
            try {
                BComplex bComplex = binding.getTargetOrd().resolve((BObject)this).get().asComplex();
                this.changeBoundPropertyOrAttribute(sourceProperty, bComplex, targetSlotOrAttribute, null);
            }
            catch (Exception e) {
                if (BTemplateService.logger.isLoggable(Level.FINE)) {
                    BTemplateService.logger.log(Level.FINE, "Cannot resolve Template configBinding: " + binding.getTargetOrd(), e);
                    continue;
                }
                BTemplateService.logger.warning("Cannot resolve Template configBinding: " + binding.getTargetOrd());
            }
        }
    }

    public void changed(Property p, Context cx) {
        BConfigBinding[] bindings;
        super.changed(p, cx);
        if (cx != null && cx.equals(Context.decoding)) {
            return;
        }
        BSpace space = this.getSpace();
        if (space == null) {
            return;
        }
        if (space instanceof BComponentSpace && !(space instanceof BBogSpace) && !this.isRunning()) {
            return;
        }
        if (p.equals(deployed) && this.isRunning()) {
            BComplex parent = this.getParent();
            if (parent instanceof BComponent) {
                BComponent deployRoot = parent.asComponent();
                TagDictionaryUtil.updateTagGroupRelations((BComponent)deployRoot, (Logger)BTemplateService.logger);
            }
            return;
        }
        for (BConfigBinding binding : bindings = this.getConfigBindings()) {
            if (!binding.getSourceSlot().equals(p.getName())) continue;
            String targetSlotOrAttribute = binding.getTargetSlot();
            BComplex targetObject = binding.getTargetOrd().resolve((BObject)this).get().asComplex();
            this.changeBoundPropertyOrAttribute(p, targetObject, targetSlotOrAttribute, cx);
            return;
        }
    }

    private void changeBoundPropertyOrAttribute(Property newValueProperty, BComplex targetObject, String slotOrAttribute, Context cx) {
        if (slotOrAttribute.startsWith(ATTRIBUTE_PREFIX)) {
            BTemplateConfig.changeAttribute(slotOrAttribute, targetObject, this.get(newValueProperty), cx);
        } else {
            this.changeBoundProperty(newValueProperty, targetObject, slotOrAttribute);
        }
    }

    private void changeBoundProperty(Property newValueProperty, BComplex targetObject, String slotName) {
        BValue changedValue = this.get(newValueProperty);
        BPassword newValue = null;
        if (changedValue instanceof BPassword) {
            newValue = this.extractPassword(newValueProperty, (BPassword)changedValue);
        } else if (changedValue instanceof BUsernameAndPassword) {
            newValue = this.extractUsernameAndPassword(newValueProperty, (BUsernameAndPassword)changedValue);
        } else if (!targetObject.get(slotName).equivalent((Object)changedValue)) {
            newValue = changedValue.newCopy();
        }
        if (newValue != null) {
            targetObject.set(slotName, (BValue)newValue);
        }
    }

    private BPassword extractPassword(Property passwordProperty, BPassword passwordValue) {
        BPassword extractedPassword = null;
        if (!passwordValue.isDefault()) {
            extractedPassword = BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)passwordValue).getValue()));
            this.set(passwordProperty, (BValue)BPassword.DEFAULT);
        }
        return extractedPassword;
    }

    private BUsernameAndPassword extractUsernameAndPassword(Property usernameAndPasswordProperty, BUsernameAndPassword usernameAndPasswordValue) {
        BUsernameAndPassword extracted = null;
        if (!usernameAndPasswordValue.getPassword().isDefault()) {
            String changedUsername = usernameAndPasswordValue.getUsername();
            BPassword changedPassword = usernameAndPasswordValue.getPassword();
            BPassword transferablePassword = BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)changedPassword).getValue()));
            extracted = new BUsernameAndPassword(changedUsername, transferablePassword);
            this.set(usernameAndPasswordProperty, (BValue)new BUsernameAndPassword(changedUsername, BPassword.DEFAULT));
        }
        return extracted;
    }

    private static void changeAttribute(String attributeId, BComplex targetObject, BValue newValue, Context cx) {
        switch (attributeId) {
            case "#Name": {
                BTemplateConfig.changeNameAttribute(targetObject, newValue.toString());
                break;
            }
            case "#DisplayName": {
                BTemplateConfig.changeDisplayNameAttribute(targetObject, BFormat.make((String)newValue.toString()), cx);
            }
        }
    }

    private static void changeNameAttribute(BComplex targetObject, String newName) {
        Property targetProperty = targetObject.getPropertyInParent();
        if (targetProperty != null && targetProperty.isDynamic()) {
            String newTargetSlotName = SlotPath.escape((String)newName);
            if (!targetProperty.getName().equals(newTargetSlotName)) {
                BComponent targetParent = targetObject.getParent().asComponent();
                targetParent.rename(targetProperty, newTargetSlotName);
            }
        }
    }

    private static void changeDisplayNameAttribute(BComplex targetObject, BFormat newDisplayNameFormat, Context cx) {
        BComponent targetParent;
        Property targetProperty = targetObject.getPropertyInParent();
        if (targetProperty != null && !Objects.equals((targetParent = targetObject.getParent().asComponent()).getDisplayNameFormat(targetProperty), newDisplayNameFormat)) {
            targetParent.setDisplayName(targetProperty, newDisplayNameFormat, cx);
        }
    }

    public void added(Property property, Context context) {
        BConfigBinding binding;
        Optional<BComplex> complexOptional;
        super.added(property, context);
        Optional<BConfigBinding> optional = this.getConfigBinding((Slot)property);
        if (optional.isPresent() && (complexOptional = (binding = optional.get()).getTarget()).isPresent()) {
            BComplex targetComplex = complexOptional.get();
            String targetSlotOrAttribute = binding.getTargetSlot();
            this.changeBoundPropertyOrAttribute(property, targetComplex, targetSlotOrAttribute, context);
        }
    }

    public void updatePxEditBindings(ArrayList<SlotPath> pxEditTarget) {
        BVector v = new BVector();
        for (SlotPath slotPath : pxEditTarget) {
            v.add("pxe?", (BValue)BString.make((String)slotPath.toString()), null);
        }
        this.setPxEditBindings(v);
    }

    private Optional<BConfigBinding> getConfigBinding(BComponent targetComp, String targetSlotOrAttribute) {
        BConfigBinding[] bindings;
        for (BConfigBinding binding : bindings = this.getConfigBindings()) {
            if (!binding.getTargetOrd().equals((Object)targetComp.getHandleOrd()) || !binding.getTargetSlot().equals(targetSlotOrAttribute)) continue;
            return Optional.of(binding);
        }
        return Optional.empty();
    }

    public Optional<BConfigBinding> getConfigBinding(Slot slot) {
        BConfigBinding[] bindings;
        for (BConfigBinding binding : bindings = this.getConfigBindings()) {
            if (!binding.getSourceSlot().equals(slot.getName())) continue;
            return Optional.of(binding);
        }
        return Optional.empty();
    }

    public void subscribed() {
        if (this.isRunning()) {
            if (this.subscribedTicket != null) {
                this.subscribedTicket.cancel();
            }
            this.subscribedTicket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)500L), (Action)lateSubscribe, null);
        } else {
            this.doLateSubscribe();
        }
    }

    public void doLateSubscribe() {
        BConfigBinding[] bindings;
        for (BConfigBinding binding : bindings = this.getConfigBindings()) {
            BComplex bindingTargetParent;
            String sourceSlot;
            BValue sourceValue;
            Optional<BComplex> possibleBindingTarget = binding.getTarget();
            if (!possibleBindingTarget.isPresent()) continue;
            BComplex bindingTarget = possibleBindingTarget.get();
            String targetSlotOrAttribute = binding.getTargetSlot();
            boolean doSubscribe = true;
            boolean doSubscribeToParent = false;
            BValue targetValue = null;
            if (targetSlotOrAttribute.startsWith(ATTRIBUTE_PREFIX)) {
                switch (targetSlotOrAttribute) {
                    case "#Name": {
                        targetValue = BString.make((String)bindingTarget.getName());
                        doSubscribe = false;
                        doSubscribeToParent = true;
                        break;
                    }
                    case "#DisplayName": {
                        BFormat targetValueFormat = bindingTarget.getParent().asComponent().getDisplayNameFormat(bindingTarget.getPropertyInParent());
                        targetValue = targetValueFormat == null ? BString.DEFAULT : BString.make((String)targetValueFormat.toString(null));
                        doSubscribeToParent = true;
                    }
                }
            } else {
                targetValue = bindingTarget.get(targetSlotOrAttribute);
                if (targetValue instanceof BPassword) {
                    targetValue = BPassword.DEFAULT;
                    doSubscribe = false;
                } else if (targetValue instanceof BUsernameAndPassword) {
                    targetValue = new BUsernameAndPassword(((BUsernameAndPassword)targetValue).getUsername(), BPassword.DEFAULT);
                } else if (targetValue != null) {
                    targetValue = targetValue.newCopy();
                }
            }
            if (targetValue != null && (sourceValue = this.get(sourceSlot = binding.getSourceSlot())) != null && !sourceValue.equivalent((Object)targetValue)) {
                this.set(sourceSlot, targetValue);
            }
            if (doSubscribe && bindingTarget.isComponent()) {
                this.subscribeTo(bindingTarget.asComponent());
            }
            if (!doSubscribeToParent || (bindingTargetParent = bindingTarget.getParent()) == null || !bindingTargetParent.isComponent()) continue;
            this.subscribeTo(bindingTargetParent.asComponent());
        }
    }

    private void subscribeTo(BComponent targetComponent) {
        if (targetComponent == null) {
            return;
        }
        if (this.subscriber == null) {
            this.subscriber = new TargetSubscriber(this);
        }
        if (!this.subscriber.isSubscribed(targetComponent)) {
            this.subscriber.subscribe(targetComponent);
        }
    }

    public void unsubscribed() {
        BConfigBinding[] bindings;
        if (this.subscriber == null) {
            return;
        }
        for (BConfigBinding binding : bindings = this.getConfigBindings()) {
            BComplex target;
            Optional<BComplex> optionalTarget = binding.getTarget();
            if (!optionalTarget.isPresent() || !(target = optionalTarget.get()).isComponent() || !this.subscriber.isSubscribed(target.asComponent())) continue;
            this.subscriber.unsubscribe(target.asComponent());
        }
    }

    public BTemplateService getTemplateService() {
        if (this.templateService == null) {
            this.templateService = (BTemplateService)Sys.getService((Type)BTemplateService.TYPE);
        }
        return this.templateService;
    }

    public TemplateManifest getManifest() {
        if (this.manifest == null) {
            this.manifest = this.generateManifest();
        }
        return this.manifest;
    }

    public boolean hasConfigProperties() {
        return this.getConfigBindings().length > 0;
    }

    public BPasswordBinding[] getPasswordBindings() {
        return (BPasswordBinding[])this.getChildren(BPasswordBinding.class);
    }

    public BConfigBinding[] getConfigBindings() {
        return (BConfigBinding[])this.getChildren(BConfigBinding.class);
    }

    public void checkForValidTemplate() throws Exception {
        for (Slot slot : this.getInputSlots()) {
            if (this.getInputSlotTags(slot) != null) continue;
            throw new Exception(lex.getText("inputCompositeLinkNotFound", new Object[]{slot.getName()}));
        }
        for (Slot slot : this.getOutputSlots()) {
            if (this.getOutputSlotTags(slot) != null) continue;
            throw new Exception(lex.getText("outputCompositeLinkNotFound", new Object[]{slot.getName()}));
        }
    }

    public void clearCacheValues() {
        this.manifest = null;
        this.inputSlots = null;
        this.outputSlots = null;
        this.relations = null;
        this.unboundRelations = null;
        this.unLinkedInputSlots = null;
        this.unLinkedOutputSlots = null;
        this.passwords = null;
    }

    public Slot[] getUnlinkedInputs() {
        if (this.unLinkedInputSlots != null) {
            return (Slot[])this.unLinkedInputSlots.trim();
        }
        this.unLinkedInputSlots = new Array(Slot.class);
        BComponent parent = this.getParent().asComponent();
        for (Slot slot : this.getInputSlots()) {
            if (parent.getLinks(slot).length != 0) continue;
            this.unLinkedInputSlots.add((Object)slot);
        }
        return (Slot[])this.unLinkedInputSlots.trim();
    }

    public Slot[] getInputSlots() {
        if (this.inputSlots != null) {
            return (Slot[])this.inputSlots.trim();
        }
        this.inputSlots = new Array(Slot.class);
        BComponent parent = this.getParent().asComponent();
        SlotCursor sc = parent.getProperties();
        while (sc.next()) {
            Property p = sc.property();
            if (!BTemplateConfig.isInputSlot(parent, (Slot)p)) continue;
            this.inputSlots.add((Object)p);
        }
        return (Slot[])this.inputSlots.trim();
    }

    public Slot[] getUnlinkedOutputs() {
        if (this.unLinkedOutputSlots != null) {
            return (Slot[])this.unLinkedOutputSlots.trim();
        }
        this.unLinkedOutputSlots = new Array(Slot.class);
        BComponent parent = this.getParent().asComponent();
        for (Slot slot : this.getOutputSlots()) {
            if (parent.getKnobs(slot).length != 0) continue;
            this.unLinkedOutputSlots.add((Object)slot);
        }
        return (Slot[])this.unLinkedOutputSlots.trim();
    }

    public Slot[] getOutputSlots() {
        if (this.outputSlots != null) {
            return (Slot[])this.outputSlots.trim();
        }
        this.outputSlots = new Array(Slot.class);
        BComponent parent = this.getParent().asComponent();
        SlotCursor sc = parent.getProperties();
        while (sc.next()) {
            Property p = sc.property();
            if (!BTemplateConfig.isOutputSlot(parent, (Slot)p)) continue;
            this.outputSlots.add((Object)p);
        }
        return (Slot[])this.outputSlots.trim();
    }

    public Tags getInputSlotTags(Slot slot) {
        BComponent parent = this.getParent().asComponent();
        parent.lease();
        Knob[] knobs = parent.getKnobs(slot);
        if (knobs != null && knobs.length > 0) {
            BOrd targetOrd = knobs[0].getTargetOrd();
            OrdTarget ordTarget = targetOrd.resolve((BObject)this);
            BComponent target = ordTarget.get().asComponent();
            Property targetSlot = target.getProperty(knobs[0].getTargetSlotName());
            BLink[] links = target.getLinks((Slot)targetSlot);
            return links[0].tags();
        }
        return null;
    }

    public Tags getOutputSlotTags(Slot slot) {
        BComponent parent = this.getParent().asComponent();
        BLink[] links = parent.getLinks(slot);
        if (links != null && links.length > 0) {
            return links[0].tags();
        }
        return null;
    }

    public ArrayList<BPasswordBinding> getPasswordInfos() {
        if (this.passwords != null) {
            return this.passwords;
        }
        this.passwords = new ArrayList();
        for (BPasswordBinding password : (BPasswordBinding[])this.getChildren(BPasswordBinding.class)) {
            if (!password.isPasswordDefault()) continue;
            this.passwords.add(password);
        }
        return this.passwords;
    }

    public ArrayList<BRelationInfo> getRelationInfos() {
        if (this.relations == null) {
            this.relations = new ArrayList();
            Collections.addAll(this.relations, this.getChildren(BRelationInfo.class));
        }
        return this.relations;
    }

    public ArrayList<BRelationInfo> getUnboundRelationInfos() {
        if (this.unboundRelations != null) {
            return this.unboundRelations;
        }
        this.unboundRelations = new ArrayList();
        BComponent parent = this.getParent().asComponent();
        parent.lease();
        Relations existingRelations = parent.relations();
        for (BRelationInfo relationInfo : this.getRelationInfos()) {
            Optional optional = existingRelations.get(Id.newId((String)relationInfo.relationId), relationInfo.inbound ? 1 : 2);
            if (optional.isPresent()) continue;
            this.unboundRelations.add(BRelationInfo.make(relationInfo.inbound, relationInfo.relationId, relationInfo.relateHints, relationInfo.userTip, relationInfo.slotPathScope));
        }
        return this.unboundRelations;
    }

    private TemplateManifest generateManifest() {
        BVersion versonPropValue = this.getVersion();
        boolean isVersionPropNull = versonPropValue.equivalent((Object)BVersion.ZERO);
        String vendor = versonPropValue.getVendor();
        String version = isVersionPropNull ? "1.0" : versonPropValue.getVendorVersion().toString();
        TemplateManifest manifest = new TemplateManifest();
        manifest.vendor = vendor.isEmpty() ? "Tridium" : vendor;
        if (!version.isEmpty()) {
            manifest.version = version;
        }
        manifest.uID = this.getUID();
        manifest.state = BTemplateState.DEFAULT;
        manifest.isApplication = this.getPropertyInParent().isFrozen();
        manifest.isStation = manifest.isApplication || this.getParent() instanceof BStation;
        SlotCursor sc = this.getProperties();
        sc.next();
        while (sc.next()) {
            manifest.settings.add((Object)this.makeValue((BComplex)this, sc.property(), sc.get(), "cfg"));
        }
        manifest.uID = this.getUID();
        if (this.getVersion() != null) {
            manifest.version = this.getVersion().getVendorVersionString();
        }
        BComponent parent = this.getParent().asComponent();
        sc = parent.getProperties();
        while (sc.next()) {
            Knob[] knobs;
            Property p = sc.property();
            BValue v = sc.get();
            if ((parent.getFlags((Slot)p) & 0x8000) != 0) {
                manifest.links.add((Object)this.makeValue((BComplex)parent, p, v, "out"));
                continue;
            }
            if ((parent.getFlags((Slot)p) & 0x1000) == 0 || (knobs = parent.getKnobs((Slot)p)).length <= 0) continue;
            manifest.links.add((Object)this.makeValue((BComplex)parent, p, v, "in"));
        }
        return manifest;
    }

    private TemplateManifest.Value makeValue(BComplex parent, Property p, BValue v, String dir) {
        TemplateManifest.Value value = new TemplateManifest.Value();
        value.name = p.getName();
        value.required = true;
        value.direction = dir;
        BFacets f = parent.getSlotFacets((Slot)p);
        if (v instanceof BINumeric) {
            BUnit u;
            value.type = "num";
            if (f != null && (u = (BUnit)f.get("units")) != null) {
                value.hasUnit = true;
                value.unit = u.getUnitName();
            }
        } else {
            value.type = v instanceof BIBoolean ? "bool" : "str";
        }
        return value;
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        agents.remove("template:TemplateMenuAgent");
        return agents;
    }

    private static boolean isInputSlot(BComponent object, Slot slot) {
        if (object.get(slot.asProperty()) instanceof BLink) {
            return false;
        }
        int flags = object.getFlags(slot);
        return (flags & COMPOSITE_READONLY) == 4096;
    }

    private static boolean isOutputSlot(BComponent object, Slot slot) {
        if (object.get(slot.asProperty()) instanceof BLink) {
            return false;
        }
        int flags = object.getFlags(slot);
        return (flags & COMPOSITE_READONLY) == COMPOSITE_READONLY;
    }

    public void convertToBindings() {
        Knob[] knobs = this.getKnobs();
        if (knobs.length > 0) {
            BComponent parent = this.getParent().asComponent();
            for (Knob knob : knobs) {
                String b;
                BComponent targetComp = (BComponent)knob.getTargetOrd().resolve((BObject)this).get();
                String a = targetComp.getSlotPath().toString();
                if (!a.startsWith(b = parent.getSlotPath().toString())) continue;
                String source = knob.getSourceSlotName();
                String target = knob.getTargetSlotName();
                Slot targetSlot = knob.getTargetSlot();
                if (this.getProperty(source) == null) {
                    targetComp.setFlags(targetSlot, targetComp.getFlags(targetSlot) & 0xFFFFFFFE);
                    targetComp.remove(knob.getLink().getName());
                    continue;
                }
                BConfigBinding configBinding = new BConfigBinding(targetComp.getHandleOrd(), source, target);
                this.add(null, (BValue)configBinding, 4);
                targetComp.setFlags(targetSlot, targetComp.getFlags(targetSlot) & 0xFFFFFFFE | Integer.MIN_VALUE);
                targetComp.remove(knob.getLink().getName());
                targetComp.set(target, this.get(source).newCopy());
            }
        }
    }

    public static BTemplateConfig createConfigForRoot(BComponent root) {
        return BTemplateConfig.createConfigForRoot(root, false);
    }

    public static BTemplateConfig createConfigForApplication(BStation root) {
        return BTemplateConfig.createConfigForRoot((BComponent)root, true);
    }

    public static BTemplateConfig createConfigForRoot(BComponent root, boolean isApplication) {
        BTemplateConfig config = BTemplateConfig.getConfigForRoot(root, isApplication);
        if (config != null) {
            return null;
        }
        if (!isApplication) {
            config = new BTemplateConfig();
            root.add("templateConfig", (BValue)config, 0, BFacets.make((String)"ntplCreation", (boolean)true), null);
        } else if (root instanceof BStation) {
            BStation stationRoot = (BStation)root;
            BApplicationService appService = new BApplicationService();
            stationRoot.getServices().add("ApplicationService", (BValue)appService);
            config = appService.getConfiguration();
        }
        return config;
    }

    public static BTemplateConfig getConfigForRoot(BComponent root) {
        return BTemplateConfig.getConfigForRoot(root, true);
    }

    public static BTemplateConfig getConfigForRoot(BComponent root, boolean isApplication) {
        BTemplateConfig[] tcs = (BTemplateConfig[])root.getChildren(BTemplateConfig.class);
        if (tcs != null && tcs.length > 0) {
            return tcs[0];
        }
        if (!(root instanceof BStation)) {
            return null;
        }
        if (isApplication) {
            return BTemplateConfig.getConfigForApplication((BStation)root);
        }
        return null;
    }

    public static BTemplateConfig getConfigForApplication(BStation station) {
        station.lease();
        BServiceContainer services = station.getServices();
        services.lease();
        BApplicationService[] applicationServices = (BApplicationService[])services.getChildren(BApplicationService.class);
        if (applicationServices == null || applicationServices.length == 0 || applicationServices[0] == null) {
            return null;
        }
        BApplicationService applicationService = applicationServices[0];
        applicationService.lease();
        return applicationService.getConfiguration();
    }

    public static BTemplateConfig getOrCreateConfigForRoot(BComponent root) {
        return BTemplateConfig.getOrCreateConfigForRoot(root, false);
    }

    public static BTemplateConfig getOrCreateConfigForApplication(BStation station) {
        return BTemplateConfig.getOrCreateConfigForRoot((BComponent)station, true);
    }

    public static BTemplateConfig getOrCreateConfigForRoot(BComponent root, boolean isApplication) {
        BTemplateConfig config = BTemplateConfig.getConfigForRoot(root, isApplication);
        if (config != null) {
            Property configProp = config.getPropertyInParent();
            if (configProp.isDynamic() && isApplication || configProp.isFrozen() && !isApplication) {
                config = null;
            }
        } else {
            config = BTemplateConfig.createConfigForRoot(root, isApplication);
        }
        return config;
    }

    public static void removeConfigFromRoot(BComponent root) {
        BTemplateConfig config = BTemplateConfig.getConfigForRoot(root);
        if (config != null) {
            if (config.getPropertyInParent().isDynamic()) {
                root.remove((BComplex)config);
            } else if (root instanceof BStation) {
                ((BStation)root).getServices().remove(config.getParent());
            }
        }
    }

    public static BComponent getRootForConfig(BTemplateConfig config) {
        if (config == null) {
            return null;
        }
        BComplex parent = config.getParent();
        if (parent == null) {
            return null;
        }
        if (config.getPropertyInParent().isDynamic()) {
            return parent.asComponent();
        }
        BComplex services = parent.getParent();
        if (services == null) {
            return null;
        }
        BComplex root = services.getParent();
        if (root == null) {
            return null;
        }
        return root.asComponent();
    }

    private static class TargetSubscriber
    extends Subscriber {
        BTemplateConfig templateConfig;

        TargetSubscriber(BTemplateConfig templateConfig) {
            this.templateConfig = templateConfig;
            this.setMask(BComponentEventMask.make((int)1));
        }

        public void event(BComponentEvent event) {
            if (event.getId() == 0) {
                BComponent eventComponent = event.getSourceComponent();
                String eventSlotName = event.getSlot().getName();
                if (eventSlotName.equals("displayNames")) {
                    BNameMap newNameMap = (BNameMap)event.getValue();
                    this.refreshDisplayNameConfig(eventComponent, newNameMap);
                } else {
                    Optional optional = this.templateConfig.getConfigBinding(eventComponent, eventSlotName);
                    if (optional.isPresent()) {
                        Object eventValue = event.getValue();
                        eventValue = eventValue instanceof BPassword ? BPassword.DEFAULT : (eventValue instanceof BUsernameAndPassword ? new BUsernameAndPassword(((BUsernameAndPassword)eventValue).getUsername(), BPassword.DEFAULT) : eventValue.newCopy());
                        String sourceSlot = ((BConfigBinding)((Object)optional.get())).getSourceSlot();
                        if (!this.templateConfig.get(sourceSlot).equivalent(eventValue)) {
                            this.templateConfig.set(sourceSlot, (BValue)eventValue);
                        }
                    }
                }
            } else if (event.getId() == 3) {
                Optional optional;
                BValue renamedPropertyValue;
                BComponent eventComponent = event.getSourceComponent();
                Property eventProperty = (Property)event.getSlot();
                if (eventProperty != null && (renamedPropertyValue = eventComponent.get(eventProperty)) != null && renamedPropertyValue.isComponent() && (optional = this.templateConfig.getConfigBinding(renamedPropertyValue.asComponent(), BTemplateConfig.NAME_ATTRIBUTE)).isPresent()) {
                    BString newName = BString.make((String)eventProperty.getName());
                    String sourceSlot = ((BConfigBinding)((Object)optional.get())).getSourceSlot();
                    if (!this.templateConfig.get(sourceSlot).equivalent((Object)newName)) {
                        this.templateConfig.set(sourceSlot, (BValue)newName);
                    }
                }
                this.refreshDisplayNameConfig(eventComponent);
            }
        }

        private void refreshDisplayNameConfig(BComponent parentComponent) {
            this.refreshDisplayNameConfig(parentComponent, (BNameMap)parentComponent.get("displayNames"));
        }

        private void refreshDisplayNameConfig(BComponent parentComponent, BNameMap newNameMap) {
            for (Property property : parentComponent.getPropertiesArray()) {
                String sourceSlot;
                BFormat newDisplayNameFormat;
                Optional optional;
                BValue displayNameTarget = parentComponent.get(property);
                if (!displayNameTarget.isComponent() || !(optional = this.templateConfig.getConfigBinding(displayNameTarget.asComponent(), BTemplateConfig.DISPLAY_NAME_ATTRIBUTE)).isPresent()) continue;
                BString newDisplayNameValue = BString.DEFAULT;
                if (newNameMap != null && (newDisplayNameFormat = newNameMap.get(property.getName())) != null) {
                    newDisplayNameValue = BString.make((String)newDisplayNameFormat.toString(null));
                }
                if (this.templateConfig.get(sourceSlot = ((BConfigBinding)((Object)optional.get())).getSourceSlot()).equivalent((Object)newDisplayNameValue)) continue;
                this.templateConfig.set(sourceSlot, (BValue)newDisplayNameValue);
            }
        }
    }
}

