/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.api.impl;

import com.tridium.template.BTemplateConfig;
import com.tridium.template.UpgradeUtil;
import com.tridium.template.api.impl.CombinedTemplateSource;
import com.tridium.template.api.impl.FileTemplateSource;
import com.tridium.template.api.impl.InstalledApplicationTemplateSource;
import com.tridium.template.api.impl.NewApplicationTemplateSource;
import com.tridium.template.api.impl.NewComponentTemplateSource;
import com.tridium.template.api.impl.NewDeviceTemplateSource;
import com.tridium.template.api.impl.NewStationTemplateSource;
import com.tridium.template.api.impl.NewTemplateSource;
import com.tridium.template.api.impl.TemplateSource;
import com.tridium.template.api.impl.TemplateSourceWithValue;
import com.tridium.template.file.BNtplFile;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.baja.driver.BDevice;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.FilePath;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BStation;
import javax.baja.sys.Sys;

public final class TemplateSourceFactory {
    private static final String STATION_TEMP_DIR = "^temp/";
    private static final String WB_TEMP_DIR = "~temp/";

    public static NewTemplateSource create(BComponent sourceComponent) {
        return TemplateSourceFactory.create(sourceComponent, null, null, false);
    }

    public static NewTemplateSource create(BComponent sourceComponent, BIDirectory sourceHomeDir) {
        return TemplateSourceFactory.create(sourceComponent, sourceHomeDir, null, false);
    }

    public static NewTemplateSource create(BStation sourceStation, boolean createAsApplication) {
        return TemplateSourceFactory.create((BComponent)sourceStation, null, null, createAsApplication);
    }

    public static NewTemplateSource create(BComponent sourceStation, BIDirectory sourceHomeDir, boolean createAsApplication) {
        return TemplateSourceFactory.create(sourceStation, sourceHomeDir, null, createAsApplication);
    }

    public static NewTemplateSource create(BComponent sourceComponent, BIDirectory sourceHomeDir, BIDirectory sourceProtectedHomeDir, boolean createAsApplication) {
        Objects.requireNonNull(sourceComponent);
        NewTemplateSource result = null;
        if (sourceComponent instanceof BStation) {
            result = createAsApplication ? new NewApplicationTemplateSource((BStation)sourceComponent, sourceHomeDir, sourceProtectedHomeDir) : new NewStationTemplateSource((BStation)sourceComponent, sourceHomeDir, sourceProtectedHomeDir);
        } else if (sourceComponent instanceof BDevice) {
            result = new NewDeviceTemplateSource(sourceComponent, sourceHomeDir, sourceProtectedHomeDir);
        } else if (sourceComponent.getPropertyInParent() == null || sourceComponent.getPropertyInParent().isDynamic()) {
            result = new NewComponentTemplateSource(sourceComponent, sourceHomeDir, sourceProtectedHomeDir);
        }
        return result;
    }

    public static TemplateSource open(BComponent deployedTemplate) {
        TemplateSourceWithValue fileSource;
        InstalledApplicationTemplateSource templateSource = null;
        if (deployedTemplate instanceof BStation) {
            templateSource = InstalledApplicationTemplateSource.make((BStation)deployedTemplate);
        }
        TemplateSourceWithValue templateSourceWithValue = fileSource = templateSource == null ? null : TemplateSourceFactory.loadFileSource(templateSource.getConfig());
        return templateSource == null ? null : (fileSource == null ? templateSource : new CombinedTemplateSource(templateSource, fileSource));
    }

    private static TemplateSourceWithValue loadFileSource(BTemplateConfig config) {
        FileTemplateSource fileSource = null;
        try {
            BNtplFile tempFile = (BNtplFile)UpgradeUtil.getDeployedNtplFile(config, "^applicationTemplate/", "napl");
            FilePath temporaryFilePath = Sys.isStation() ? new FilePath(STATION_TEMP_DIR + tempFile.getFileName()) : new FilePath(WB_TEMP_DIR + tempFile.getFileName());
            BNtplFile templateFile = (BNtplFile)BFileSystem.INSTANCE.makeFile(temporaryFilePath);
            try (InputStream in = tempFile.getInputStream();
                 OutputStream out = templateFile.getOutputStream();){
                FileUtil.pipe((InputStream)in, (OutputStream)out);
            }
            fileSource = FileTemplateSource.load(templateFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileSource;
    }

    private TemplateSourceFactory() {
    }
}

