/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.template.api.impl;

import com.tridium.template.api.TemplateValueSource;
import com.tridium.template.api.TemplateValueType;
import com.tridium.template.api.impl.TemplateSource;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.IntStream;
import javax.baja.security.BPassword;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;

public abstract class TemplateSourceWithValue
extends TemplateSource {
    protected BValue getPropertyValue(int propertyKey) {
        throw new UnsupportedOperationException("TemplateSourceWithValue.getPropertyValue not yet implemented!");
    }

    protected abstract TemplateValueSource getValueSource();

    @Override
    public IntStream getElementKeyStream(int propertyKey) {
        return IntStream.range(0, TemplateSourceWithValue.getElementCountForPropertyValue(this.getPropertyValue(propertyKey)));
    }

    @Override
    public String getElementName(int propertyKey, int elementKey) {
        BValue propertyValue = this.getPropertyValue(propertyKey);
        if (TemplateSourceWithValue.isPropertyPrimitive(propertyValue)) {
            return null;
        }
        return ((BStruct)propertyValue).getPropertiesArray()[elementKey].getName();
    }

    @Override
    public TemplateValueType getValueType(int propertyKey, int elementKey) {
        BValue elementValue = this.getPropertyElementValue(propertyKey, elementKey);
        if (elementValue instanceof BInteger || elementValue instanceof BLong) {
            return TemplateValueType.INTEGER;
        }
        if (elementValue instanceof BNumber) {
            return TemplateValueType.NUMERIC;
        }
        if (elementValue instanceof BBoolean) {
            return TemplateValueType.BOOLEAN;
        }
        if (elementValue instanceof BEnum) {
            return TemplateValueType.ENUM;
        }
        if (elementValue instanceof BPassword) {
            return TemplateValueType.PASSWORD;
        }
        return TemplateValueType.STRING;
    }

    @Override
    public boolean isValueNullable(int propertyKey, int elementKey) {
        BValue elementValue = this.getPropertyElementValueWithStatus(propertyKey, elementKey);
        return elementValue instanceof BStatusValue;
    }

    @Override
    public String getValueNType(int propertyKey, int elementKey) {
        return this.getPropertyElementValueWithStatus(propertyKey, elementKey).getType().toString();
    }

    @Override
    public boolean hasLocalValue(int propertyKey) {
        return this.getValueSource() == TemplateValueSource.LOCAL_VALUE;
    }

    @Override
    public boolean isValueMissing(int propertyKey, TemplateValueSource valueSource) {
        return this.clarifyValueSource(valueSource) != this.getValueSource();
    }

    @Override
    public boolean isValueNull(int propertyKey, int elementKey, TemplateValueSource valueSource) {
        this.checkValueSource(valueSource);
        BValue elementValue = this.getPropertyElementValueWithStatus(propertyKey, elementKey);
        if (elementValue instanceof BStatusValue) {
            return ((BStatusValue)elementValue).getStatus().isNull();
        }
        return false;
    }

    @Override
    public double getNumericValue(int propertyKey, int elementKey, TemplateValueSource valueSource) throws NumberFormatException {
        this.checkValueSource(valueSource);
        BValue elementValue = this.getPropertyElementValue(propertyKey, elementKey);
        if (elementValue instanceof BNumber) {
            return ((BNumber)elementValue).getDouble();
        }
        if (elementValue instanceof BEnum) {
            return ((BEnum)elementValue).getOrdinal();
        }
        if (elementValue instanceof BString) {
            return Double.parseDouble(elementValue.toString(null));
        }
        throw new IllegalStateException("not convertible to number " + elementValue.toString(null));
    }

    @Override
    public long getIntegerValue(int propertyKey, int elementKey, TemplateValueSource valueSource) throws NumberFormatException {
        this.checkValueSource(valueSource);
        BValue elementValue = this.getPropertyElementValue(propertyKey, elementKey);
        if (elementValue instanceof BNumber) {
            return ((BNumber)elementValue).getLong();
        }
        if (elementValue instanceof BEnum) {
            return ((BEnum)elementValue).getOrdinal();
        }
        if (elementValue instanceof BString) {
            return Long.parseLong(elementValue.toString(null));
        }
        throw new IllegalStateException("not convertible to integer " + elementValue.toString(null));
    }

    @Override
    public boolean getBooleanValue(int propertyKey, int elementKey, TemplateValueSource valueSource) throws IllegalArgumentException {
        this.checkValueSource(valueSource);
        BValue elementValue = this.getPropertyElementValue(propertyKey, elementKey);
        if (elementValue instanceof BBoolean) {
            return ((BBoolean)elementValue).getBoolean();
        }
        if (elementValue instanceof BString) {
            return BBoolean.decode((String)elementValue.toString(null));
        }
        throw new IllegalStateException("not convertible to boolean " + elementValue.toString(null));
    }

    @Override
    public String getStringValue(int propertyKey, int elementKey, TemplateValueSource valueSource) {
        String result;
        this.checkValueSource(valueSource);
        BValue elementValue = this.getPropertyElementValue(propertyKey, elementKey);
        if (elementValue instanceof BEnum) {
            result = ((BEnum)elementValue).getTag();
        } else {
            if (elementValue instanceof BPassword) {
                throw new IllegalStateException("can't read password value");
            }
            if (elementValue instanceof BSimple) {
                try {
                    result = ((BSimple)elementValue).encodeToString();
                }
                catch (IOException ignore) {
                    result = elementValue.toString(null);
                }
            } else {
                result = elementValue.toString(null);
            }
        }
        return result;
    }

    @Override
    public Map<Integer, String> getDefinedEnumValues(int propertyKey, int elementKey, TemplateValueSource valueSource) {
        this.checkValueSource(valueSource);
        BValue elementValue = this.getPropertyElementValue(propertyKey, elementKey);
        if (elementValue instanceof BEnum) {
            BEnum enumValue = (BEnum)elementValue;
            BEnumRange enumRange = enumValue.getRange();
            if (enumRange.isNull()) {
                return Collections.emptyMap();
            }
            TreeMap<Integer, String> values = new TreeMap<Integer, String>();
            for (int ordinal : enumRange.getOrdinals()) {
                values.put(ordinal, enumRange.getTag(ordinal));
            }
            return Collections.unmodifiableMap(values);
        }
        throw new IllegalStateException("enum expected " + elementValue.toString(null));
    }

    private BValue getPropertyElementValue(int propertyKey, int elementKey) {
        return TemplateSourceWithValue.getPropertyElementValue(this.getPropertyValue(propertyKey), elementKey);
    }

    private BValue getPropertyElementValueWithStatus(int propertyKey, int elementKey) {
        return TemplateSourceWithValue.getPropertyElementValueWithStatus(this.getPropertyValue(propertyKey), elementKey);
    }

    private TemplateValueSource clarifyValueSource(TemplateValueSource valueSource) {
        return valueSource == TemplateValueSource.PRESENT_VALUE || valueSource == TemplateValueSource.NON_VALUE ? this.getValueSource() : valueSource;
    }

    private void checkValueSource(TemplateValueSource valueSource) {
        if (this.clarifyValueSource(valueSource) != this.getValueSource()) {
            throw new IllegalStateException("missing " + valueSource.toString());
        }
    }

    private static BValue getPropertyElementValue(BValue propertyValue, int elementKey) {
        BValue elementValue = TemplateSourceWithValue.getPropertyElementValueWithStatus(propertyValue, elementKey);
        if (elementValue instanceof BStatusValue) {
            return ((BStatusValue)elementValue).getValueValue();
        }
        return elementValue;
    }

    private static BValue getPropertyElementValueWithStatus(BValue propertyValue, int elementKey) {
        if (TemplateSourceWithValue.isPropertyPrimitive(propertyValue)) {
            return propertyValue;
        }
        BStruct structValue = (BStruct)propertyValue;
        return structValue.get(structValue.getPropertiesArray()[elementKey]);
    }

    private static int getElementCountForPropertyValue(BValue propertyValue) {
        if (TemplateSourceWithValue.isPropertyPrimitive(propertyValue)) {
            return 1;
        }
        return ((BStruct)propertyValue).getPropertyCount();
    }

    private static boolean isPropertyPrimitive(BValue propertyValue) {
        if (propertyValue instanceof BStatusValue) {
            return true;
        }
        return !(propertyValue instanceof BStruct);
    }
}

