/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.nws;

import com.tridium.weather.AirQualityIndexUtil;
import com.tridium.weather.nws.BNwsWeatherProvider;
import com.tridium.weather.nws.FeedReader;
import com.tridium.weather.nws.NwsStationList;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.status.BStatus;
import javax.baja.sys.BajaException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BWeatherService;
import javax.baja.xml.XElem;

public class EpaCurrentReader {
    BNwsWeatherProvider provider;
    private static final Logger log = Logger.getLogger("weather");
    private static final int MAX_REDIRECTS = 5;

    public EpaCurrentReader(BNwsWeatherProvider provider) {
        this.provider = provider;
    }

    public XElem getFeed(NwsStationList.Station station) throws Exception {
        BWeatherService ws = (BWeatherService)Sys.getService((Type)BWeatherService.TYPE);
        String apiKey = ws.getAirQualityApiKey();
        if (apiKey.isEmpty()) {
            throw new Exception("Air Quality API key has not been set. Please set the key or disable air quality checks.");
        }
        String airQualityCurrentPath = this.provider.getValidAirQualityCurrentPath();
        String airQualityApiKeyField = this.provider.getValidAirQualityApiKeyFieldValue();
        String uri = airQualityCurrentPath + station.zipCode + airQualityApiKeyField + apiKey;
        String host = this.provider.getAirQualityHost();
        return this.getFeed(station, host, uri);
    }

    XElem getFeed(NwsStationList.Station station, String host, String uri) throws Exception {
        try {
            return FeedReader.getXmlFeed(host, uri, 5, false);
        }
        catch (IOException exception) {
            throw new BajaException("Unable to get EPA Current Conditions feed", (Throwable)exception);
        }
    }

    public void getCurrent(BNwsWeatherProvider provider, BCurrentConditions cw, NwsStationList.Station station) throws Exception {
        if (station.zipCode == null) {
            return;
        }
        if (!provider.getAirQualityEnabled()) {
            cw.getOzone().setValue(Double.NaN);
            cw.getOzone().setStatus(BStatus.nullStatus);
            cw.getParticulateMatter().setValue(Double.NaN);
            cw.getParticulateMatter().setStatus(BStatus.nullStatus);
            return;
        }
        XElem[] observations = new XElem[]{};
        boolean errorMessage = false;
        try {
            XElem root = this.getFeed(station);
            observations = root.elems("ObsByZip");
            if (observations.length == 0) {
                if (root.name().equals("WebServiceError")) {
                    if (root.elem("Message").text().string().contains("Web service request limit exceeded")) {
                        log.warning("Exceeded Air quality request limit. Change the poll frequency, or request a new API key from http://airnowapi.org/");
                    } else {
                        log.warning("Air quality web service error.");
                    }
                } else if (root.name().equals("ObsByZipList")) {
                    log.warning("No air quality reporting stations nearby.");
                } else {
                    log.warning("Air quality unknown error.");
                }
                errorMessage = true;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unable to retrieve EPA current air quality.", e);
            errorMessage = true;
        }
        if (errorMessage) {
            cw.getOzone().setStatus(BStatus.makeStale((BStatus)cw.getOzone().getStatus(), (boolean)true));
            cw.getParticulateMatter().setStatus(BStatus.makeStale((BStatus)cw.getParticulateMatter().getStatus(), (boolean)true));
            return;
        }
        try {
            boolean ozoneFound = false;
            boolean pmFound = false;
            for (XElem observation : observations) {
                try {
                    if (observation.elem("ParameterName").text().string().equalsIgnoreCase("O3")) {
                        try {
                            int ozoneAqi = Integer.parseInt(observation.elem("AQI").text().string());
                            double ozoneConcentration = AirQualityIndexUtil.aqiToOzoneConcentration(ozoneAqi);
                            cw.getOzone().setValue(ozoneConcentration);
                            cw.getOzone().setStatus(BStatus.ok);
                            ozoneFound = true;
                        }
                        catch (NumberFormatException ozoneAqi) {
                            // empty catch block
                        }
                    }
                    if (!observation.elem("ParameterName").text().string().equalsIgnoreCase("pm2.5")) continue;
                    try {
                        int pmAqi = Integer.parseInt(observation.elem("AQI").text().string());
                        double pmConcentration = AirQualityIndexUtil.aqiToParticulateConcentration(pmAqi);
                        cw.getParticulateMatter().setValue(pmConcentration);
                        cw.getParticulateMatter().setStatus(BStatus.ok);
                        pmFound = true;
                    }
                    catch (NumberFormatException pmAqi) {}
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Difficulty parsing current air quality data.", e);
                }
            }
            if (!ozoneFound) {
                cw.getOzone().setValue(Double.NaN);
                cw.getOzone().setStatus(BStatus.nullStatus);
            }
            if (!pmFound) {
                cw.getParticulateMatter().setValue(Double.NaN);
                cw.getParticulateMatter().setStatus(BStatus.nullStatus);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Unable to get current air quality data.", e);
            cw.getOzone().setValue(Double.NaN);
            cw.getOzone().setStatus(BStatus.fault);
            cw.getParticulateMatter().setValue(Double.NaN);
            cw.getParticulateMatter().setStatus(BStatus.fault);
        }
    }
}

