/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.nws.advisory;

import com.tridium.weather.nws.BNwsWeatherProvider;
import com.tridium.weather.nws.FeedReader;
import com.tridium.weather.nws.NwsStationList;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.weather.BCurrentConditions;
import javax.baja.weather.BWeatherReport;
import javax.baja.weather.BWeatherService;
import javax.baja.weather.BWeatherState;
import javax.baja.weather.advisory.BAdvisory;
import javax.baja.weather.advisory.BAdvisoryCertainty;
import javax.baja.weather.advisory.BAdvisoryContainer;
import javax.baja.weather.advisory.BAdvisorySeverity;
import javax.baja.weather.advisory.BAdvisoryUrgency;
import javax.baja.xml.XElem;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="advisoryZone", type="String", defaultValue="BString.DEFAULT.toString()", flags=4)})
public class BNwsAdvisoryAlarmExt
extends BComponent {
    @Generated
    public static final Property enabled = BNwsAdvisoryAlarmExt.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property advisoryZone = BNwsAdvisoryAlarmExt.newProperty((int)4, (String)BString.DEFAULT.toString(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNwsAdvisoryAlarmExt.class);
    static final int MAX_REDIRECTS = 5;

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public String getAdvisoryZone() {
        return this.getString(advisoryZone);
    }

    @Generated
    public void setAdvisoryZone(String v) {
        this.setString(advisoryZone, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    XElem getFeed(NwsStationList.Station station) throws Exception {
        BNwsWeatherProvider provider = (BNwsWeatherProvider)this.getParent();
        String uri = provider.getValidAdvisoriesPath() + station.zone;
        return this.getFeed(station, provider.getAdvisoriesServer(), uri);
    }

    XElem getFeed(NwsStationList.Station station, String host, String uri) throws Exception {
        return this.getFeed(station, host, uri, true);
    }

    XElem getFeed(NwsStationList.Station station, String host, String uri, boolean secure) throws Exception {
        try {
            return FeedReader.getXmlFeed(host, uri, 5, secure);
        }
        catch (IOException exception) {
            throw new BajaException("Unable to get NWS Advisory Feed", (Throwable)exception);
        }
    }

    public void getAdvisories(BNwsWeatherProvider provider, BCurrentConditions cw, NwsStationList.Station station) throws Exception {
        XElem root;
        if (!this.getEnabled()) {
            return;
        }
        if (station.zone == null || station.zone.isEmpty()) {
            this.setAdvisoryZone(BString.DEFAULT.toString());
            return;
        }
        try {
            BAdvisory[] advisories;
            root = this.getFeed(station);
            for (BAdvisory advisory : advisories = (BAdvisory[])((BWeatherReport)this.getParent().getParent()).getCurrent().getAdvisories().getChildren(BAdvisory.class)) {
                advisory.setStatus(BStatus.makeStale((BStatus)advisory.getStatus(), (boolean)false));
            }
        }
        catch (Exception e) {
            BAdvisory[] advisories;
            BWeatherService.log.log(Level.WARNING, "Unable to load advisories for zone " + station.zone, e);
            for (BAdvisory advisory : advisories = (BAdvisory[])((BWeatherReport)this.getParent().getParent()).getCurrent().getAdvisories().getChildren(BAdvisory.class)) {
                advisory.setStatus(BStatus.makeStale((BStatus)advisory.getStatus(), (boolean)true));
            }
            return;
        }
        XElem[] advisoriesXml = root.elems("entry");
        BAbsTime updateTime = BAbsTime.now();
        for (XElem advisoryXml : advisoriesXml) {
            try {
                if (advisoryXml.elem("urgency") == null) continue;
                BAdvisory advisory = new BAdvisory();
                advisory.getUrgency().setValue((BEnum)BAdvisoryUrgency.make(advisoryXml.elem("urgency").string().toLowerCase()));
                advisory.setLastUpdate(updateTime);
                URL url = new URL(advisoryXml.elem("link").get("href"));
                String urlQuery = url.getQuery();
                urlQuery = urlQuery == null || urlQuery.isEmpty() ? "" : '?' + urlQuery;
                XElem alarmRoot = this.getFeed(station, url.getHost(), url.getPath() + urlQuery);
                try {
                    XElem alarmInfo = alarmRoot.elem("info");
                    if (alarmInfo != null) {
                        if (!alarmRoot.elem("status").string().equals("Actual") || !alarmRoot.elem("scope").string().equals("Public")) continue;
                        advisory.setId((BValue)BString.make((String)alarmRoot.elem("identifier").string()));
                        advisory.getWeatherSummary().setValue(alarmInfo.elem("event").string());
                        BWeatherState state = BWeatherState.make(alarmInfo.elem("event").string());
                        if (state.equals((Object)BWeatherState.unknown) && alarmInfo.elem("description") != null && alarmInfo.elem("description").string() != null) {
                            advisory.getState().setValue((BEnum)BWeatherState.make(alarmInfo.elem("description").string()));
                        }
                        advisory.getState().setValue((BEnum)state);
                        advisory.setExpires(BAbsTime.make((String)alarmInfo.elem("expires").string()));
                        advisory.setEffective(BAbsTime.make((String)alarmInfo.elem("effective").string()));
                        if (alarmInfo.elem("description") != null && alarmInfo.elem("description").string() != null) {
                            advisory.getDescription().setValue(alarmInfo.elem("description").string());
                        }
                        if (alarmInfo.elem("instruction") != null && alarmInfo.elem("instruction").string() != null) {
                            advisory.getInstructions().setValue(alarmInfo.elem("instruction").string());
                        }
                        if (alarmInfo.elem("severity") != null) {
                            advisory.getSeverity().setValue((BEnum)BAdvisorySeverity.make(alarmInfo.elem("severity").string().toLowerCase()));
                        }
                        if (alarmInfo.elem("certainty") != null) {
                            advisory.getCertainty().setValue((BEnum)BAdvisoryCertainty.make(alarmInfo.elem("certainty").string().toLowerCase()));
                        }
                    }
                    ((BWeatherReport)this.getParent().getParent()).getCurrent().getAdvisories().advisory(advisory);
                }
                catch (Exception e) {
                    throw new BajaException("Unable to process weather advisory details.", (Throwable)e);
                }
            }
            catch (Exception e) {
                throw new BajaException("Unable to process weather advisory.", (Throwable)e);
            }
        }
        BAdvisoryContainer advisoryContainer = ((BWeatherReport)this.getParent().getParent()).getCurrent().getAdvisories();
        SlotCursor cursor = advisoryContainer.getProperties();
        LinkedList<BAdvisory> removeAdvisories = new LinkedList<BAdvisory>();
        while (cursor.next(BAdvisory.class)) {
            BAdvisory advisory = (BAdvisory)cursor.get();
            if (!advisory.getLastUpdate().isBefore(updateTime)) continue;
            removeAdvisories.add(advisory);
        }
        for (BAdvisory removeAdvisory : removeAdvisories) {
            advisoryContainer.remove((BComplex)removeAdvisory);
        }
    }

    static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setFlags((Slot)BAlarmSourceInfo.toFaultText, 4);
        asi.setFlags((Slot)BAlarmSourceInfo.toOffnormalText, 4);
        asi.setSourceName(BFormat.make((String)"%parent.parent.parent.displayName%"));
        return asi;
    }
}

