/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.weather;

import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.weather.BSunPosition;
import javax.baja.weather.BWeatherState;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=11), @NiagaraProperty(name="lastUpdate", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=3), @NiagaraProperty(name="date", type="BAbsTime", defaultValue="BAbsTime.now()", flags=3, facets={@Facet(value="BFacets.make(\"showDate\", BBoolean.TRUE, \"showTime\", BBoolean.FALSE)")}), @NiagaraProperty(name="sunrise", type="BTime", defaultValue="BTime.DEFAULT", flags=3), @NiagaraProperty(name="sunset", type="BTime", defaultValue="BTime.DEFAULT", flags=3), @NiagaraProperty(name="high", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"fahrenheit\"), BFacets.PRECISION, BInteger.make(1))")}), @NiagaraProperty(name="low", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"fahrenheit\"), BFacets.PRECISION, BInteger.make(1))")}), @NiagaraProperty(name="precipChance", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"percent\"), BFacets.PRECISION, BInteger.make(0))")}), @NiagaraProperty(name="weatherSummary", type="BStatusString", defaultValue="new BStatusString(\"\", BStatus.nullStatus)", flags=3), @NiagaraProperty(name="state", type="BStatusEnum", defaultValue="new BStatusEnum(BWeatherState.clear)", flags=3), @NiagaraProperty(name="ozone", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"parts per million\"), BFacets.PRECISION, BInteger.make(3))")}), @NiagaraProperty(name="particulateMatter", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"micrograms per cubic meter\"), BFacets.PRECISION, BDouble.make(1))")}), @NiagaraProperty(name="humidity", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"percent relative humidity\"), BFacets.PRECISION, BInteger.make(1))")}), @NiagaraProperty(name="windSpeed", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"miles per hour\"))")})})
public class BForecast
extends BComponent
implements BIComparable {
    @Generated
    public static final Property status = BForecast.newProperty((int)11, (BValue)BStatus.ok, null);
    @Generated
    public static final Property lastUpdate = BForecast.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property date = BForecast.newProperty((int)3, (BValue)BAbsTime.now(), (BFacets)BFacets.make((String)"showDate", (BIDataValue)BBoolean.TRUE, (String)"showTime", (BIDataValue)BBoolean.FALSE));
    @Generated
    public static final Property sunrise = BForecast.newProperty((int)3, (BValue)BTime.DEFAULT, null);
    @Generated
    public static final Property sunset = BForecast.newProperty((int)3, (BValue)BTime.DEFAULT, null);
    @Generated
    public static final Property high = BForecast.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"fahrenheit"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    @Generated
    public static final Property low = BForecast.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"fahrenheit"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    @Generated
    public static final Property precipChance = BForecast.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent"), (String)"precision", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Property weatherSummary = BForecast.newProperty((int)3, (BValue)new BStatusString("", BStatus.nullStatus), null);
    @Generated
    public static final Property state = BForecast.newProperty((int)3, (BValue)new BStatusEnum((BEnum)BWeatherState.clear), null);
    @Generated
    public static final Property ozone = BForecast.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"parts per million"), (String)"precision", (BIDataValue)BInteger.make((int)3)));
    @Generated
    public static final Property particulateMatter = BForecast.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"micrograms per cubic meter"), (String)"precision", (BIDataValue)BDouble.make((double)1.0)));
    @Generated
    public static final Property humidity = BForecast.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent relative humidity"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    @Generated
    public static final Property windSpeed = BForecast.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"miles per hour")));
    @Generated
    public static final Type TYPE = Sys.loadType(BForecast.class);
    private static final BIcon icon = BIcon.make((String)"module://weather/icons/weather.png");

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    @Generated
    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    @Generated
    public BAbsTime getDate() {
        return (BAbsTime)this.get(date);
    }

    @Generated
    public void setDate(BAbsTime v) {
        this.set(date, (BValue)v, null);
    }

    @Generated
    public BTime getSunrise() {
        return (BTime)this.get(sunrise);
    }

    @Generated
    public void setSunrise(BTime v) {
        this.set(sunrise, (BValue)v, null);
    }

    @Generated
    public BTime getSunset() {
        return (BTime)this.get(sunset);
    }

    @Generated
    public void setSunset(BTime v) {
        this.set(sunset, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getHigh() {
        return (BStatusNumeric)this.get(high);
    }

    @Generated
    public void setHigh(BStatusNumeric v) {
        this.set(high, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getLow() {
        return (BStatusNumeric)this.get(low);
    }

    @Generated
    public void setLow(BStatusNumeric v) {
        this.set(low, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getPrecipChance() {
        return (BStatusNumeric)this.get(precipChance);
    }

    @Generated
    public void setPrecipChance(BStatusNumeric v) {
        this.set(precipChance, (BValue)v, null);
    }

    @Generated
    public BStatusString getWeatherSummary() {
        return (BStatusString)this.get(weatherSummary);
    }

    @Generated
    public void setWeatherSummary(BStatusString v) {
        this.set(weatherSummary, (BValue)v, null);
    }

    @Generated
    public BStatusEnum getState() {
        return (BStatusEnum)this.get(state);
    }

    @Generated
    public void setState(BStatusEnum v) {
        this.set(state, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getOzone() {
        return (BStatusNumeric)this.get(ozone);
    }

    @Generated
    public void setOzone(BStatusNumeric v) {
        this.set(ozone, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getParticulateMatter() {
        return (BStatusNumeric)this.get(particulateMatter);
    }

    @Generated
    public void setParticulateMatter(BStatusNumeric v) {
        this.set(particulateMatter, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getHumidity() {
        return (BStatusNumeric)this.get(humidity);
    }

    @Generated
    public void setHumidity(BStatusNumeric v) {
        this.set(humidity, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getWindSpeed() {
        return (BStatusNumeric)this.get(windSpeed);
    }

    @Generated
    public void setWindSpeed(BStatusNumeric v) {
        this.set(windSpeed, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final void setSun(BAbsTime date, double lat, double lon) {
        BSunPosition sun = BSunPosition.make(lat, lon, date);
        this.setSunrise(BTime.make((BAbsTime)sun.getSunrise()));
        this.setSunset(BTime.make((BAbsTime)sun.getSunset()));
    }

    public void changed(Property property, Context context) {
        if (property.equals(status)) {
            BStatusValue[] values;
            for (BStatusValue value : values = (BStatusValue[])this.getChildren(BStatusValue.class)) {
                value.setStatus(this.getStatus());
            }
        }
        super.changed(property, context);
    }

    public String toString(Context context) {
        BFacets mergedFacets = this.getSlotFacets((Slot)high);
        if (context != null) {
            mergedFacets = BFacets.make((BFacets)context.getFacets(), (BFacets)this.getSlotFacets((Slot)high));
        }
        String max = this.getHigh().getValueValue().toString((Context)mergedFacets);
        mergedFacets = this.getSlotFacets((Slot)low);
        if (context != null) {
            mergedFacets = BFacets.make((BFacets)context.getFacets(), (BFacets)this.getSlotFacets((Slot)low));
        }
        String min = this.getLow().getValueValue().toString((Context)mergedFacets);
        mergedFacets = this.getSlotFacets((Slot)precipChance);
        if (context != null) {
            mergedFacets = BFacets.make((BFacets)context.getFacets(), (BFacets)this.getSlotFacets((Slot)precipChance));
        }
        String pop = this.getPrecipChance().getValueValue().toString((Context)mergedFacets);
        String sum = this.getState().getValueValue().toString();
        if (this.getHigh().getStatus().isNull()) {
            max = "-";
        }
        if (this.getLow().getStatus().isNull()) {
            min = "-";
        }
        if (this.getPrecipChance().getStatus().isNull()) {
            pop = "-";
        }
        if (this.getState().getStatus().isNull()) {
            sum = "-";
        }
        return max + '/' + min + ", " + sum + ", " + pop + ' ' + this.getStatus().toString(context);
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof BForecast)) {
            return 0;
        }
        BForecast forecast = (BForecast)((Object)obj);
        return Double.compare(forecast.getHigh().getValue(), this.getHigh().getValue());
    }

    public BIcon getIcon() {
        return icon;
    }
}

