/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.weather;

import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.weather.BMoonPhase;
import javax.baja.weather.BWeatherService;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="updatePeriod", type="BRelTime", defaultValue="BRelTime.makeMinutes(1)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeSeconds(0))")}), @NiagaraProperty(name="phase", type="BMoonPhase", defaultValue="BMoonPhase.newMoon", flags=11), @NiagaraProperty(name="age", type="BRelTime", defaultValue="BRelTime.DEFAULT", flags=11, facets={@Facet(value="BFacets.make(BFacets.SHOW_SECONDS, BBoolean.FALSE, BRELTIME_SHOW_DAY, BBoolean.TRUE)")}), @NiagaraProperty(name="illumination", type="int", defaultValue="0", flags=11, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"percent\"))")})})
@NiagaraAction(name="recalculate")
public class BMoonPosition
extends BComponent {
    private static final String BRELTIME_SHOW_DAY = "showDay";
    @Generated
    public static final Property enabled = BMoonPosition.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property updatePeriod = BMoonPosition.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0)));
    @Generated
    public static final Property phase = BMoonPosition.newProperty((int)11, (BValue)BMoonPhase.newMoon, null);
    @Generated
    public static final Property age = BMoonPosition.newProperty((int)11, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"showSeconds", (BIDataValue)BBoolean.FALSE, (String)"showDay", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Property illumination = BMoonPosition.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    @Generated
    public static final Action recalculate = BMoonPosition.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMoonPosition.class);
    private static final BIcon icon = BIcon.make((String)"module://weather/icons/moon.png");
    private static final double MOON_CYCLE = 29.530588853;
    private static final BAbsTime NEW_MOON_UTC_REFERENCE = BAbsTime.make((int)2020, (BMonth)BMonth.january, (int)24, (int)21, (int)42, (int)0, (int)0, (BTimeZone)BTimeZone.UTC);
    private static final double NEW_MOON_JULIAN_REFERENCE = BMoonPosition.getJulianDay(NEW_MOON_UTC_REFERENCE);
    private Clock.Ticket updateTicket;

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BRelTime getUpdatePeriod() {
        return (BRelTime)this.get(updatePeriod);
    }

    @Generated
    public void setUpdatePeriod(BRelTime v) {
        this.set(updatePeriod, (BValue)v, null);
    }

    @Generated
    public BMoonPhase getPhase() {
        return (BMoonPhase)this.get(phase);
    }

    @Generated
    public void setPhase(BMoonPhase v) {
        this.set(phase, (BValue)v, null);
    }

    @Generated
    public BRelTime getAge() {
        return (BRelTime)this.get(age);
    }

    @Generated
    public void setAge(BRelTime v) {
        this.set(age, (BValue)v, null);
    }

    @Generated
    public int getIllumination() {
        return this.getInt(illumination);
    }

    @Generated
    public void setIllumination(int v) {
        this.setInt(illumination, v, null);
    }

    @Generated
    public void recalculate() {
        this.invoke(recalculate, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() {
        if (Sys.isStationStarted() && this.getEnabled()) {
            this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)recalculate, null);
            this.invoke(recalculate, null);
        }
    }

    public void stopped() {
        if (this.updateTicket != null) {
            this.updateTicket.cancel();
            this.updateTicket = null;
        }
    }

    public void stationStarted() {
        if (this.getEnabled()) {
            this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)recalculate, null);
            this.invoke(recalculate, null);
        }
    }

    public static BMoonPosition make(BAbsTime time) {
        BMoonPosition position = new BMoonPosition();
        position.doRecalculate(time);
        return position;
    }

    public BIcon getIcon() {
        return icon;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(enabled) || property.equals(updatePeriod)) {
            if (this.updateTicket != null) {
                this.updateTicket.cancel();
                this.updateTicket = null;
            }
            if (this.getEnabled() && this.isRunning()) {
                this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)recalculate, null);
            }
        }
    }

    public void doRecalculate() {
        this.doRecalculate(BAbsTime.now());
    }

    private void doRecalculate(BAbsTime time) {
        BWeatherService.log.log(Level.FINE, "Calculating moon position");
        if (!this.getEnabled()) {
            return;
        }
        double julianDay = BMoonPosition.getJulianDay(time);
        double cycles = (julianDay - NEW_MOON_JULIAN_REFERENCE) / 29.530588853;
        double moonAge = (cycles - Math.floor(cycles)) * 29.530588853;
        if (moonAge < 0.0) {
            moonAge += 29.530588853;
        }
        this.setPhase(BMoonPhase.make((int)(Math.ceil((moonAge - 1.8456618033125) / 3.691323606625) % 8.0)));
        this.setAge(BRelTime.makeMinutes((int)((int)(moonAge * 24.0 * 60.0))));
        this.setIllumination((int)((0.5 + 0.5 * Math.sin(-1.94 + moonAge * 0.22)) * 100.0));
    }

    private static double getJulianDay(BAbsTime time) {
        time = time.toUtcTime();
        int year = time.getYear();
        int month = time.getMonth().getOrdinal() + 1;
        int day = time.getDay();
        double hour = (double)time.getHour() + (double)time.getMinute() / 60.0;
        return (double)((long)(-7 * (year + (month + 9) / 12) / 4 + 275 * month / 9 + day) + (long)year * 367L) - 730530.0 + hour / 24.0;
    }
}

