/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.weather;

import java.util.logging.Level;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.weather.BWeatherService;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="updatePeriod", type="BRelTime", defaultValue="BRelTime.makeMinutes(1)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeSeconds(0))")}), @NiagaraProperty(name="longitude", type="double", defaultValue="-77.4605636597", flags=8, facets={@Facet(value="BFacets.make(new String[] { BFacets.UNITS, BFacets.PRECISION, BFacets.MAX, BFacets.MIN }, new BIDataValue[] { BUnit.getUnit(\"degrees angular\"), BInteger.make(5), BDouble.make(180), BDouble.make(-180) })")}), @NiagaraProperty(name="latitude", type="double", defaultValue="37.5536117554", flags=8, facets={@Facet(value="BFacets.make(new String[] { BFacets.UNITS, BFacets.PRECISION, BFacets.MAX, BFacets.MIN }, new BIDataValue[] { BUnit.getUnit(\"degrees angular\"), BInteger.make(5), BDouble.make(180), BDouble.make(-180) })")}), @NiagaraProperty(name="dayLength", type="double", defaultValue="0", flags=11, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"hour\"))")}), @NiagaraProperty(name="sunrise", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=11), @NiagaraProperty(name="sunset", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=11), @NiagaraProperty(name="noon", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=11), @NiagaraProperty(name="midnight", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=11), @NiagaraProperty(name="maxElevation", type="double", defaultValue="0", flags=11, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"degrees angular\"), BFacets.PRECISION, BInteger.make(3))")}), @NiagaraProperty(name="minElevation", type="double", defaultValue="0", flags=11, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"degrees angular\"), BFacets.PRECISION, BInteger.make(3))")}), @NiagaraProperty(name="currentElevation", type="double", defaultValue="0", flags=11, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"degrees angular\"), BFacets.PRECISION, BInteger.make(3))")}), @NiagaraProperty(name="currentAzimuth", type="double", defaultValue="0", flags=11, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"degrees angular\"), BFacets.PRECISION, BInteger.make(3))")}), @NiagaraProperty(name="currentDeclination", type="double", defaultValue="0", flags=11, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"degrees angular\"), BFacets.PRECISION, BInteger.make(3))")}), @NiagaraProperty(name="currentRightAscension", type="double", defaultValue="0", flags=11, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"degrees angular\"), BFacets.PRECISION, BInteger.make(3))")})})
@NiagaraAction(name="recalculate")
public class BSunPosition
extends BComponent {
    @Generated
    public static final Property enabled = BSunPosition.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property updatePeriod = BSunPosition.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)1), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0)));
    @Generated
    public static final Property longitude = BSunPosition.newProperty((int)8, (double)-77.4605636597, (BFacets)BFacets.make((String[])new String[]{"units", "precision", "max", "min"}, (BIDataValue[])new BIDataValue[]{BUnit.getUnit((String)"degrees angular"), BInteger.make((int)5), BDouble.make((double)180.0), BDouble.make((double)-180.0)}));
    @Generated
    public static final Property latitude = BSunPosition.newProperty((int)8, (double)37.5536117554, (BFacets)BFacets.make((String[])new String[]{"units", "precision", "max", "min"}, (BIDataValue[])new BIDataValue[]{BUnit.getUnit((String)"degrees angular"), BInteger.make((int)5), BDouble.make((double)180.0), BDouble.make((double)-180.0)}));
    @Generated
    public static final Property dayLength = BSunPosition.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"hour")));
    @Generated
    public static final Property sunrise = BSunPosition.newProperty((int)11, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property sunset = BSunPosition.newProperty((int)11, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property noon = BSunPosition.newProperty((int)11, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property midnight = BSunPosition.newProperty((int)11, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property maxElevation = BSunPosition.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"degrees angular"), (String)"precision", (BIDataValue)BInteger.make((int)3)));
    @Generated
    public static final Property minElevation = BSunPosition.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"degrees angular"), (String)"precision", (BIDataValue)BInteger.make((int)3)));
    @Generated
    public static final Property currentElevation = BSunPosition.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"degrees angular"), (String)"precision", (BIDataValue)BInteger.make((int)3)));
    @Generated
    public static final Property currentAzimuth = BSunPosition.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"degrees angular"), (String)"precision", (BIDataValue)BInteger.make((int)3)));
    @Generated
    public static final Property currentDeclination = BSunPosition.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"degrees angular"), (String)"precision", (BIDataValue)BInteger.make((int)3)));
    @Generated
    public static final Property currentRightAscension = BSunPosition.newProperty((int)11, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"degrees angular"), (String)"precision", (BIDataValue)BInteger.make((int)3)));
    @Generated
    public static final Action recalculate = BSunPosition.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSunPosition.class);
    private static final BIcon icon = BIcon.make((String)"module://weather/icons/weather.png");
    private static final double toDegrees = 57.29577951308232;
    private static final double toRadians = Math.PI / 180;
    private static final double radiansPerHour = 0.2617993877991494;
    private Clock.Ticket updateTicket;

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BRelTime getUpdatePeriod() {
        return (BRelTime)this.get(updatePeriod);
    }

    @Generated
    public void setUpdatePeriod(BRelTime v) {
        this.set(updatePeriod, (BValue)v, null);
    }

    @Generated
    public double getLongitude() {
        return this.getDouble(longitude);
    }

    @Generated
    public void setLongitude(double v) {
        this.setDouble(longitude, v, null);
    }

    @Generated
    public double getLatitude() {
        return this.getDouble(latitude);
    }

    @Generated
    public void setLatitude(double v) {
        this.setDouble(latitude, v, null);
    }

    @Generated
    public double getDayLength() {
        return this.getDouble(dayLength);
    }

    @Generated
    public void setDayLength(double v) {
        this.setDouble(dayLength, v, null);
    }

    @Generated
    public BAbsTime getSunrise() {
        return (BAbsTime)this.get(sunrise);
    }

    @Generated
    public void setSunrise(BAbsTime v) {
        this.set(sunrise, (BValue)v, null);
    }

    @Generated
    public BAbsTime getSunset() {
        return (BAbsTime)this.get(sunset);
    }

    @Generated
    public void setSunset(BAbsTime v) {
        this.set(sunset, (BValue)v, null);
    }

    @Generated
    public BAbsTime getNoon() {
        return (BAbsTime)this.get(noon);
    }

    @Generated
    public void setNoon(BAbsTime v) {
        this.set(noon, (BValue)v, null);
    }

    @Generated
    public BAbsTime getMidnight() {
        return (BAbsTime)this.get(midnight);
    }

    @Generated
    public void setMidnight(BAbsTime v) {
        this.set(midnight, (BValue)v, null);
    }

    @Generated
    public double getMaxElevation() {
        return this.getDouble(maxElevation);
    }

    @Generated
    public void setMaxElevation(double v) {
        this.setDouble(maxElevation, v, null);
    }

    @Generated
    public double getMinElevation() {
        return this.getDouble(minElevation);
    }

    @Generated
    public void setMinElevation(double v) {
        this.setDouble(minElevation, v, null);
    }

    @Generated
    public double getCurrentElevation() {
        return this.getDouble(currentElevation);
    }

    @Generated
    public void setCurrentElevation(double v) {
        this.setDouble(currentElevation, v, null);
    }

    @Generated
    public double getCurrentAzimuth() {
        return this.getDouble(currentAzimuth);
    }

    @Generated
    public void setCurrentAzimuth(double v) {
        this.setDouble(currentAzimuth, v, null);
    }

    @Generated
    public double getCurrentDeclination() {
        return this.getDouble(currentDeclination);
    }

    @Generated
    public void setCurrentDeclination(double v) {
        this.setDouble(currentDeclination, v, null);
    }

    @Generated
    public double getCurrentRightAscension() {
        return this.getDouble(currentRightAscension);
    }

    @Generated
    public void setCurrentRightAscension(double v) {
        this.setDouble(currentRightAscension, v, null);
    }

    @Generated
    public void recalculate() {
        this.invoke(recalculate, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static void main(String[] args) {
    }

    public static BSunPosition make(double latitude, double longitude) {
        return BSunPosition.make(latitude, longitude, BAbsTime.now());
    }

    public static BSunPosition make(double latitude, double longitude, BAbsTime date) {
        BSunPosition sun = new BSunPosition();
        sun.setLongitude(longitude);
        sun.setLatitude(latitude);
        sun.doRecalculate(date);
        return sun;
    }

    public void started() {
        if (Sys.isStationStarted() && this.getEnabled()) {
            this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)recalculate, null);
            this.invoke(recalculate, null);
        }
    }

    public void stopped() throws Exception {
        if (this.updateTicket != null) {
            this.updateTicket.cancel();
            this.updateTicket = null;
        }
    }

    public void stationStarted() {
        if (this.getEnabled()) {
            if (this.updateTicket != null) {
                this.updateTicket.cancel();
            }
            this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)recalculate, null);
            this.invoke(recalculate, null);
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(latitude) || property.equals(longitude)) {
            this.recalculate();
        }
        if (property.equals(enabled) || property.equals(updatePeriod)) {
            if (this.updateTicket != null) {
                this.updateTicket.cancel();
                this.updateTicket = null;
            }
            if (this.getEnabled() && this.isRunning()) {
                this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)recalculate, null);
            }
        }
    }

    private double normalizeRadians(double radians) {
        double twoPi = Math.PI * 2;
        while (radians > twoPi) {
            radians -= twoPi;
        }
        while (radians < 0.0) {
            radians += twoPi;
        }
        return radians;
    }

    private BAbsTime convertTime(int year, int month, int day, double decimalHours) {
        int hours = Math.abs((int)decimalHours % 24);
        int minutes = Math.abs((int)((decimalHours - (double)hours) * 60.0) % 60);
        BAbsTime tempLocalEarly = BAbsTime.make((int)year, (BMonth)BMonth.make((int)(month - 1)), (int)day, (int)0, (int)0);
        BAbsTime tempLocalLate = BAbsTime.make((int)year, (BMonth)BMonth.make((int)(month - 1)), (int)day, (int)2, (int)0);
        boolean isDSTDay = tempLocalEarly.inDaylightTime() ^ tempLocalLate.inDaylightTime();
        int offset = tempLocalEarly.getTimeZoneOffset() / 1000 / 3600;
        int tempDay = day;
        int tempLocal = hours + offset;
        if (isDSTDay && tempLocal >= 2) {
            offset = tempLocalLate.getTimeZoneOffset() / 1000 / 3600;
        }
        if (hours + offset < 0) {
            tempDay = day + 1;
        } else if (hours + offset >= 24) {
            tempDay = day - 1;
        }
        BAbsTime utcRef = BAbsTime.make((int)year, (BMonth)BMonth.make((int)(month - 1)), (int)tempDay, (int)hours, (int)minutes, (int)0, (int)0, (BTimeZone)BTimeZone.UTC);
        return BAbsTime.make((BAbsTime)utcRef, (BTimeZone)BTimeZone.getLocal());
    }

    public void doRecalculate() {
        this.doRecalculate(BAbsTime.now());
    }

    public void doRecalculate(BAbsTime time) {
        if (!this.getEnabled()) {
            return;
        }
        BAbsTime targetTime = BAbsTime.make((BAbsTime)time, (BTimeZone)BTimeZone.getLocal());
        int targetYear = targetTime.getYear();
        int targetMonth = targetTime.getMonth().getOrdinal() + 1;
        int targetDay = targetTime.getDay();
        BAbsTime utcTime = time.toUtcTime();
        int year = utcTime.getYear();
        int month = utcTime.getMonth().getOrdinal() + 1;
        int day = utcTime.getDay();
        double hour = (double)utcTime.getHour() + (double)utcTime.getMinute() / 60.0 + (double)utcTime.getSecond() / 3600.0;
        double julianDay = Math.floor((double)((long)(-7 * (year + (month + 9) / 12) / 4 + 275 * month / 9 + day) + (long)year * 367L) - (730530.0 + hour / 24.0));
        if (BWeatherService.log.isLoggable(Level.FINE)) {
            BWeatherService.log.log(Level.FINE, "Calculating sun position at " + day + "/" + month + "/" + year);
        }
        double latitude = this.getLatitude() * (Math.PI / 180);
        double longitude = this.getLongitude() * (Math.PI / 180);
        double meanAnomaly = this.normalizeRadians((356.047 + 0.9856002585 * julianDay) * (Math.PI / 180));
        double meanLongitude = this.normalizeRadians((282.9404 + 4.70935E-5 * julianDay) * (Math.PI / 180));
        double eccentricity = 0.016709 - 1.151E-9 * julianDay;
        double eccentricAnomaly = this.normalizeRadians(meanAnomaly + eccentricity * Math.sin(meanAnomaly) * (1.0 + eccentricity * Math.cos(meanAnomaly)));
        double x = Math.cos(eccentricAnomaly) - eccentricity;
        double y = Math.sin(eccentricAnomaly) * Math.sqrt(1.0 - eccentricity * eccentricity);
        double v = Math.atan2(y, x);
        double distance = Math.sqrt(x * x + y * y);
        double sunLongitude = this.normalizeRadians(v + meanLongitude);
        double axilTilt = 0.4090929593627069 - 6.218608124855796E-9 * julianDay;
        double x2 = distance * Math.cos(sunLongitude);
        double y2 = distance * Math.sin(sunLongitude) * Math.cos(axilTilt);
        double z = y2 * Math.sin(axilTilt);
        double rightAscension = Math.atan2(y2, x2);
        double declination = Math.atan2(z, Math.sqrt(x2 * x2 + y2 * y2));
        double greenwichSiderealTime = this.normalizeRadians(meanLongitude + meanAnomaly) / 0.2617993877991494 + 12.0;
        double localSiderealTime = greenwichSiderealTime + hour + longitude / 0.2617993877991494;
        double hourAngleRadians = this.normalizeRadians(0.2617993877991494 * localSiderealTime - rightAscension);
        double x3 = Math.cos(hourAngleRadians) * Math.cos(declination);
        double y3 = Math.sin(hourAngleRadians) * Math.cos(declination);
        double z2 = Math.sin(declination);
        double xhorizon = x3 * Math.sin(latitude) - z2 * Math.cos(latitude);
        double yhorizon = y3;
        double zhorizon = x3 * Math.cos(latitude) + z2 * Math.sin(latitude);
        double azimuth = this.normalizeRadians(Math.atan2(yhorizon, xhorizon) + Math.PI);
        double elevation = Math.asin(zhorizon);
        if (elevation > Math.PI) {
            elevation = Math.PI - elevation;
        }
        if (elevation < -Math.PI) {
            elevation = -(elevation + Math.PI);
        }
        double sunRadius = 0.004625;
        if (latitude < 0.0) {
            sunRadius = -sunRadius;
        }
        double localHourAngle = Math.asin(Math.tan(declination + sunRadius) * Math.tan(latitude)) + 1.5707963267948966;
        double equationOfTime = 24.0 - (this.normalizeRadians(meanLongitude + meanAnomaly) - rightAscension) * 3.819718634;
        double sunriseTime = 12.0 - 12.0 * localHourAngle / Math.PI - longitude / 0.2617993877991494 + equationOfTime;
        double sunsetTime = 12.0 + 12.0 * localHourAngle / Math.PI - longitude / 0.2617993877991494 + equationOfTime;
        double dayLength = localHourAngle / 0.1308996938995747;
        double noon = sunriseTime + 12.0 * localHourAngle / Math.PI;
        double midnight = noon + 12.0;
        if (noon > 24.0) {
            noon -= 24.0;
        }
        if (noon < 0.0) {
            noon += 24.0;
        }
        if (midnight > 24.0) {
            midnight -= 24.0;
        }
        if (midnight < 0.0) {
            midnight += 24.0;
        }
        if (sunriseTime > 24.0) {
            sunriseTime -= 24.0;
        }
        if (sunriseTime < 0.0) {
            sunriseTime += 24.0;
        }
        if (sunsetTime > 24.0) {
            sunsetTime -= 24.0;
        }
        if (sunsetTime < 0.0) {
            sunsetTime += 24.0;
        }
        double maximumElevation = 1.5707963267948966 + declination - latitude;
        double minimumElevation = maximumElevation + 2.0 * latitude - Math.PI;
        if (maximumElevation > 1.5707963267948966) {
            maximumElevation = Math.PI - maximumElevation;
        }
        if (minimumElevation < -1.5707963267948966) {
            minimumElevation = -(minimumElevation + Math.PI);
        }
        this.setCurrentDeclination(declination * 57.29577951308232);
        this.setDayLength(dayLength);
        this.setSunrise(this.convertTime(targetYear, targetMonth, targetDay, sunriseTime));
        this.setSunset(this.convertTime(targetYear, targetMonth, targetDay, sunsetTime));
        this.setMaxElevation(maximumElevation * 57.29577951308232);
        this.setMinElevation(minimumElevation * 57.29577951308232);
        this.setNoon(this.convertTime(targetYear, targetMonth, targetDay, noon));
        this.setMidnight(this.convertTime(targetYear, targetMonth, targetDay, midnight));
        this.setCurrentAzimuth(azimuth * 57.29577951308232);
        this.setCurrentElevation(elevation * 57.29577951308232);
        this.setCurrentRightAscension(rightAscension * 57.29577951308232);
    }
}

