/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bql.filter;

import com.tridium.bql.filter.BBitStringFilter;
import com.tridium.workbench.bql.filter.BFilterFE;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBitString;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.pane.BGridPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;

@NiagaraType(agent={@AgentOn(types={"bql:BitStringFilter"})})
public class BBitStringFilterFE
extends BFilterFE {
    @Generated
    public static final Type TYPE = Sys.loadType(BBitStringFilterFE.class);
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private BBitString include;
    private BTextField includeField;
    private Command editInc;
    private Command clearInc;
    private Command allInc;
    private BBitString exclude;
    private BTextField excludeField;
    private Command editExc;
    private Command clearExc;
    private Command allExc;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBitStringFilterFE() {
        BGridPane main = new BGridPane(5);
        this.includeField = new BTextField("", 32);
        this.includeField.setEditable(false);
        main.add(null, (BValue)new BLabel(lex.getText("filter.include")));
        main.add(null, (BValue)this.includeField);
        this.editInc = new EditMask(true);
        main.add(null, (BValue)this.button(this.editInc));
        this.clearInc = new ClearMask(true);
        main.add(null, (BValue)this.button(this.clearInc));
        this.allInc = new SetAll(true);
        main.add(null, (BValue)this.button(this.allInc));
        this.excludeField = new BTextField("", 32);
        this.excludeField.setEditable(false);
        main.add(null, (BValue)new BLabel(lex.getText("filter.exclude")));
        main.add(null, (BValue)this.excludeField);
        this.editExc = new EditMask(false);
        main.add(null, (BValue)this.button(this.editExc));
        this.clearExc = new ClearMask(false);
        main.add(null, (BValue)this.button(this.clearExc));
        this.allExc = new SetAll(false);
        main.add(null, (BValue)this.button(this.allExc));
        this.setContent((BWidget)main);
    }

    private BButton button(Command cmd) {
        BButton b = new BButton(cmd, false, true);
        b.setButtonStyle(BButtonStyle.toolBar);
        return b;
    }

    @Override
    public void doSetReadonly(boolean ro) {
        this.editInc.setEnabled(!ro);
        this.clearInc.setEnabled(!ro);
        this.allInc.setEnabled(!ro);
        this.editExc.setEnabled(!ro);
        this.clearExc.setEnabled(!ro);
        this.allExc.setEnabled(!ro);
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BBitStringFilter f = (BBitStringFilter)value;
        this.include = f.getInclude();
        this.exclude = f.getExclude();
        this.includeField.setText(this.include.toString(cx));
        this.excludeField.setText(this.exclude.toString(cx));
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        BBitStringFilter f = (BBitStringFilter)value;
        f.setInclude(this.include);
        f.setExclude(this.exclude);
        return f;
    }

    private void editMask(boolean inc) {
        BBitString toEdit = inc ? this.include : this.exclude;
        BCheckList list = new BCheckList();
        int[] all = toEdit.getOrdinals();
        for (int i = 0; i < all.length; ++i) {
            OrdToTag item = new OrdToTag(all[i], toEdit.getDisplayTag(all[i], this.getCurrentContext()));
            list.addItem((Object)item);
            if (!toEdit.getBit(all[i])) continue;
            list.getSelection().select(i);
        }
        String titleKey = inc ? "filter.bitsToInclude" : "filter.bitsToExclude";
        int result = BDialog.open((BWidget)this, (String)lex.getText(titleKey), (Object)list, (int)3);
        if (result == 2) {
            return;
        }
        int[] selections = list.getSelection().getItems();
        int[] ords = new int[selections.length];
        for (int i = 0; i < ords.length; ++i) {
            ords[i] = ((OrdToTag)list.getItem((int)selections[i])).ordinal;
        }
        if (inc) {
            this.include = this.include.getInstance(ords);
            this.includeField.setText(this.include.toString(this.getCurrentContext()));
        } else {
            this.exclude = this.exclude.getInstance(ords);
            this.excludeField.setText(this.exclude.toString(this.getCurrentContext()));
        }
        this.setModified();
    }

    private void clearMask(boolean inc) {
        int[] empty = new int[]{};
        if (inc) {
            this.include = this.include.getInstance(empty);
            this.includeField.setText(this.include.toString(this.getCurrentContext()));
        } else {
            this.exclude = this.include.getInstance(empty);
            this.excludeField.setText(this.exclude.toString(this.getCurrentContext()));
        }
        this.setModified();
    }

    private void setAll(boolean inc) {
        if (inc) {
            this.include = this.include.getInstance(this.include.getOrdinals());
            this.includeField.setText(this.include.toString(this.getCurrentContext()));
        } else {
            this.exclude = this.include.getInstance(this.exclude.getOrdinals());
            this.excludeField.setText(this.exclude.toString(this.getCurrentContext()));
        }
        this.setModified();
    }

    private class SetAll
    extends Command {
        boolean inc;

        public SetAll(boolean inc) {
            super((BWidget)BBitStringFilterFE.this, Sys.getModuleForClass(BBitStringFilterFE.class), "filter.setAllBits");
            this.inc = inc;
        }

        public CommandArtifact doInvoke() {
            BBitStringFilterFE.this.setAll(this.inc);
            return null;
        }
    }

    private class ClearMask
    extends Command {
        boolean inc;

        public ClearMask(boolean inc) {
            super((BWidget)BBitStringFilterFE.this, Sys.getModuleForClass(BBitStringFilterFE.class), "filter.clearBits");
            this.inc = inc;
        }

        public CommandArtifact doInvoke() {
            BBitStringFilterFE.this.clearMask(this.inc);
            return null;
        }
    }

    private class EditMask
    extends Command {
        boolean inc;

        public EditMask(boolean inc) {
            super((BWidget)BBitStringFilterFE.this, Sys.getModuleForClass(BBitStringFilterFE.class), "filter.editBits");
            this.inc = inc;
        }

        public CommandArtifact doInvoke() {
            BBitStringFilterFE.this.editMask(this.inc);
            return null;
        }
    }

    private class OrdToTag {
        public int ordinal;
        public String displayTag;

        public OrdToTag(int ordinal, String displayTag) {
            this.ordinal = ordinal;
            this.displayTag = displayTag;
        }

        public String toString() {
            return this.displayTag;
        }
    }
}

