/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bql.filter;

import com.tridium.bql.filter.BFilterEntry;
import com.tridium.workbench.bql.filter.BFilterFE;
import javax.baja.agent.NoSuchAgentException;
import javax.baja.bql.BIBqlFilter;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BWidget;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraAction(name="checkEditorState")
public class BFilterEntryFE
extends BWbFieldEditor {
    @Generated
    public static final Action checkEditorState = BFilterEntryFE.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFilterEntryFE.class);
    private BCheckBox activeCheck = new BCheckBox();
    private BFilterFE filterEd;
    private double editorLoc = -1.0;

    @Generated
    public void checkEditorState() {
        this.invoke(checkEditorState, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFilterEntryFE() {
        this.add("active", (BValue)this.activeCheck);
        this.filterEd = null;
        this.add("checkLink", (BValue)new BLink((BComponent)this.activeCheck, (Slot)BCheckBox.actionPerformed, (Slot)checkEditorState));
        this.add("checkMod", (BValue)new BLink((BComponent)this.activeCheck, (Slot)BCheckBox.actionPerformed, (Slot)setModified));
    }

    public boolean hasFilterEditor() {
        return this.filterEd != null;
    }

    public void setFilterEnabled(boolean enabled) {
        this.activeCheck.setSelected(enabled);
        this.filterEd.setReadonly(!enabled);
        this.setModified();
    }

    @Override
    protected void doLoadValue(BObject value, Context context) throws Exception {
        if (this.filterEd != null) {
            this.remove((BComplex)this.filterEd);
            this.remove("edLink");
        }
        BFilterEntry entry = (BFilterEntry)value;
        this.activeCheck.setSelected(entry.getActive());
        this.activeCheck.setText(entry.getLabel());
        BIBqlFilter filter = entry.toFilter();
        try {
            this.filterEd = BFilterFE.makeFor(filter);
            this.filterEd.loadValue((BObject)filter, context);
            this.add("filter", (BValue)this.filterEd);
            this.add("edLink", (BValue)new BLink((BComponent)this.filterEd, (Slot)BFilterFE.pluginModified, (Slot)setModified));
        }
        catch (NoSuchAgentException ignored) {
            this.filterEd = null;
        }
        this.checkEditorState();
        this.relayout();
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException, Exception {
        BFilterEntry entry = (BFilterEntry)value;
        entry.setActive(this.activeCheck.getSelected());
        if (this.filterEd != null) {
            entry.setFilter((BValue)this.filterEd.saveValue(cx));
        }
        return value;
    }

    @Override
    public void computePreferredSize() {
        this.activeCheck.computePreferredSize();
        double edWidth = 0.0;
        double edHeight = 0.0;
        if (this.filterEd != null) {
            this.filterEd.computePreferredSize();
            edWidth = this.filterEd.getPreferredWidth();
            edHeight = this.filterEd.getPreferredHeight();
        }
        double w = 0.0;
        double h = 0.0;
        w = this.editorLoc == -1.0 ? this.activeCheck.getPreferredWidth() + edWidth + 6.0 : this.editorLoc + edWidth;
        h = Math.max(this.activeCheck.getPreferredHeight(), edHeight);
        this.setPreferredSize(w, h);
    }

    public double getPreferredEditorLocation() {
        this.activeCheck.computePreferredSize();
        return this.activeCheck.getPreferredWidth() + 6.0;
    }

    public void setEditorLocation(double edLoc) {
        this.editorLoc = edLoc;
    }

    @Override
    public void doLayout(BWidget[] children) {
        double w = this.getWidth();
        double h = this.getHeight();
        this.activeCheck.computePreferredSize();
        this.activeCheck.setBounds(0.0, (h - this.activeCheck.getPreferredHeight()) / 2.0, this.activeCheck.getPreferredWidth(), this.activeCheck.getPreferredHeight());
        if (this.filterEd != null) {
            this.filterEd.computePreferredSize();
            if (this.editorLoc == -1.0) {
                this.filterEd.setBounds(this.activeCheck.getPreferredWidth() + 6.0, (h - this.filterEd.getPreferredHeight()) / 2.0, this.filterEd.getPreferredWidth(), this.filterEd.getPreferredHeight());
            } else {
                this.filterEd.setBounds(this.editorLoc, (h - this.filterEd.getPreferredHeight()) / 2.0, this.filterEd.getPreferredWidth(), this.filterEd.getPreferredHeight());
            }
        }
    }

    @Override
    public void doSetReadonly(boolean readonly) {
        this.activeCheck.setEnabled(!readonly);
        if (this.filterEd != null) {
            this.filterEd.setReadonly(readonly);
        }
        this.relayout();
    }

    public void doCheckEditorState() {
        if (this.filterEd == null) {
            return;
        }
        this.filterEd.setReadonly(!this.activeCheck.getSelected());
    }
}

