/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.bql.filter;

import com.tridium.bql.filter.BFilterSet;
import com.tridium.workbench.bql.filter.BFilterSetEditor;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraAction(name="buttonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")
public class BFilterSetDialog
extends BDialog {
    @Generated
    public static final Action buttonPressed = BFilterSetDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFilterSetDialog.class);
    static Lexicon lex = Lexicon.make((String)"workbench");
    private BFilterSetEditor editor;
    private BButton okButton;
    private BButton cancelButton;
    private BButton disableButton;
    private BFilterSet orig;
    private BFilterSet result;
    private boolean cancelled = false;
    private boolean modified = false;

    @Generated
    public void buttonPressed(BWidgetEvent parameter) {
        this.invoke(buttonPressed, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFilterSetDialog() {
        throw new IllegalStateException();
    }

    public BFilterSetDialog(BWidget owner, BFilterSet orig) {
        super(owner, lex.getText("filter.configFilters"), true, (BWidget)new BNullWidget());
        BEdgePane content = new BEdgePane();
        this.orig = orig;
        this.editor = BFilterSetDialog.makeEditor((BFilterSet)orig.newCopy(true));
        content.setCenter((BWidget)new BBorderPane((BWidget)this.editor));
        BGridPane buttons = new BGridPane(3);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        buttons.add(null, (BValue)this.okButton);
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        buttons.add(null, (BValue)this.cancelButton);
        this.disableButton = new BButton(lex.getText("filter.disableAll"));
        buttons.add(null, (BValue)this.disableButton);
        content.setBottom((BWidget)new BBorderPane((BWidget)buttons, 0.0, 10.0, 10.0, 10.0));
        this.setContent((BWidget)content);
        this.linkTo("okLink", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo("cancelLink", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)buttonPressed);
        this.linkTo("disableLink", (BComponent)this.disableButton, (Slot)BButton.actionPerformed, (Slot)buttonPressed);
    }

    private static BFilterSetEditor makeEditor(BFilterSet filterSet) {
        BFilterSetEditor editor = new BFilterSetEditor();
        editor.loadValue((BObject)filterSet);
        return editor;
    }

    public void doButtonPressed(BWidgetEvent evt) {
        BWidget src = evt.getWidget();
        if (src == this.okButton) {
            this.modified = this.editor.isModified();
            if (this.editor.isModified()) {
                try {
                    this.result = (BFilterSet)this.editor.saveValue();
                }
                catch (Exception e) {
                    BDialog.error((BWidget)this, (String)lex.getText("filter.configError"), (Object)e);
                    return;
                }
            } else {
                this.result = this.orig;
            }
            this.close();
        } else if (src == this.cancelButton) {
            this.cancelled = true;
            this.modified = false;
            this.result = this.orig;
            this.close();
        } else if (src == this.disableButton) {
            this.editor.disableAll();
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isModified() {
        return this.modified;
    }

    public BFilterSet getResult() {
        return this.result;
    }

    public void windowClosing(BWindowEvent event) {
        this.cancelled = true;
        this.modified = false;
        this.result = this.orig;
        this.close();
    }
}

