/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.ListRenderer;
import javax.baja.util.BFormat;
import javax.baja.util.LexiconModule;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"baja:Boolean"})})
public class BBooleanFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BBooleanFE.class);
    private static final LexiconModule LEX = LexiconModule.make((String)"baja");
    private static final String TRUE_ICON_FACET_KEY = "trueIcon";
    private static final String FALSE_ICON_FACET_KEY = "falseIcon";
    private static final String TRUE_ICON_LEX_KEY = "true.icon";
    private static final String FALSE_ICON_LEX_KEY = "false.icon";
    String trueText = BBoolean.toString((boolean)true, null);
    String falseText = BBoolean.toString((boolean)false, null);
    BBrush fg = BBrush.NULL;
    BBrush bg = BBrush.NULL;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBooleanFE() {
        BListDropDown combo = new BListDropDown();
        combo.getList().setRenderer((ListRenderer)new Renderer());
        this.setContent((BWidget)combo);
        this.linkTo("lk0", (BComponent)combo, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)combo, (Slot)BListDropDown.actionPerformed, (Slot)actionPerformed);
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        BListDropDown combo = (BListDropDown)this.getContent();
        combo.setDropDownEnabled(!readonly);
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) {
        BImage trueIcon = null;
        BImage falseIcon = null;
        if (cx != null) {
            BObject t = cx.getFacet("trueText");
            BObject f = cx.getFacet("falseText");
            if (t != null) {
                this.trueText = BFormat.format((String)t.toString(), null, (Context)cx);
            }
            if (f != null) {
                this.falseText = BFormat.format((String)f.toString(), null, (Context)cx);
            }
            BObject ti = cx.getFacet(TRUE_ICON_FACET_KEY);
            BObject fi = cx.getFacet(FALSE_ICON_FACET_KEY);
            if (ti != null) {
                trueIcon = BImage.make((String)BFormat.format((String)ti.toString(), null, (Context)cx));
            }
            if (fi != null) {
                falseIcon = BImage.make((String)BFormat.format((String)fi.toString(), null, (Context)cx));
            }
        }
        if (trueIcon == null) {
            trueIcon = BImage.make((String)LEX.getText(TRUE_ICON_LEX_KEY, cx));
        }
        if (falseIcon == null) {
            falseIcon = BImage.make((String)LEX.getText(FALSE_ICON_LEX_KEY, cx));
        }
        boolean b = ((BIBoolean)value).getBoolean();
        BListDropDown combo = (BListDropDown)this.getContent();
        combo.getList().removeAllItems();
        combo.getList().addItem(falseIcon, (Object)this.falseText);
        combo.getList().addItem(trueIcon, (Object)this.trueText);
        combo.setSelectedItem((Object)(b ? this.trueText : this.falseText));
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) {
        BListDropDown combo = (BListDropDown)this.getContent();
        boolean b = combo.getSelectedItem().equals(this.trueText);
        return BBoolean.make((boolean)b);
    }

    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 306: {
                this.fg = (BBrush)a;
                this.bg = (BBrush)b;
                this.repaint();
                return null;
            }
        }
        return super.fw(x, a, b, c, d);
    }

    class Renderer
    extends ListRenderer {
        Renderer() {
        }

        public BBrush getBackground(ListRenderer.Item item) {
            if (BBooleanFE.this.bg.isNull()) {
                return super.getBackground(item);
            }
            return BBooleanFE.this.bg;
        }

        public BBrush getForeground(ListRenderer.Item item) {
            if (BBooleanFE.this.fg.isNull()) {
                return super.getForeground(item);
            }
            return BBooleanFE.this.fg;
        }
    }
}

