/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BWidget;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public abstract class BComponentNamePickerFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BComponentNamePickerFE.class);
    private static final Logger LOG = Logger.getLogger("workbench");
    BTextDropDown field = new BTextDropDown("", 20, true);
    Item[] items;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BComponentNamePickerFE() {
        this.setContent((BWidget)this.field);
        this.linkTo("la", (BComponent)this.field, (Slot)BTextDropDown.valueModified, (Slot)setModified);
        this.linkTo("lb", (BComponent)this.field, (Slot)BTextDropDown.actionPerformed, (Slot)actionPerformed);
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.field.getEditor().setEditable(!readonly);
        this.field.setDropDownEnabled(!readonly);
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) {
        this.loadName(value.toString());
    }

    public void loadName(String name) {
        block7: {
            this.field.setText(name);
            this.field.getList().removeAllItems();
            this.items = null;
            try {
                Object[] components = this.list();
                try {
                    Array a = new Array(components);
                    a = a.filter(new IFilter(){

                        public boolean accept(Object obj) {
                            BComponent c = (BComponent)obj;
                            BComplex parent = c.getParent();
                            return parent == null || !Flags.isHidden((BComplex)parent, (Slot)c.getPropertyInParent());
                        }
                    });
                    components = (BComponent[])a.trim();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.items = new Item[components.length];
                Item match = null;
                for (int i = 0; i < this.items.length; ++i) {
                    Item item = this.items[i] = new Item((BComponent)components[i]);
                    if (item.name.equals(name)) {
                        match = item;
                    }
                    this.field.getList().addItem(item.icon, (Object)item);
                }
                if (match != null) {
                    this.field.setText(match.displayName);
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block7;
                LOG.log(Level.FINE, "Failed to load names for ComponentNamePickerFE", e);
            }
        }
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) {
        return BString.make((String)this.saveName());
    }

    public String saveName() {
        String name = this.field.getText();
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                if (!this.items[i].displayName.equals(name)) continue;
                name = this.items[i].name;
                break;
            }
        }
        return name;
    }

    public abstract BComponent[] list() throws Exception;

    public final BComponent loadService(Type serviceType) {
        BWbShell shell = this.getWbShell();
        BOrd ord = BOrd.make((BOrd)shell.getActiveOrd(), (String)("service:" + serviceType.toString()));
        return (BComponent)ord.get();
    }

    public final BComponent[] loadFromService(Type serviceType, Class<?> cls) throws Exception {
        BComponent service = this.loadService(serviceType);
        service.lease();
        return (BComponent[])service.getChildren(cls);
    }

    static class Item {
        String name;
        String displayName;
        BImage icon;

        Item(BComponent c) {
            this.name = c.getName();
            this.displayName = c.getDisplayName(null);
            this.icon = BImage.make((BIcon)c.getIcon());
        }

        public String toString() {
            return this.displayName;
        }
    }
}

