/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import java.util.ArrayList;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="fixedChanged"), @NiagaraAction(name="selectionChanged"), @NiagaraAction(name="ordinalChanged"), @NiagaraAction(name="ordinalAction"), @NiagaraAction(name="tagChanged"), @NiagaraAction(name="tagAction"), @NiagaraAction(name="addPressed"), @NiagaraAction(name="modifyPressed"), @NiagaraAction(name="removePressed"), @NiagaraAction(name="okPressed"), @NiagaraAction(name="cancelPressed")})
public class BEnumRangeDialog
extends BDialog {
    @Generated
    public static final Action fixedChanged = BEnumRangeDialog.newAction((int)0, null);
    @Generated
    public static final Action selectionChanged = BEnumRangeDialog.newAction((int)0, null);
    @Generated
    public static final Action ordinalChanged = BEnumRangeDialog.newAction((int)0, null);
    @Generated
    public static final Action ordinalAction = BEnumRangeDialog.newAction((int)0, null);
    @Generated
    public static final Action tagChanged = BEnumRangeDialog.newAction((int)0, null);
    @Generated
    public static final Action tagAction = BEnumRangeDialog.newAction((int)0, null);
    @Generated
    public static final Action addPressed = BEnumRangeDialog.newAction((int)0, null);
    @Generated
    public static final Action modifyPressed = BEnumRangeDialog.newAction((int)0, null);
    @Generated
    public static final Action removePressed = BEnumRangeDialog.newAction((int)0, null);
    @Generated
    public static final Action okPressed = BEnumRangeDialog.newAction((int)0, null);
    @Generated
    public static final Action cancelPressed = BEnumRangeDialog.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BEnumRangeDialog.class);
    static String dialogTitle = UiLexicon.bajaui().getText("enumRangeDialog.title");
    static final int space = 4;
    static final int ERR = -1;
    static final int NEW = -2;
    ArrayList<Pair> pairs = new ArrayList();
    BEnumRange orig;
    BEnumRange result;
    BFrozenEnum fixed;
    BCheckBox useFixed = new BCheckBox(UiLexicon.bajaui().getText("enumRangeDialog.useFrozen"));
    BTextDropDown fixedField = new BTextDropDown("", 20, true);
    boolean enumValid;
    BLabel enumValidLabel = new BLabel("");
    boolean enabled;
    TableModel model = new Model();
    BTable table = new BTable(this.model);
    BTextField ordinalField = new BTextField("", 5);
    BTextField tagField = new BTextField("", 20);
    BButton add = new BButton(UiLexicon.bajaui().getText("action.add"));
    BButton modify = new BButton(UiLexicon.bajaui().getText("action.modify"));
    BButton remove = new BButton(UiLexicon.bajaui().getText("action.remove"));
    BSeparator sep1 = new BSeparator(BOrientation.horizontal);
    BGridPane options = new BGridPane(2);
    BTextField lexicon = new BTextField("", 20);
    BSeparator sep2 = new BSeparator(BOrientation.horizontal);
    BButton ok = new BButton(UiLexicon.bajaui().getText("action.ok"));
    BButton cancel = new BButton(UiLexicon.bajaui().getText("action.cancel"));

    @Generated
    public void fixedChanged() {
        this.invoke(fixedChanged, null, null);
    }

    @Generated
    public void selectionChanged() {
        this.invoke(selectionChanged, null, null);
    }

    @Generated
    public void ordinalChanged() {
        this.invoke(ordinalChanged, null, null);
    }

    @Generated
    public void ordinalAction() {
        this.invoke(ordinalAction, null, null);
    }

    @Generated
    public void tagChanged() {
        this.invoke(tagChanged, null, null);
    }

    @Generated
    public void tagAction() {
        this.invoke(tagAction, null, null);
    }

    @Generated
    public void addPressed() {
        this.invoke(addPressed, null, null);
    }

    @Generated
    public void modifyPressed() {
        this.invoke(modifyPressed, null, null);
    }

    @Generated
    public void removePressed() {
        this.invoke(removePressed, null, null);
    }

    @Generated
    public void okPressed() {
        this.invoke(okPressed, null, null);
    }

    @Generated
    public void cancelPressed() {
        this.invoke(cancelPressed, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BEnumRange open(BWidget owner, BEnumRange value, boolean enabled) {
        BEnumRangeDialog dialog = new BEnumRangeDialog(owner, value, enabled);
        dialog.setBoundsCenteredOnOwner();
        dialog.open();
        return dialog.result;
    }

    private BEnumRangeDialog(BWidget owner, BEnumRange value, boolean enabled) {
        super(owner, dialogTitle, true);
        this.orig = value;
        int[] ordinals = value.getOrdinals();
        for (int i = 0; i < ordinals.length; ++i) {
            int o = ordinals[i];
            String t = value.getTag(o);
            String d = value.getDisplayTag(o, null);
            boolean fixed = value.isFrozenOrdinal(o);
            this.pairs.add(new Pair(o, t, d, fixed));
        }
        Type frozenType = value.getFrozenType();
        if (frozenType != null) {
            this.fixed = (BFrozenEnum)frozenType.getInstance();
            this.useFixed.setSelected(this.fixed != null);
            this.fixedField.setText(this.fixed.getType().toString());
        }
        this.options.add(null, (BValue)new BLabel(UiLexicon.bajaui().getText("enumRangeDialog.lexicon")));
        this.options.add(null, (BValue)this.lexicon);
        this.lexicon.setText(this.orig.getOptions().gets("lexicon", "").trim());
        this.updateFixedList();
        this.sort();
        this.table.setMultipleSelection(false);
        this.table.setCellRenderer((TableCellRenderer)new CellRenderer());
        this.enumValidLabel.setForeground(BColor.red.toBrush());
        this.enabled = enabled;
        if (!enabled) {
            this.ordinalField.setEditable(false);
            this.tagField.setEditable(false);
            this.useFixed.setEnabled(false);
            this.fixedField.setEnabled(false);
        }
        this.add.setEnabled(false);
        this.modify.setEnabled(false);
        this.remove.setEnabled(false);
        this.add("useFixed", (BValue)this.useFixed);
        this.add("fixedField", (BValue)this.fixedField);
        this.add("enumInvalid", (BValue)this.enumValidLabel);
        this.add("table", (BValue)this.table);
        this.add("ordinalField", (BValue)this.ordinalField);
        this.add("tagField", (BValue)this.tagField);
        this.add("add", (BValue)this.add);
        this.add("modify", (BValue)this.modify);
        this.add("remove", (BValue)this.remove);
        this.add("sep1", (BValue)this.sep1);
        this.add("options", (BValue)this.options);
        this.add("sep2", (BValue)this.sep2);
        this.add("ok", (BValue)this.ok);
        this.add("cancel", (BValue)this.cancel);
        this.linkTo("lk0", (BComponent)this.table, (Slot)BTable.selectionModified, (Slot)selectionChanged);
        this.linkTo("lk1", (BComponent)this.ordinalField, (Slot)BTextField.textModified, (Slot)ordinalChanged);
        this.linkTo("lk2", (BComponent)this.ordinalField, (Slot)BTextField.actionPerformed, (Slot)ordinalAction);
        this.linkTo("lk3", (BComponent)this.tagField, (Slot)BTextField.textModified, (Slot)tagChanged);
        this.linkTo("lk4", (BComponent)this.tagField, (Slot)BTextField.actionPerformed, (Slot)tagAction);
        this.linkTo("lk5", (BComponent)this.add, (Slot)BButton.actionPerformed, (Slot)addPressed);
        this.linkTo("lk6", (BComponent)this.modify, (Slot)BButton.actionPerformed, (Slot)modifyPressed);
        this.linkTo("lk7", (BComponent)this.remove, (Slot)BButton.actionPerformed, (Slot)removePressed);
        this.linkTo("lk9", (BComponent)this.useFixed, (Slot)BButton.actionPerformed, (Slot)fixedChanged);
        this.linkTo("lkA", (BComponent)this.fixedField, (Slot)BTextDropDown.valueModified, (Slot)fixedChanged);
        this.linkTo("lkC", (BComponent)this.ok, (Slot)BButton.actionPerformed, (Slot)okPressed);
        this.linkTo("lkD", (BComponent)this.cancel, (Slot)BButton.actionPerformed, (Slot)cancelPressed);
        this.check();
    }

    public void computePreferredSize() {
        this.setPreferredSize(350.0, 400.0);
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        this.useFixed.computePreferredSize();
        double uw = this.useFixed.getPreferredWidth();
        double uh = this.useFixed.getPreferredHeight();
        this.useFixed.setBounds(4.0, 4.0, uw, uh);
        this.fixedField.computePreferredSize();
        double fy = 4.0 + uh + 4.0;
        double fh = this.fixedField.getPreferredHeight();
        double fw = 2.0 * w / 3.0;
        this.fixedField.setBounds(4.0, fy, fw, fh);
        this.enumValidLabel.setBounds(4.0 + fw + 4.0, fy, 25.0, fh);
        double toph = 4.0 + uh + 4.0 + fh + 4.0;
        this.ok.computePreferredSize();
        this.cancel.computePreferredSize();
        double ocw = Math.max(this.ok.getPreferredWidth(), this.cancel.getPreferredWidth());
        double och = this.ok.getPreferredHeight();
        double ocy = h - 4.0 - och;
        double okx = (w - (ocw + 4.0 + ocw)) / 2.0;
        this.ok.setBounds(okx, ocy, ocw, och);
        this.cancel.setBounds(okx + ocw + 4.0, ocy, ocw, och);
        this.sep1.setBounds(4.0, ocy - 12.0, w - 4.0 - 4.0, 4.0);
        this.options.computePreferredSize();
        double qw = this.options.getPreferredWidth();
        double qh = this.options.getPreferredHeight();
        this.options.setBounds(4.0, this.sep1.getY() - 8.0 - qh, qw, qh);
        this.sep2.setBounds(4.0, this.options.getY() - 8.0, w - 4.0 - 4.0, 4.0);
        this.add.computePreferredSize();
        double bh = this.add.getPreferredHeight();
        double bw = (w - 16.0) / 3.0;
        double by = this.sep2.getY() - 8.0 - bh;
        this.add.setBounds(4.0, by, bw, bh);
        this.modify.setBounds(4.0 + (bw + 4.0), by, bw, bh);
        this.remove.setBounds(4.0 + 2.0 * (bw + 4.0), by, bw, bh);
        this.ordinalField.computePreferredSize();
        double th = this.ordinalField.getPreferredHeight();
        double ty = by - 4.0 - th;
        double ow = w / 4.0;
        double nw = w - ow - 12.0;
        this.ordinalField.setBounds(4.0, ty, ow, th);
        this.tagField.setBounds(4.0 + ow + 4.0, ty, nw, th);
        this.table.setBounds(4.0, toph, w - 4.0 - 4.0, ty - 4.0 - toph - 4.0);
    }

    void updateFixed(BFrozenEnum fixed) {
        this.fixed = fixed;
        if (fixed == null) {
            Pair[] p = this.pairs.toArray(new Pair[0]);
            ArrayList<Pair> temp = new ArrayList<Pair>();
            for (int i = 0; i < p.length; ++i) {
                if (p[i].fixed) continue;
                temp.add(p[i]);
            }
            this.pairs = temp;
        } else {
            ArrayList<Pair> temp = new ArrayList<Pair>();
            BEnumRange range = fixed.getRange();
            int[] o = range.getOrdinals();
            for (int i = 0; i < o.length; ++i) {
                temp.add(new Pair(o[i], range.getTag(o[i]), range.getDisplayTag(o[i], null), true));
            }
            Pair[] p = this.pairs.toArray(new Pair[0]);
            for (int i = 0; i < p.length; ++i) {
                Pair x = p[i];
                if (x.fixed || range.isOrdinal(x.ordinal) || range.isTag(x.tag)) continue;
                temp.add(p[i]);
            }
            this.pairs = temp;
        }
        this.sort();
        this.model.updateTable();
        this.check();
    }

    void setEnumValid(boolean valid) {
        this.enumValid = valid;
        boolean ok = valid || this.fixedField.getText().length() == 0;
        this.enumValidLabel.setText(ok ? "" : "***");
        this.enumValidLabel.relayout();
        this.repaint();
    }

    void updateFixedList() {
        Object[] types = Sys.getRegistry().getConcreteTypes(BFrozenEnum.TYPE.getTypeInfo());
        SortUtil.sort((Object[])types);
        this.fixedField.getList().removeAllItems();
        for (int i = 0; i < types.length; ++i) {
            this.fixedField.getList().addItem(types[i]);
        }
    }

    public BEnumRange save() {
        ArrayList<Pair> dynamic = new ArrayList<Pair>();
        for (int i = 0; i < this.pairs.size(); ++i) {
            Pair p = this.pairs.get(i);
            if (p.fixed) continue;
            dynamic.add(p);
        }
        int count = dynamic.size();
        int[] o = new int[count];
        String[] t = new String[count];
        for (int i = 0; i < count; ++i) {
            Pair pair = (Pair)dynamic.get(i);
            o[i] = pair.ordinal;
            t[i] = pair.tag;
        }
        String lex = this.lexicon.getText().trim();
        BFacets newOptions = lex.length() == 0 ? BFacets.makeRemove((BFacets)this.orig.getOptions(), (String)"lexicon") : BFacets.make((BFacets)this.orig.getOptions(), (String)"lexicon", (BIDataValue)BString.make((String)lex));
        return BEnumRange.make((Type)BEnumRangeDialog.toFrozenType(this.fixed), (int[])o, (String[])t, (int)count, (BFacets)newOptions);
    }

    public void windowClosing(BWindowEvent event) {
        this.doCancelPressed();
    }

    public void doCancelPressed() {
        this.result = null;
        this.close();
    }

    public void doOkPressed() {
        this.result = this.save();
        this.close();
    }

    public void doSelectionChanged() {
        if (!this.enabled) {
            return;
        }
        int i = this.table.getSelection().getRow();
        if (i >= 0 && i < this.pairs.size()) {
            Pair pair = this.pairs.get(i);
            this.ordinalField.setText(String.valueOf(pair.ordinal));
            this.tagField.setText(pair.display);
        }
        this.check();
    }

    public void doFixedChanged() {
        BFrozenEnum fixed = null;
        try {
            String text = this.fixedField.getText();
            BTypeSpec spec = BTypeSpec.make((String)text);
            Type type = spec.getResolvedType();
            BFrozenEnum frozen = (BFrozenEnum)type.getInstance();
            if (this.useFixed.isSelected()) {
                fixed = frozen;
            }
            this.setEnumValid(true);
        }
        catch (Throwable e) {
            this.setEnumValid(false);
        }
        this.updateFixed(fixed);
        this.check();
    }

    public void doOrdinalChanged() {
        this.check();
    }

    public void doTagChanged() {
        this.check();
    }

    public void doOrdinalAction() {
        this.commitCurrent();
    }

    public void doTagAction() {
        this.commitCurrent();
        this.ordinalField.requestFocus();
    }

    public void doAddPressed() {
        if (!this.enabled) {
            return;
        }
        int ordinal = Integer.parseInt(this.ordinalField.getText());
        String display = this.tagField.getText();
        String tag = SlotPath.escape((String)display);
        if (!this.checkTag(tag)) {
            return;
        }
        this.pairs.add(new Pair(ordinal, tag, display, false));
        this.sort();
        this.model.updateTable();
        this.check();
        this.table.getSelection().deselectAll();
    }

    public void doModifyPressed() {
        if (!this.enabled) {
            return;
        }
        String display = this.tagField.getText();
        String tag = SlotPath.escape((String)display);
        if (!this.checkTag(tag)) {
            return;
        }
        Pair pair = this.pairs.get(this.ordinalToIndex());
        pair.tag = tag;
        pair.display = display;
        this.sort();
        this.model.updateTable();
        this.check();
    }

    public void doRemovePressed() {
        if (!this.enabled) {
            return;
        }
        this.pairs.remove(this.table.getSelection().getRow());
        this.sort();
        this.model.updateTable();
        this.check();
    }

    private void commitCurrent() {
        if (this.add.isEnabled()) {
            this.doAddPressed();
        } else if (this.modify.isEnabled()) {
            this.doModifyPressed();
        }
    }

    private boolean checkTag(String tag) {
        if (this.containsTag(tag)) {
            Object[] args = new Object[]{tag};
            String title = UiLexicon.bajaui().getText("dialog.error");
            String msg = UiLexicon.bajaui().getText("enumRangeDialog.duplicateTag", args);
            BDialog.error((BWidget)this, (String)title, (Object)msg);
            return false;
        }
        return true;
    }

    private void check() {
        if (!this.enabled) {
            return;
        }
        int ix = this.ordinalToIndex();
        Pair pair = null;
        if (ix >= 0) {
            pair = this.pairs.get(ix);
        }
        int sel = this.table.getSelection().getRow();
        this.add.setEnabled(ix == -2);
        this.modify.setEnabled(pair != null && !pair.fixed && !pair.tag.equals(this.tagField.getText()));
        this.remove.setEnabled(pair != null && !pair.fixed);
        this.fixedField.setEnabled(this.useFixed.isSelected());
    }

    static Type toFrozenType(BFrozenEnum fixed) {
        if (fixed == null) {
            return null;
        }
        return fixed.getType();
    }

    void sort() {
        Object[] p = this.pairs.toArray(new Pair[0]);
        SortUtil.sort((Object[])p);
        this.pairs.clear();
        for (int i = 0; i < p.length; ++i) {
            this.pairs.add((Pair)p[i]);
        }
    }

    boolean containsTag(String tag) {
        for (int i = 0; i < this.pairs.size(); ++i) {
            Pair p = this.pairs.get(i);
            if (!p.tag.equals(tag)) continue;
            return true;
        }
        return false;
    }

    int ordinalToIndex() {
        try {
            int ordinal = Integer.parseInt(this.ordinalField.getText());
            for (int i = 0; i < this.pairs.size(); ++i) {
                Pair pair = this.pairs.get(i);
                if (ordinal != pair.ordinal) continue;
                return i;
            }
            return -2;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public static void main(String[] args) {
        try {
            int[] o = new int[]{2, 3, 4};
            String[] t = new String[]{"two", "three", "four"};
            BOrientation fixed = BOrientation.horizontal;
            BEnumRange range = BEnumRange.make((Type)BEnumRangeDialog.toFrozenType((BFrozenEnum)fixed), (int[])o, (String[])t);
            BEnumRangeDialog x = new BEnumRangeDialog((BWidget)new BFrame(), range, true);
            x.setScreenBounds(100.0, 100.0, 350.0, 400.0);
            x.open();
            if (x.result == null) {
                System.out.println("canceled");
            } else {
                System.out.println(x.result.encodeToString());
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    static class Pair
    implements Comparable<Pair> {
        int ordinal;
        String tag;
        String display;
        boolean fixed;

        Pair(int o, String t, String d, boolean f) {
            this.ordinal = o;
            this.tag = t;
            this.display = d;
            this.fixed = f;
        }

        @Override
        public int compareTo(Pair o) {
            int p = o.ordinal;
            if (this.ordinal == p) {
                return 0;
            }
            return this.ordinal < p ? -1 : 1;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public boolean equals(Pair o) {
            return this.ordinal == o.ordinal;
        }
    }

    class CellRenderer
    extends TableCellRenderer {
        CellRenderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            Pair pair = BEnumRangeDialog.this.pairs.get(cell.row);
            return pair.fixed ? BColor.blue.toBrush() : BColor.black.toBrush();
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getColumnCount() {
            return 3;
        }

        public int getRowCount() {
            return BEnumRangeDialog.this.pairs.size();
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Ordinal";
                }
                case 1: {
                    return "Tag";
                }
                case 2: {
                    return "Display";
                }
            }
            throw new IllegalStateException();
        }

        public Object getValueAt(int row, int col) {
            Pair pair = BEnumRangeDialog.this.pairs.get(row);
            switch (col) {
                case 0: {
                    return String.valueOf(pair.ordinal);
                }
                case 1: {
                    return pair.tag;
                }
                case 2: {
                    return pair.display;
                }
            }
            throw new IllegalStateException();
        }
    }
}

