/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.nre.util.IPAddressUtil;
import com.tridium.workbench.fieldeditors.BStringFE;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;

@NiagaraType
public class BHTTPHostnameFE
extends BStringFE {
    @Generated
    public static final Type TYPE = Sys.loadType(BHTTPHostnameFE.class);
    private static final String LEX_EXCEPTION_SCHEME = "HTTPHostnameFE.exception.scheme";
    private static final String LEX_EXCEPTION_HOST = "HTTPHostnameFE.exception.invalid";

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) {
        super.doLoadValue(value, cx);
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws CannotSaveException {
        String host;
        Lexicon lex = Lexicon.make(BHTTPHostnameFE.class);
        BString hostname = (BString)super.doSaveValue(value, cx);
        String hostString = hostname.getString();
        int index = hostString.indexOf("//");
        if (index == -1) {
            throw new CannotSaveException(lex.get(LEX_EXCEPTION_SCHEME), true);
        }
        String scheme = hostString.substring(0, index);
        if (!"https:".equals(scheme) && !"http:".equals(scheme)) {
            throw new CannotSaveException(lex.get(LEX_EXCEPTION_SCHEME), true);
        }
        if (hostString.endsWith("/")) {
            hostString = hostString.substring(0, hostString.length() - 1);
        }
        if (!IPAddressUtil.isHostname((String)(host = hostString.substring(index + 2))) && !IPAddressUtil.isNumericAddr((String)host)) {
            throw new CannotSaveException(lex.get(LEX_EXCEPTION_HOST), true);
        }
        return BString.make((String)hostString);
    }
}

