/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.workbench.auth.PasswordUtils;
import com.tridium.workbench.util.WbUtil;
import javax.baja.naming.BISession;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.text.PasswordRenderer;
import javax.baja.ui.text.PasswordTextController;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextRenderer;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"baja:Password"})})
@NiagaraAction(name="modified")
public class BPasswordFE
extends BWbFieldEditor {
    @Generated
    public static final Action modified = BPasswordFE.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPasswordFE.class);
    protected boolean changed = false;
    protected BTextField passwordField = new BTextField("", 20);

    @Generated
    public void modified() {
        this.invoke(modified, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPasswordFE() {
        this.passwordField.setRenderer((TextRenderer)new PasswordRenderer());
        this.passwordField.setController((TextController)new PasswordTextController());
        this.passwordField.setAllowCopying(false);
        this.linkTo("linkA", (BComponent)this.passwordField, (Slot)BTextField.textModified, (Slot)modified);
        this.linkTo("linkB", (BComponent)this.passwordField, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("linkC", (BComponent)this.passwordField, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
        this.setContent((BWidget)this.passwordField);
    }

    public void started() throws Exception {
        super.started();
        this.checkPasswordChangeAllowed();
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.passwordField.setEditable(!readonly);
    }

    @Override
    protected void doLoadValue(BObject value, Context cx) {
        BPassword pw = (BPassword)value;
        String s = pw.isDefault() ? "" : "        ";
        this.passwordField.setText(s);
        this.changed = false;
        this.checkPasswordChangeAllowed();
    }

    public void checkPasswordChangeAllowed() {
        if (this.isReadonly()) {
            return;
        }
        BISession session = null;
        BComponent c = (BComponent)WbUtil.findAncenstorViaWidgetTree(this, BComponent.TYPE, true);
        if (c != null) {
            session = c.getSession();
        }
        if (!PasswordUtils.isPasswordChangeAllowed(session)) {
            this.setReadonly(true);
        }
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) {
        if (this.changed) {
            String str = ((BTextField)this.getContent()).getText();
            return BPassword.make((String)str, (Context)cx);
        }
        return this.getCurrentValue();
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void resetFields() {
        this.passwordField.setText("");
    }

    public void doModified() {
        this.changed = true;
    }
}

