/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.workbench.file.BSubdirectoryDropDown;
import javax.baja.file.BFileScheme;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
public class BSubdirectoryFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BSubdirectoryFE.class);
    BSubdirectoryDropDown dropDown;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected void doSetReadonly(boolean readonly) {
        this.getDropDown().setEditable(!readonly);
    }

    @Override
    protected void doLoadValue(BObject value, Context context) throws Exception {
        BOrd baseDirectory = BOrd.DEFAULT;
        String subdirectory = "";
        if (value instanceof BOrd) {
            OrdQuery[] queries = ((BOrd)value).parse();
            baseDirectory = BSubdirectoryFE.getBaseDirectoryOrd(queries);
            subdirectory = BSubdirectoryFE.getSubdirectoryName(queries);
        }
        BSubdirectoryDropDown dropDown = this.getDropDown();
        dropDown.setBaseDirectoryOrd(baseDirectory);
        dropDown.setText(subdirectory);
    }

    private BSubdirectoryDropDown getDropDown() {
        if (this.dropDown == null) {
            BSubdirectoryDropDown field = new BSubdirectoryDropDown();
            this.linkTo((BComponent)field, (Slot)BSubdirectoryDropDown.valueModified, (Slot)setModified);
            this.linkTo((BComponent)field, (Slot)BSubdirectoryDropDown.actionPerformed, (Slot)actionPerformed);
            this.linkTo((BComponent)field, (Slot)BSubdirectoryDropDown.listActionPerformed, (Slot)actionPerformed);
            this.dropDown = field;
            this.setContent((BWidget)this.dropDown);
        }
        return this.dropDown;
    }

    @Override
    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BSubdirectoryDropDown dropDown = this.getDropDown();
        return BSubdirectoryFE.buildValue(dropDown.getBaseDirectoryOrd(), dropDown.getText());
    }

    public static BOrd buildValue(BOrd baseDirectoryOrd, String subdirectoryName) {
        if (subdirectoryName.isEmpty()) {
            return baseDirectoryOrd;
        }
        return BOrd.make((BOrd)baseDirectoryOrd, (String)("file:" + subdirectoryName));
    }

    public static String getSubdirectoryNameFromValue(BOrd ord) {
        return BSubdirectoryFE.getSubdirectoryName(ord.parse());
    }

    public static BOrd getBaseDirectoryOrdFromValue(BOrd ord) {
        return BSubdirectoryFE.getBaseDirectoryOrd(ord.parse());
    }

    private static String getSubdirectoryName(OrdQuery[] queries) {
        if (queries.length > 0 && queries[queries.length - 1].getScheme().equals(BFileScheme.INSTANCE.getId()) && queries.length > 1 && queries[queries.length - 2].getScheme().equals(BFileScheme.INSTANCE.getId())) {
            return queries[queries.length - 1].getBody();
        }
        return "";
    }

    private static BOrd getBaseDirectoryOrd(OrdQuery[] queries) {
        if (queries.length > 0 && queries[queries.length - 1].getScheme().equals(BFileScheme.INSTANCE.getId()) && queries.length > 1 && queries[queries.length - 2].getScheme().equals(BFileScheme.INSTANCE.getId())) {
            return BOrd.make((OrdQuery[])queries, (int)0, (int)(queries.length - 1));
        }
        return BOrd.make((OrdQuery[])queries);
    }
}

