/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.fieldeditors;

import com.tridium.util.ObjectUtil;
import com.tridium.workbench.celltable.BCellTable;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.IllegalNameException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.options.BMruButton;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.TableSelection;
import javax.baja.util.Lexicon;
import javax.baja.workbench.celleditor.BWbCellEditor;

@NiagaraType
@NiagaraAction(name="tableSelectionModified")
public class BViewQueryEditor
extends BEdgePane {
    @Generated
    public static final Action tableSelectionModified = BViewQueryEditor.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BViewQueryEditor.class);
    private static Lexicon wbLex = Lexicon.make((String)"workbench");
    private static String lexKey = wbLex.get("viewQueryFE.key", "Key");
    private static String lexValue = wbLex.get("viewQueryFE.value", "Value");
    private BCellTable table;
    private TableSelection tableSel;
    private BButton btnRemove;
    private BButton btnAdd;
    private BMruButton history;
    private String viewQueryId = "ViewQueryEditor";
    private Array<Row> rows = new Array(Row.class);
    private boolean readonly = false;

    @Generated
    public void tableSelectionModified() {
        this.invoke(tableSelectionModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static String open(BWidget owner, ViewQuery query) throws Exception {
        return BViewQueryEditor.open(owner, query, false);
    }

    public static String open(BWidget owner, ViewQuery query, boolean readonly) throws Exception {
        String title = wbLex.getText("viewQueryFE.dialogTitle");
        return BViewQueryEditor.open(owner, title, query, readonly);
    }

    public static String open(BWidget owner, String title, ViewQuery query, boolean readonly) throws Exception {
        BViewQueryEditor editor = new BViewQueryEditor(query, readonly);
        int r = BDialog.open((BWidget)owner, (String)title, (Object)((Object)editor), (int)3);
        if (r != 1) {
            return null;
        }
        return editor.save();
    }

    public BViewQueryEditor() {
        throw new IllegalStateException();
    }

    public BViewQueryEditor(ViewQuery query, boolean readonly) {
        this.table = new BCellTable(new String[]{lexKey, lexValue}, new double[]{120.0, 75.0});
        this.tableSel = this.table.getSelection();
        this.table.setCellsEnabled(!readonly);
        this.readonly = readonly;
        this.loadViewQuery(query);
        BConstrainedPane tablePane = new BConstrainedPane((BWidget)this.table);
        tablePane.setMinHeight(150.0);
        tablePane.setMinWidth(300.0);
        this.history = new BMruButton("viewQueryFE");
        this.history.setMruController((BMruButton.MruController)new MruController());
        BGridPane buttons = new BGridPane(4);
        buttons.setHalign(BHalign.right);
        this.btnAdd = BViewQueryEditor.newButton(new Add((BWidget)this));
        buttons.add(null, (BValue)this.btnAdd);
        this.btnRemove = BViewQueryEditor.newButton(new Remove((BWidget)this));
        buttons.add(null, (BValue)this.btnRemove);
        buttons.add(null, (BValue)this.history);
        this.btnRemove.setEnabled(false);
        this.btnAdd.setEnabled(!readonly);
        BEdgePane buttonPane = new BEdgePane();
        buttonPane.setCenter((BWidget)buttons);
        BEdgePane edge = new BEdgePane();
        edge.setCenter((BWidget)tablePane);
        edge.setBottom((BWidget)new BBorderPane((BWidget)buttonPane, 3.0, 0.0, 6.0, 0.0));
        this.setCenter((BWidget)edge);
        this.linkTo("linkTable", (BComponent)this.table, (Slot)BCellTable.selectionModified, (Slot)tableSelectionModified);
    }

    private static BButton newButton(Command cmd) {
        BButton b = new BButton(cmd, true, true);
        b.setHalign(BHalign.left);
        return b;
    }

    public String save() throws Exception {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.rows.size(); ++i) {
            Row row = (Row)this.rows.get(i);
            BString key = (BString)row.keyCe.saveValue();
            BString value = (BString)row.valCe.saveValue();
            if (key.getString().length() == 0) {
                throw new IllegalNameException("baja", "IllegalNameException.name", new Object[]{key});
            }
            if (i > 0) {
                sb.append(";");
            }
            sb.append(key).append("=").append(value);
        }
        String params = sb.toString();
        ViewQuery q = new ViewQuery(this.viewQueryId + "?" + params);
        this.history.getMruOptions().save(params);
        return q.getBody();
    }

    public void doTableSelectionModified() {
        if (!this.readonly) {
            int n = this.tableSel.getRow();
            this.btnRemove.setEnabled(n != -1);
        }
    }

    private void clearTable() {
        while (this.rows.size() > 0) {
            this.rows.remove(0);
            this.table.removeRow(0);
        }
        this.tableSel.deselectAll();
        this.table.relayout();
    }

    private SortedMap<String, String> parseParamString(String paramString) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String param : paramString.split(";")) {
            String[] kv = param.split("=");
            map.put(kv[0], kv.length == 2 ? kv[1] : "");
        }
        return map;
    }

    private void loadViewQuery(ViewQuery query) {
        if (query != null) {
            this.viewQueryId = query.getViewId();
            String body = query.getBody();
            int index = body.indexOf("?");
            if (index >= 0) {
                String paramString = body.substring(index + 1);
                SortedMap<String, String> paramMap = this.parseParamString(paramString);
                for (Map.Entry entry : paramMap.entrySet()) {
                    String k = (String)entry.getKey();
                    String v = (String)entry.getValue();
                    this.table.addRow(new Row(k, (BObject)BString.make((String)v), false).toArray());
                }
            }
        }
    }

    private boolean containsKey(String key) {
        try {
            for (int i = 0; i < this.rows.size(); ++i) {
                Row row = (Row)this.rows.get(i);
                String k = row.keyCe.saveValue().toString();
                if (!k.equals(key)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    class MruController
    extends BMruButton.MruController {
        MruController() {
        }

        public void select(String value) {
            try {
                BViewQueryEditor.this.clearTable();
                BViewQueryEditor.this.loadViewQuery(new ViewQuery(BViewQueryEditor.this.viewQueryId + "?" + value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class Row {
        BWbCellEditor keyCe;
        BWbCellEditor valCe;

        Row(String key, BObject value, boolean readOnly) {
            BString k = BString.make((String)key);
            this.keyCe = BWbCellEditor.makeFor((BObject)k);
            this.valCe = BWbCellEditor.makeFor(value);
            this.keyCe.setReadonly(readOnly);
            this.valCe.setReadonly(readOnly);
            this.keyCe.loadValue((BObject)k);
            this.valCe.loadValue(value);
            BViewQueryEditor.this.rows.add((Object)this);
        }

        BWbCellEditor[] toArray() {
            return new BWbCellEditor[]{this.keyCe, this.valCe};
        }
    }

    private class Remove
    extends Command {
        Remove(BWidget owner) {
            super(owner, wbLex, "viewQueryFE.remove");
        }

        public CommandArtifact doInvoke() {
            if (BViewQueryEditor.this.readonly) {
                return null;
            }
            int n = BViewQueryEditor.this.tableSel.getRow();
            if (n == -1) {
                throw new IllegalStateException();
            }
            BViewQueryEditor.this.rows.remove(n);
            BViewQueryEditor.this.table.removeRow(n);
            BViewQueryEditor.this.tableSel.deselectAll();
            int len = BViewQueryEditor.this.table.getRowCount();
            if (len > 0) {
                BViewQueryEditor.this.tableSel.select(n == len ? n - 1 : n);
            }
            BViewQueryEditor.this.table.relayout();
            return null;
        }
    }

    private class Add
    extends Command
    implements ObjectUtil.NameContainer {
        Add(BWidget owner) {
            super(owner, wbLex, "viewQueryFE.add");
        }

        public boolean contains(String name) {
            return BViewQueryEditor.this.containsKey(name);
        }

        public CommandArtifact doInvoke() {
            int count = BViewQueryEditor.this.table.getRowCount();
            BViewQueryEditor.this.table.addRow(new Row(ObjectUtil.generateUniqueSlotName((String)"key", (ObjectUtil.NameContainer)this), (BObject)BString.DEFAULT, false).toArray());
            BViewQueryEditor.this.tableSel.deselectAll();
            BViewQueryEditor.this.tableSel.select(count - 1);
            BViewQueryEditor.this.table.relayout();
            return null;
        }
    }
}

