/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.file;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.nav.BFileMenuAgent;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.transfer.TransferUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.space.Mark;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.Subject;
import javax.baja.ui.commands.CopyCommand;
import javax.baja.ui.commands.CutCommand;
import javax.baja.ui.commands.DeleteCommand;
import javax.baja.ui.commands.DuplicateCommand;
import javax.baja.ui.commands.PasteCommand;
import javax.baja.ui.commands.RenameCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.file.BFileChooser;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.table.TableSubject;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.menu.NavMenuUtil;

@NiagaraType
public class BDirTable
extends BTable
implements NavListener {
    @Generated
    public static final Type TYPE = Sys.loadType(BDirTable.class);
    static final BImage defaultIcon = BImage.make((String)"module://icons/x16/file.png");
    static DecimalFormat sizeFormat = new DecimalFormat("#,##0.# KB");
    static final BBrush cutFg = BColor.make((int)100, (int)100, (int)100).toBrush();
    static final int COL_NAME = 0;
    static final int COL_TYPE = 1;
    static final int COL_SIZE = 2;
    static final int COL_MODIFIED = 3;
    final UiLexicon lex = UiLexicon.bajaui();
    final String LEX_NAME = this.lex.getText("name");
    final String LEX_TYPE = this.lex.getText("type");
    final String LEX_SIZE = this.lex.getText("size");
    final String LEX_MODIFIED = this.lex.getText("modified");
    boolean enableEdits = false;
    BIDirectory dir;
    Context context;
    boolean isSpace;
    BOrd dirOrd;
    boolean dropActive;
    Row[] rows = new Row[0];
    Row[] origRowOrder;
    BIFile copyFrom = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDirTable() {
        this.setModel((TableModel)new DynamicTableModel((TableModel)new Model()));
        this.setSelection(new Selection());
        this.setController(new Controller());
        this.setHeaderRenderer(new HeaderRenderer());
        this.setCellRenderer(new CellRenderer());
    }

    public void load(BIDirectory dir, Context context) {
        boolean first = this.dir == null;
        this.enableEdits = false;
        if (dir instanceof BDirectory) {
            this.enableEdits = !((BDirectory)dir).isReadonly();
        }
        BIFile[] files = dir.listFiles();
        Row[] rows = new Row[files.length];
        for (int i = 0; i < rows.length; ++i) {
            rows[i] = new Row(files[i], context);
        }
        this.dir = dir;
        this.context = context;
        this.isSpace = dir instanceof BFileSpace;
        this.dirOrd = dir.getNavOrd();
        this.rows = rows;
        this.origRowOrder = (Row[])rows.clone();
        if (first) {
            this.sortByColumn(0, true);
        }
        this.sizeColumnsToFit();
        this.fireTableModified(new BWidgetEvent(1, (BWidget)this));
        this.updateTransferCommands();
    }

    public void refresh() {
        BIFile[] files = this.dir.listFiles();
        Row[] newRows = new Row[files.length];
        Row[] oldRows = this.rows;
        int n = 0;
        block0: for (int i = 0; i < files.length; ++i) {
            String filename = files[i].getFileName();
            for (int j = 0; j < oldRows.length; ++j) {
                if (!filename.equals(oldRows[j].file.getFileName())) continue;
                files[i] = null;
                newRows[n++] = oldRows[j];
                continue block0;
            }
        }
        int selectStart = n;
        for (int i = 0; i < files.length; ++i) {
            if (files[i] == null) continue;
            newRows[n++] = new Row(files[i], this.context);
        }
        this.rows = newRows;
        this.getSelection().deselectAll();
        if (selectStart < newRows.length) {
            this.getSelection().select(selectStart, this.rows.length - 1);
        }
        this.sizeColumnsToFit();
        this.fireTableModified(new BWidgetEvent(1, (BWidget)this));
    }

    public void started() throws Exception {
        super.started();
        BNavRoot.INSTANCE.addNavListener((NavListener)this);
    }

    public void stopped() throws Exception {
        super.stopped();
        BNavRoot.INSTANCE.removeNavListener((NavListener)this);
    }

    public void navEvent(NavEvent event) {
        if (this.dirOrd != null && this.dirOrd.equals((Object)event.getParentOrd())) {
            this.refresh();
        }
    }

    public BWbShell getWbShell() {
        BWidgetShell shell = this.getShell();
        if (shell instanceof BWbShell) {
            return (BWbShell)shell;
        }
        return null;
    }

    public BIFile getSelectedFile() {
        int sel = this.getSelection().getRow();
        if (sel == -1) {
            return null;
        }
        return this.rows[sel].file;
    }

    public BIFile[] getSelectedFiles() {
        int[] sel = this.getSelection().getRows();
        BIFile[] files = new BIFile[sel.length];
        for (int i = 0; i < sel.length; ++i) {
            files[i] = this.rows[sel[i]].file;
        }
        return files;
    }

    public Mark getSelectedFilesAsMark() {
        if (this.dir == null) {
            return null;
        }
        BIFile[] f = this.getSelectedFiles();
        if (f.length == 0) {
            return null;
        }
        String[] names = new String[f.length];
        BObject[] objects = new BObject[f.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = f[i].getFileName();
            objects[i] = (BObject)f[i];
        }
        return new Mark(objects, names);
    }

    public void updateTransferCommands() {
        BIFile[] files = this.getSelectedFiles();
        int count = files.length;
        boolean filesEditable = true;
        for (int i = 0; i < count; ++i) {
            if (!files[i].isReadonly()) continue;
            filesEditable = false;
            break;
        }
        this.setCutEnabled(count > 0 && filesEditable && this.enableEdits);
        this.setCopyEnabled(count > 0);
        this.setPasteEnabled(this.enableEdits);
        this.setDuplicateEnabled(count > 0 && this.enableEdits);
        this.setDeleteEnabled(count > 0 && filesEditable && this.enableEdits);
        this.setRenameEnabled(count > 0 && filesEditable && this.enableEdits);
    }

    public TransferEnvelope getTransferData() throws Exception {
        if (this.copyFrom != null) {
            String[] names = new String[]{this.copyFrom.getFileName()};
            BObject[] objects = new BObject[]{(BObject)this.copyFrom};
            return TransferEnvelope.make((Mark)new Mark(objects, names));
        }
        Mark mark = this.getSelectedFilesAsMark();
        if (mark == null) {
            return null;
        }
        return TransferEnvelope.make((Mark)mark);
    }

    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        return TransferUtil.insert((BWidget)this, cx, (BObject)this.dir, null);
    }

    public CommandArtifact removeTransferData(TransferContext cx) throws Exception {
        return null;
    }

    public CommandArtifact doDelete() throws Exception {
        Mark mark = this.getSelectedFilesAsMark();
        if (mark == null) {
            return null;
        }
        return TransferUtil.delete((BWidget)this, mark);
    }

    public CommandArtifact doRename() throws Exception {
        Mark mark = this.getSelectedFilesAsMark();
        if (mark == null) {
            return null;
        }
        return TransferUtil.rename((BWidget)this, mark);
    }

    public void mouseDragStarted(BMouseEvent event) {
        int[] rows = this.getSelection().getRows();
        if (rows.length == 0) {
            return;
        }
        int row = this.getRowAt(event.getY());
        boolean found = false;
        for (int i = 0; i < rows.length; ++i) {
            if (row != rows[i]) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        Mark mark = this.getSelectedFilesAsMark();
        SimpleDragRenderer dragRenderer = new SimpleDragRenderer(mark);
        dragRenderer.font = Theme.table().getCellFont();
        this.startDrag(event, TransferEnvelope.make((Mark)mark), (DragRenderer)dragRenderer);
    }

    public void dragEnter(TransferContext cx) {
        if (!this.enableEdits) {
            return;
        }
        this.dropActive = true;
        this.repaint();
    }

    public int dragOver(TransferContext cx) {
        if (!this.enableEdits) {
            return 0;
        }
        int mask = 48;
        return mask;
    }

    public void dragExit(TransferContext cx) {
        this.dropActive = false;
        this.repaint();
    }

    public CommandArtifact drop(TransferContext cx) throws Exception {
        this.dropActive = false;
        this.repaint();
        if (!this.enableEdits) {
            return null;
        }
        return this.insertTransferData(cx);
    }

    public static BMenu makeDirPopup(BTransferWidget owner, BIDirectory dir, Subject subject, boolean enableEdits) {
        BMenu menu = NavMenuUtil.makeMenu((BWidget)owner, subject);
        if (subject.size() > 1) {
            return menu;
        }
        BDirectory d = (BDirectory)dir;
        BMenu newMenu = null;
        Command copyFromCommand = null;
        if (enableEdits) {
            newMenu = BFileMenuAgent.makeNewMenu((BWidget)owner, d);
            if (owner instanceof BDirTable) {
                copyFromCommand = ((BDirTable)owner).makeCopyFromCommand();
            }
        }
        if (menu == null) {
            menu = new BMenu();
            BIFile active = (BIFile)subject.getActive();
            if (active != null) {
                BMenu views = NavMenuUtil.makeViewsMenu((BWidget)owner, (BObject)active, active.getAbsoluteOrd());
                menu.add("views", (BValue)new BSubMenuItem((BIMenu)views));
            }
            if (!enableEdits) {
                menu.add("copy", (Command)new CopyCommand(owner));
            } else {
                if (newMenu != null) {
                    menu.add("new", (BValue)new BSubMenuItem((BIMenu)newMenu));
                    menu.add("sep0", (BValue)new BSeparator());
                }
                menu.add("copy", (Command)new CopyCommand(owner));
                menu.add("cut", (Command)new CutCommand(owner));
                menu.add("paste", (Command)new PasteCommand(owner));
                menu.add("duplicate", (Command)new DuplicateCommand(owner));
                if (copyFromCommand != null) {
                    menu.add("copyFrom", copyFromCommand);
                }
                menu.add("sep1", (BValue)new BSeparator());
                menu.add("delete", (Command)new DeleteCommand(owner));
                menu.add("rename", (Command)new RenameCommand(owner));
            }
        } else {
            BDirTable.supplementPopupMenu(menu, newMenu, copyFromCommand);
        }
        return menu;
    }

    public static void supplementPopupMenu(BMenu menu, BMenu newMenu, Command copyFromCommand) {
        Property newMenuProperty = null;
        Property copyFromProperty = null;
        String newMenuTitle = null;
        if (newMenu != null) {
            newMenuProperty = menu.add("new", (BValue)new BSubMenuItem((BIMenu)newMenu));
            newMenuTitle = newMenu.getText();
        }
        if (copyFromCommand != null) {
            copyFromProperty = menu.add("copyFrom", (BValue)new BActionMenuItem(copyFromCommand));
        }
        Property[] originalMenuItems = menu.getDynamicPropertiesArray();
        ArrayList<Property> reorderedMenuItems = new ArrayList<Property>();
        int i = 0;
        int menuCount = originalMenuItems.length;
        while (reorderedMenuItems.size() < menuCount) {
            Property menuProperty = originalMenuItems[i];
            if (!(newMenuProperty == null || reorderedMenuItems.size() != menuCount - 1 && menu.get(menuProperty) instanceof BSubMenuItem)) {
                reorderedMenuItems.add(newMenuProperty);
                newMenuProperty = null;
            }
            if (reorderedMenuItems.size() < menuCount) {
                BValue menuItem;
                boolean redundantMenuProperty = false;
                if (menuProperty != newMenuProperty && newMenuTitle != null && (menuItem = menu.get(menuProperty)) instanceof BSubMenuItem) {
                    redundantMenuProperty = newMenuTitle.equals(((BSubMenuItem)menuItem).getMenu().getText());
                }
                if (redundantMenuProperty) {
                    menu.remove(menuProperty);
                    --menuCount;
                } else {
                    reorderedMenuItems.add(menuProperty);
                    if (menuProperty == newMenuProperty) {
                        newMenuProperty = null;
                    }
                    if (menuProperty == copyFromProperty) {
                        copyFromProperty = null;
                    }
                }
            }
            if (reorderedMenuItems.size() < menuCount && copyFromProperty != null && ("duplicate".equals(menuProperty.getName()) || reorderedMenuItems.size() == menuCount - 1)) {
                reorderedMenuItems.add(copyFromProperty);
                copyFromProperty = null;
            }
            ++i;
        }
        menu.reorder(reorderedMenuItems.toArray(new Property[0]));
    }

    Command makeCopyFromCommand() {
        return new CopyFromCommand((BTransferWidget)this);
    }

    public static BImage icon(BIcon i) {
        BImage icon = BImage.make((BIcon)i);
        if (icon == null) {
            return defaultIcon;
        }
        return icon;
    }

    public static String size(long size) {
        if (size < 0L) {
            return "";
        }
        if (size < 1024L) {
            return "1 KB";
        }
        double d = size / 1024L;
        return sizeFormat.format(d);
    }

    public static String time(BAbsTime time, Context context) {
        if (time == null || time.isNull()) {
            return "";
        }
        return time.toString(context);
    }

    static class NameKey
    implements Comparable<NameKey> {
        Row row;

        NameKey(Row row) {
            this.row = row;
        }

        @Override
        public int compareTo(NameKey obj) {
            Row a = this.row;
            Row b = obj.row;
            if (a.file.isDirectory()) {
                if (!b.file.isDirectory()) {
                    return -1;
                }
                return a.name.compareToIgnoreCase(b.name);
            }
            if (b.file.isDirectory()) {
                return 1;
            }
            return a.name.compareToIgnoreCase(b.name);
        }
    }

    static class Row {
        BIFile file;
        BImage icon;
        String name;
        String type;
        String sizeString;
        String modifiedString;
        long size;
        BAbsTime modified;

        Row(BIFile file, Context context) {
            try {
                this.file = file;
                this.icon = BDirTable.icon(file.getNavIcon());
                this.name = file.getNavDisplayName(null);
                this.type = file.asObject().getType().getTypeName();
                this.size = file.getSize();
                this.sizeString = BDirTable.size(this.size);
                this.modified = file.getLastModified();
                this.modifiedString = BDirTable.time(this.modified, context);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public BImage getIcon() {
            if (this.file.isPendingMove()) {
                return this.icon.getDisabledImage();
            }
            return this.icon;
        }

        public Object getSortKey(int col) {
            switch (col) {
                case 0: {
                    return new NameKey(this);
                }
                case 1: {
                    return this.type;
                }
                case 2: {
                    return this.size;
                }
                case 3: {
                    return this.modified == null ? BAbsTime.NULL : this.modified;
                }
            }
            throw new IllegalStateException();
        }
    }

    class Model
    extends TableModel {
        Model() {
        }

        public int getRowCount() {
            return BDirTable.this.rows.length;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return BDirTable.this.LEX_NAME;
                }
                case 1: {
                    return BDirTable.this.LEX_TYPE;
                }
                case 2: {
                    return BDirTable.this.LEX_SIZE;
                }
                case 3: {
                    return BDirTable.this.LEX_MODIFIED;
                }
            }
            return "?";
        }

        public BHalign getColumnAlignment(int col) {
            if (col == 2) {
                return BHalign.right;
            }
            return BHalign.left;
        }

        public Object getSubject(int row) {
            return BDirTable.this.rows[row].file;
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return BDirTable.this.rows[row].name;
                }
                case 1: {
                    return BDirTable.this.rows[row].type;
                }
                case 2: {
                    return BDirTable.this.rows[row].sizeString;
                }
                case 3: {
                    return BDirTable.this.rows[row].modifiedString;
                }
            }
            return "?";
        }

        public boolean isColumnSortable(int col) {
            return true;
        }

        public void sortByColumn(int col, boolean ascending) {
            if (col == 0 && BDirTable.this.dir instanceof BFileSpace) {
                BDirTable.this.rows = (Row[])BDirTable.this.origRowOrder.clone();
            } else {
                Object[] keys = new Object[BDirTable.this.rows.length];
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = BDirTable.this.rows[i].getSortKey(col);
                }
                SortUtil.sort((Object[])keys, (Object[])BDirTable.this.rows, (boolean)ascending);
            }
        }

        public BImage getRowIcon(int row) {
            return BDirTable.this.rows[row].getIcon();
        }
    }

    class CopyFromCommand
    extends Command {
        public CopyFromCommand(BTransferWidget owner) {
            super((BWidget)owner, UiLexicon.bajaui().module, "commands.copyFrom");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CommandArtifact doInvoke() throws Exception {
            BTransferWidget owner = (BTransferWidget)this.getOwner();
            BNiagaraWbShell shell = (BNiagaraWbShell)BDirTable.this.getWbShell();
            if (shell.fileChooser == null) {
                shell.fileChooser = BFileChooser.makeOpen((BWidget)shell);
            }
            BOrd ord = shell.fileChooser.show();
            try {
                if (ord != null) {
                    BDirTable.this.copyFrom = (BIFile)ord.get();
                    BDirTable.this.setCopyEnabled(true);
                    owner.doCopy();
                    owner.doPaste();
                }
            }
            finally {
                BDirTable.this.copyFrom = null;
                BDirTable.this.updateTransferCommands();
            }
            return null;
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        protected void handleEnter(BKeyEvent event) {
            event.consume();
            int[] selRows = this.getSelection().getRows();
            if (selRows.length == 1) {
                this.hyperlink(BDirTable.this.rows[selRows[0]].file.getNavOrd(), null);
            }
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            this.hyperlink(BDirTable.this.rows[row].file.getNavOrd(), event);
        }

        public int getTextSearchColumn() {
            return 0;
        }

        private void hyperlink(BOrd ord, BMouseEvent event) {
            BWbShell shell = BDirTable.this.getWbShell();
            if (ord != null && shell != null) {
                HyperlinkInfo info = event == null ? new HyperlinkInfo(ord) : new HyperlinkInfo(ord, (BInputEvent)event);
                shell.hyperlink(info);
            }
        }

        protected BMenu makePopup(TableSubject subject) {
            return BDirTable.makeDirPopup((BTransferWidget)BDirTable.this, BDirTable.this.dir, (Subject)subject, BDirTable.this.enableEdits);
        }
    }

    class CellRenderer
    extends TableCellRenderer {
        CellRenderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            try {
                BIFile file = BDirTable.this.rows[cell.row].file;
                if (file.isPendingMove()) {
                    return cutFg;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            return super.getForeground(cell);
        }
    }

    class HeaderRenderer
    extends TableHeaderRenderer {
        HeaderRenderer() {
        }

        public BBrush getForeground(TableHeaderRenderer.Header header) {
            if (BDirTable.this.dropActive) {
                return Theme.widget().getDropOkForeground();
            }
            return super.getForeground(header);
        }

        public BBrush getBackground(TableHeaderRenderer.Header header) {
            if (BDirTable.this.dropActive) {
                return Theme.widget().getDropOkBackground();
            }
            return super.getBackground(header);
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BDirTable.this.updateTransferCommands();
        }
    }
}

