/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.job;

import com.tridium.ui.theme.Theme;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.NoSuchAgentException;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType
public class BJobBar
extends BEdgePane
implements BWbComponentView.Attachable {
    @Generated
    public static final Type TYPE = Sys.loadType(BJobBar.class);
    static final BImage messageIcon = BImage.make((String)"module://icons/x16/info.png");
    static final BImage unknownIcon = BImage.make((String)"module://icons/x16/job/unknown.png");
    static final BImage runningIcon = BImage.make((String)"module://icons/x16/job/running.png");
    static final BImage canceledIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    static final BImage successIcon = BImage.make((String)"module://icons/x16/job/success.png");
    static final BImage failedIcon = BImage.make((String)"module://icons/x16/job/failed.png");
    static final String lexStatus = UiLexicon.bajaui().getText("status");
    static final String lexTimestamp = UiLexicon.bajaui().getText("timestamp");
    static final String lexMessage = UiLexicon.bajaui().getText("message");
    static final String lexDetails = UiLexicon.bajaui().getText("details");
    static final String lexCancel = UiLexicon.bajaui().getText("cancel");
    static final String lexDispose = UiLexicon.bajaui().getText("dispose");
    static final String lexLog = UiLexicon.bajaui().getText("log");
    static final String lexJobLog = UiLexicon.bajaui().getText("job.log");
    static final String lexLogDetails = UiLexicon.bajaui().getText("log.details");
    static AgentFilter agentFilter = AgentFilter.is((Type)TYPE);
    static BImage cancelIcon = BImage.make((String)"module://icons/x16/stop.png");
    static BImage disposeIcon = BImage.make((String)"module://icons/x16/close.png");
    static BImage logIcon = BImage.make((String)"module://icons/x16/doubleArrowRight.png");
    private BJob job;
    private BLabel state = new BLabel();
    private BLabel name = new BLabel();
    private BLabel message = new BLabel("", BHalign.right);
    private BBorderPane progress = new BBorderPane((BWidget)new BNullWidget(), BBorder.none, BInsets.make((double)10.0, (double)0.0, (double)0.0, (double)10.0));
    private BWidget content;
    private BButton cancelButton;
    private BButton disposeButton;
    private BButton logButton;
    private int complete = 0;
    private Cancel cancel = new Cancel((BWidget)this);
    private Dispose dispose = new Dispose((BWidget)this);
    private Log log = new Log((BWidget)this);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BJobBar makeFor(BJob job) {
        try {
            return (BJobBar)job.getAgents().filter(agentFilter).getDefault().getInstance();
        }
        catch (NoSuchAgentException ignored) {
            return new BJobBar();
        }
    }

    public BJobBar() {
        BButton a = new BButton((Command)this.cancel);
        BButton b = new BButton((Command)this.dispose);
        BButton c = new BButton((Command)this.log);
        a.setBackground(Theme.widget().getWindowBackground());
        b.setBackground(Theme.widget().getWindowBackground());
        c.setBackground(Theme.widget().getWindowBackground());
        a.setButtonStyle(BButtonStyle.toolBar);
        b.setButtonStyle(BButtonStyle.toolBar);
        c.setButtonStyle(BButtonStyle.toolBar);
        this.cancelButton = a;
        this.disposeButton = b;
        this.logButton = c;
        BGridPane pane = new BGridPane(5);
        pane.setStretchColumn(2);
        pane.setColumnAlign(BHalign.fill);
        pane.add(null, (BValue)this.state);
        pane.add(null, (BValue)this.name);
        pane.add("center", (BValue)this.message);
        pane.add(null, (BValue)c);
        pane.add("action", (BValue)this.disposeButton);
        this.setCenter((BWidget)pane);
        this.content = pane;
        this.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        if (this.job != null && !this.job.isMounted()) {
            this.load(null);
        }
        g.setBrush(Theme.progressBar().getWindowBackground((IStylable)this));
        g.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        super.paint(g);
        if (this.progress.getParentWidget() == null) {
            return;
        }
        double x = this.progress.getX();
        double y = this.progress.getY();
        double w = this.progress.getWidth() - 1.0;
        double h = this.progress.getHeight() - 1.0;
        double dx = (double)this.complete / 100.0 * w;
        g.setBrush(Theme.progressBar().getWindowForeground((IStylable)this));
        g.push();
        try {
            g.translate(x, y);
            g.fillRect(0.0, 0.0, dx, h);
        }
        finally {
            g.pop();
        }
        g.setBrush(Theme.progressBar().getControlBackground());
        g.strokeRect(x, y, w, h);
    }

    public String getStyleSelector() {
        return "progress-bar";
    }

    public void load(BJob job) {
        this.job = job;
        this.sync();
    }

    void sync() {
        this.cancelButton.setEnabled(this.job != null);
        this.disposeButton.setEnabled(this.job != null);
        this.logButton.setEnabled(this.job != null);
        this.state.setVisible(this.job != null);
        this.name.setVisible(this.job != null);
        this.message.setVisible(this.job != null);
        if (this.job == null) {
            return;
        }
        this.state.setImage(BJobBar.stateToIcon(this.job.getJobState()));
        this.name.setText(this.job.toString(null));
        this.name.setImage(BImage.make((BIcon)this.job.getIcon()));
        this.message.setText(this.job.getJobState().toString(null));
        this.complete = this.job.getProgress();
        if (this.job.getJobState().isRunning()) {
            this.content.set("center", (BValue)this.progress);
            this.content.set("action", (BValue)this.cancelButton);
        } else {
            this.content.set("center", (BValue)this.message);
            this.content.set("action", (BValue)this.disposeButton);
        }
        this.repaint();
    }

    @Override
    public void attached(BWbComponentView editor) {
    }

    @Override
    public void detached(BWbComponentView editor) {
    }

    @Override
    public void handleComponentEvent(BComponentEvent event) {
        if (event.getSourceComponent() == this.job) {
            this.sync();
        }
    }

    static BImage stateToIcon(BJobState state) {
        switch (state.getOrdinal()) {
            case 1: {
                return runningIcon;
            }
            case 2: {
                return canceledIcon;
            }
            case 3: {
                return canceledIcon;
            }
            case 4: {
                return successIcon;
            }
            case 5: {
                return failedIcon;
            }
        }
        return unknownIcon;
    }

    static BImage itemToIcon(JobLogItem item) {
        switch (item.getId()) {
            case 1: {
                return runningIcon;
            }
            case 2: {
                return canceledIcon;
            }
            case 3: {
                return successIcon;
            }
            case 4: {
                return failedIcon;
            }
        }
        return messageIcon;
    }

    public class JobLogController
    extends TableController {
        JobLog log;

        public JobLogController(JobLog log) {
            this.log = log;
        }

        public void cellDoubleClicked(BMouseEvent event, int row, int col) {
            JobLogItem item = this.log.getItem(row);
            BTextEditor text = new BTextEditor(item.toString(null), false);
            BTextEditorPane pane = new BTextEditorPane(text, 40, 80);
            BDialog.open((BWidget)this.getTable(), (String)lexLogDetails, (Object)pane, (int)1);
        }
    }

    public class JobLogTable
    extends TableModel {
        int count;
        JobLogItem[] items;
        String[] messages;
        String[] details;

        public JobLogTable(JobLog log) {
            this.items = log.getItems();
            this.messages = new String[this.items.length];
            this.details = new String[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                this.messages[i] = this.str(this.items[i].getMessage(null));
                this.details[i] = this.str(this.items[i].getDetails(null));
            }
        }

        String str(String s) {
            if (s == null) {
                return "";
            }
            int n = s.indexOf(10);
            if (n < 0) {
                return s;
            }
            return s.substring(0, n);
        }

        public int getRowCount() {
            return this.items.length;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return lexStatus;
                }
                case 1: {
                    return lexTimestamp;
                }
                case 2: {
                    return lexMessage;
                }
                case 3: {
                    return lexDetails;
                }
            }
            return "???";
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.items[row].getIdString(null);
                }
                case 1: {
                    return this.items[row].getTimestamp();
                }
                case 2: {
                    return this.messages[row];
                }
                case 3: {
                    return this.details[row];
                }
            }
            return "???";
        }

        public Object getSubject(int row) {
            return this.items[row];
        }

        public BObject export(int row, int col) {
            switch (col) {
                case 0: {
                    return this.export(this.items[row].getIdString(null));
                }
                case 1: {
                    return this.items[row].getTimestamp();
                }
                case 2: {
                    return this.export(this.items[row].getMessage(null));
                }
                case 3: {
                    return this.export(this.items[row].getDetails(null));
                }
            }
            return BString.DEFAULT;
        }

        BString export(String s) {
            if (s == null) {
                return BString.DEFAULT;
            }
            return BString.make((String)s);
        }

        public BImage getRowIcon(int row) {
            return BJobBar.itemToIcon(this.items[row]);
        }
    }

    class Log
    extends Command {
        public Log(BWidget owner) {
            super(owner, lexLog);
        }

        public String getLabel() {
            return null;
        }

        public BImage getIcon() {
            return logIcon;
        }

        public CommandArtifact doInvoke() throws Exception {
            JobLog log = JobLog.decode((String)BJobBar.this.job.readLog().toString());
            BTable table = new BTable((TableModel)new JobLogTable(log), (TableController)new JobLogController(log));
            BConstrainedPane pane = new BConstrainedPane((BWidget)table);
            pane.setFixedSize(800.0, 400.0);
            BDialog.open((BWidget)this.getOwner(), (String)lexJobLog, (Object)pane, (int)1);
            return null;
        }
    }

    class Dispose
    extends Command {
        public Dispose(BWidget owner) {
            super(owner, lexDispose);
        }

        public String getLabel() {
            return null;
        }

        public BImage getIcon() {
            return disposeIcon;
        }

        public CommandArtifact doInvoke() {
            this.setEnabled(false);
            BJobBar.this.job.dispose();
            return null;
        }
    }

    class Cancel
    extends Command {
        public Cancel(BWidget owner) {
            super(owner, lexCancel);
        }

        public String getLabel() {
            return null;
        }

        public BImage getIcon() {
            return cancelIcon;
        }

        public CommandArtifact doInvoke() {
            BJobBar.this.job.cancel();
            return null;
        }
    }
}

