/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.ord;

import com.tridium.workbench.ord.RefFilter;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.virtual.BVirtualGateway;

public class RefNode {
    public static final BImage propertyIcon = BImage.make((String)"module://icons/x16/object.png");
    public static final BImage actionIcon = BImage.make((String)"module://icons/x16/shapes/circleGreen.png");
    public static final BImage topicIcon = BImage.make((String)"module://icons/x16/shapes/circleGold.png");
    public BObject parent = null;
    public Slot slot = null;
    public BObject object;
    public String name = "";
    public String text = "?";
    public BImage icon = propertyIcon;
    public boolean isLeaf = false;

    public RefNode(BComplex object) {
        this.parent = object.getParent();
        this.slot = object.getPropertyInParent();
        this.object = object;
        this.name = object.getName();
        this.text = object.getDisplayName(null);
        this.icon = BImage.make((BIcon)object.getIcon());
        this.isLeaf = object.isSimple();
        if (this.icon == null) {
            this.icon = propertyIcon;
        }
    }

    public RefNode(BComplex parent, Slot slot) {
        this.name = slot.getName();
        this.text = parent.getDisplayName(slot, null);
        this.parent = parent;
        this.slot = slot;
        if (slot.isProperty()) {
            this.object = parent.get(slot.asProperty());
            this.icon = BImage.make((BIcon)this.object.getIcon());
            if (this.icon == null) {
                this.icon = propertyIcon;
            }
            this.isLeaf = this.object.isSimple();
        } else if (slot.isAction()) {
            this.object = null;
            this.icon = actionIcon;
            this.isLeaf = true;
        } else {
            this.object = null;
            this.icon = topicIcon;
            this.isLeaf = true;
        }
    }

    public RefNode[] getChildren(RefFilter filter) {
        BComponent root;
        BVirtualGateway gateway;
        BComponentSpace vSpace;
        ArrayList<RefNode> kids = new ArrayList<RefNode>();
        if (this.object instanceof BComplex) {
            BComplex complex = (BComplex)this.object;
            complex.loadSlots();
            SlotCursor c = complex.getSlots();
            while (c.next()) {
                Slot slot = c.slot();
                if (Flags.isHidden((BComplex)complex, (Slot)slot) || !filter.accept(this.object, slot)) continue;
                kids.add(new RefNode(complex, slot));
            }
        }
        if (this.object instanceof BVirtualGateway && (vSpace = (gateway = (BVirtualGateway)this.object).getVirtualSpace()) != null && (root = vSpace.getRootComponent()) != null) {
            root.loadSlots();
            SlotCursor c = root.getSlots();
            while (c.next()) {
                Slot slot = c.slot();
                if (Flags.isHidden((BComplex)root, (Slot)slot) || !filter.accept(this.object, slot)) continue;
                kids.add(new RefNode((BComplex)root, slot));
            }
        }
        return kids.toArray(new RefNode[0]);
    }
}

