/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.pathbar;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.auth.BCnxHandler;
import com.tridium.workbench.pathbar.BPathBarAgent;
import com.tridium.workbench.pathbar.BPathBarButton;
import com.tridium.workbench.pathbar.BPathBarGridPane;
import com.tridium.workbench.pathbar.BPathBarTextField;
import com.tridium.workbench.pathbar.PathBarHyperlinkCommand;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridium.workbench.shell.BViewTab;
import com.tridium.workbench.util.IProgressReporter;
import java.util.ArrayList;
import javax.baja.agent.AgentInfo;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavFileNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.style.IStylable;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.menu.NavMenuUtil;

@NiagaraType
public class BPathBar
extends BEdgePane {
    @Generated
    public static final Type TYPE = Sys.loadType(BPathBar.class);
    private static final BImage errIcon = BImage.make((String)"module://icons/x16/whiteIcons/error.png");
    private static final int menuLimit = 30;
    public final BNiagaraWbShell shell;
    private BINavNode root;
    private BPathBarButton[] buttons;
    private BPathBarTextField field;
    private BBorderPane fieldContainer;
    private BViewTab tab;
    private BWidget view;
    private boolean restrictToNavFile;
    private boolean showViewMenu = true;
    private boolean editMode;
    private BBorderPane centerContainer;
    private BBorderPane rightContainer;
    private Command editCmd;
    private static final BImage VERT_SEP = BImage.make((BIcon)BIcon.std((String)"whiteIcons/vertSep.png"));

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPathBar() {
        throw new IllegalStateException();
    }

    public BPathBar(BNiagaraWbShell shell) {
        this.shell = shell;
    }

    public void setRestrictToNavFile(boolean v) {
        this.restrictToNavFile = v;
    }

    public void setShowViewMenu(boolean v) {
        this.showViewMenu = v;
    }

    public void computePreferredSize() {
        if (this.buttons == null) {
            this.setPreferredSize(200.0, 26.0);
        } else {
            super.computePreferredSize();
        }
    }

    private static String toCompressedText(BPathBarButton button) {
        String text = button.text;
        if (text == null || !Theme.javaFx().shouldHideNonessentialIcons()) {
            return "";
        }
        if (text.length() > 3) {
            return text.substring(0, Math.min(text.length() - 3, 3)) + "...";
        }
        return text;
    }

    public void doLayout(BWidget[] kids) {
        if (this.buttons != null) {
            for (BPathBarButton button : this.buttons) {
                if (button == null) continue;
                button.reset();
            }
        }
        super.doLayout(kids);
        if (this.buttons == null) {
            return;
        }
        BWidget center = this.getCenter();
        BWidget right = this.getRight();
        center.computePreferredSize();
        right.computePreferredSize();
        double w = this.getWidth() - 5.0;
        double pw = center.getPreferredWidth() + right.getPreferredWidth();
        int i = 0;
        while (pw > w && i < this.buttons.length - 1) {
            if (this.buttons[i] == null) continue;
            this.buttons[i].computePreferredSize();
            double dw = this.buttons[i].getPreferredWidth();
            this.buttons[i].setText(BPathBar.toCompressedText(this.buttons[i]));
            this.buttons[i].computePreferredSize();
            pw -= dw - this.buttons[i].getPreferredWidth();
            ++i;
        }
        center.layout();
    }

    public void paint(Graphics g) {
        Theme.pane().paintBackground(g, (BPane)this);
        double w = this.getWidth() - 1.0;
        double h = this.getHeight() - 1.0;
        double x = w;
        if (this.showViewMenu && this.view != null) {
            x = w - this.view.getWidth() - 2.0;
        }
        this.paintProgressBar(g, x, h);
        this.paintChildren(g);
        BBrush background = Theme.pathBar().getControlBackground((IStylable)this);
        BBrush highlight = Theme.pathBar().getControlHighlight((IStylable)this);
        BBrush shadow = Theme.pathBar().getControlShadow((IStylable)this);
        BBrush outline = Theme.pathBar().getControlForeground((IStylable)this);
        g.setBrush(highlight);
        g.strokeLine(0.0, h, w, h);
        g.strokeLine(w, 0.0, w, h);
        g.setBrush(shadow);
        g.strokeLine(0.0, 0.0, w, 0.0);
        g.strokeLine(0.0, 0.0, 0.0, h);
        g.setBrush(outline);
        g.strokeRect(1.0, 1.0, w - 2.0, h - 2.0);
        if (this.showViewMenu && this.view != null) {
            g.setBrush(background);
            g.fillRect(x - 3.0, 0.0, 3.0, h);
            g.setBrush(outline);
            g.strokeLine(x, 1.0, x, h - 1.0);
            g.strokeLine(x - 4.0, 1.0, x - 4.0, h - 1.0);
            g.setBrush(highlight);
            g.strokeLine(x - 3.0, 1.0, x - 3.0, h);
            g.setBrush(shadow);
            g.strokeLine(x - 1.0, 0.0, x - 1.0, h);
        }
    }

    private void paintProgressBar(Graphics g, double pathBarWidth, double pathBarHeight) {
        if (this.editMode) {
            return;
        }
        if (this.tab != null && this.tab.getView() instanceof IProgressReporter) {
            double dx = 1.0;
            double dy = 1.0;
            IProgressReporter progressReporter = (IProgressReporter)((Object)this.tab.getView());
            double progressWidth = (pathBarWidth - 2.0 * dx) * progressReporter.getProgress() / 100.0;
            double progressHeight = pathBarHeight - 2.0 * dy;
            BBrush progressBrush = Theme.pathBar().getProgressBrush((IStylable)this);
            g.setBrush(progressBrush);
            g.fillRect(dx, dy, progressWidth, progressHeight);
        }
    }

    public String getStyleSelector() {
        return "path-bar";
    }

    public void update(BViewTab tab) {
        BPathBarButton b;
        if (this.root == null) {
            BOrd ord = this.shell.getProfile().getNavRootOrd();
            this.root = (BINavNode)ord.resolve().get();
        }
        this.tab = tab;
        this.buttons = null;
        BPathBarAgent[] pa = tab.getPathBarAgents();
        BOrd ord = tab.getOrd();
        if (tab.getTarget() == null || pa == null) {
            this.setToError(ord);
            return;
        }
        String viewText = "";
        BImage viewIcon = errIcon;
        if (tab.getView() != null) {
            AgentInfo agent = tab.getViewAgent();
            viewText = agent.getDisplayName(null);
            viewIcon = BImage.make((BIcon)agent.getIcon(null));
        }
        if (Theme.javaFx().shouldHideNonessentialIcons()) {
            viewIcon = null;
        }
        BPathBarButton viewButton = new BPathBarButton(this.shell, viewIcon, viewText);
        viewButton.setMenuController(new ViewController());
        viewButton.setPinArrow(true);
        this.view = viewButton;
        ArrayList<BPathBarButton> list = new ArrayList<BPathBarButton>();
        for (int i = 0; i < pa.length; ++i) {
            if (this.root != null && this.root != BNavRoot.INSTANCE) {
                try {
                    BINavNode nav;
                    for (nav = pa[i].nav(); nav != null && nav != this.root; nav = nav.getNavParent()) {
                    }
                    if (nav == null) {
                        continue;
                    }
                }
                catch (Exception e) {
                    break;
                }
            }
            if (this.restrictToNavFile && pa[i].nav() instanceof BISession) continue;
            BImage agentIcon = Theme.javaFx().shouldHideNonessentialIcons() ? (i > 0 ? VERT_SEP : null) : pa[i].getAgentIcon();
            b = new BPathBarButton(this.shell, agentIcon, pa[i].getAgentText());
            if (this.root != null && this.root != BNavRoot.INSTANCE && this.root == pa[i].nav()) {
                if (!this.restrictToNavFile || this.restrictToNavFile && pa[i].nav() instanceof BNavFileNode) {
                    b.setPinArrow(true);
                    b.setMenuController(new AgentController(pa[i]));
                } else {
                    b.setEnabled(false);
                }
            } else {
                BOrd navord = pa[i].getAgentOrd();
                if (navord != null && !navord.isNull()) {
                    b.setCommand(new PathBarHyperlinkCommand((BWidget)this.shell, null, null, navord));
                }
                if (!this.restrictToNavFile || this.restrictToNavFile && pa[i].nav() instanceof BNavFileNode) {
                    if (i == 0) {
                        b.setMenuController(new HostController());
                    } else {
                        b.setMenuController(new AgentController(pa[i]));
                    }
                } else {
                    b.setEnabled(false);
                }
            }
            list.add(b);
        }
        if (list.isEmpty()) {
            this.setToError(ord);
            return;
        }
        this.buttons = new BPathBarButton[list.size()];
        BPathBarGridPane grid = new BPathBarGridPane(this, list.size());
        grid.setColumnGap(0.0);
        grid.setHalign(BHalign.left);
        for (int i = 0; i < list.size(); ++i) {
            this.buttons[i] = b = (BPathBarButton)((Object)list.get(i));
            grid.add(null, (BValue)b);
        }
        this.setContents((BWidget)grid, this.showViewMenu ? viewButton : new BNullWidget());
    }

    private void setToError(BOrd ord) {
        this.view = null;
        BLabel err = new BLabel(errIcon, String.valueOf(ord));
        err.setForeground(BColor.white.toBrush());
        err.setHalign(BHalign.left);
        BPathBarGridPane grid = new BPathBarGridPane(this, 0);
        grid.add(null, (BValue)new BBorderPane((BWidget)err, 0.0, 0.0, 0.0, 5.0));
        grid.setHalign(BHalign.left);
        this.setContents((BWidget)grid, (BWidget)new BNullWidget());
    }

    private void setContents(BWidget center, BWidget right) {
        if (this.editMode) {
            return;
        }
        if (this.centerContainer != null && this.rightContainer != null) {
            this.centerContainer.setContent(center);
            this.rightContainer.setContent(right);
            return;
        }
        BEdgePane centerEp = new BEdgePane();
        this.centerContainer = new BBorderPane(center, 2.0, 0.0, 2.0, 2.0);
        centerEp.setCenter((BWidget)this.centerContainer);
        BButton btn = new BButton(BImage.make((BIcon)BIcon.std((String)"whiteIcons/edit.png")));
        btn.setButtonStyle(BButtonStyle.toolBar);
        this.editCmd = new EditPathCmd((BWidget)btn, "Edit Path");
        btn.setCommand(this.editCmd, false, false);
        centerEp.setRight((BWidget)new BBorderPane((BWidget)btn, 2.0, 6.0, 2.0, 0.0));
        this.setCenter((BWidget)centerEp);
        this.rightContainer = new BBorderPane(right, 2.0, 2.0, 2.0, 0.0);
        this.setRight((BWidget)this.rightContainer);
    }

    void enterEditMode() {
        this.editMode = true;
        if (this.editCmd != null) {
            this.editCmd.setEnabled(false);
        }
        BPathBarTextField bPathBarTextField = this.field = this.field == null ? new BPathBarTextField(this) : this.field;
        if (this.centerContainer != null) {
            this.centerContainer.setContent((BWidget)this.field);
            this.field.setText(this.tab.getOrd().toString());
            this.field.requestFocus();
        }
    }

    void exitEditMode() {
        this.editMode = false;
        if (this.editCmd != null) {
            this.editCmd.setEnabled(true);
        }
    }

    private static BMenu makeRootMenu(BNiagaraWbShell shell) {
        BINavNode[] children;
        BMenu menu = new BMenu();
        for (BINavNode child : children = BNavRoot.INSTANCE.getNavChildren()) {
            if (child instanceof BHost) {
                BINavNode[] kids;
                BMenu sub = new BMenu(child.getNavDisplayName(null));
                for (BINavNode kid : kids = child.getNavChildren()) {
                    sub.add(null, (Command)new PathBarHyperlinkCommand((BWidget)shell, Theme.javaFx().shouldHideNonessentialIcons() ? null : BImage.make((BIcon)kid.getNavIcon()), kid.getNavDisplayName(null), kid.getNavOrd()));
                }
                BPathBar.makeHostSubMenu((BWidget)shell, menu, child, sub, kids);
                continue;
            }
            menu.add(null, (Command)new PathBarHyperlinkCommand((BWidget)shell, Theme.javaFx().shouldHideNonessentialIcons() ? null : BImage.make((BIcon)child.getNavIcon()), child.getNavDisplayName(null), child.getNavOrd()));
        }
        menu.add(null, (BValue)new BSeparator());
        menu.add(null, shell.commands.findStations);
        return menu;
    }

    private static void makeHostSubMenu(BWidget owner, BMenu menu, BINavNode child, BMenu sub, BINavNode[] kids) {
        Command[] sessionOpens = BCnxHandler.getCnxCommands(owner, (BHost)child);
        for (int k = 0; k < sessionOpens.length; ++k) {
            if (k == 0 && kids.length > 0) {
                sub.add(null, (BValue)new BSeparator());
            }
            sub.add(null, sessionOpens[k]);
        }
        BSubMenuItem item = new BSubMenuItem((BIMenu)sub);
        if (!Theme.javaFx().shouldHideNonessentialIcons()) {
            item.setImage(BImage.make((BIcon)child.getNavIcon()));
        }
        menu.add(null, (BValue)item);
    }

    private static BMenu makeAgentMenu(BNiagaraWbShell shell, BPathBarAgent agent) {
        int i;
        BINavNode[] kids = agent.getChildren();
        Command[] cmds = agent.getCommands(shell);
        if (kids == null && cmds == null) {
            return null;
        }
        BMenu menu = new BMenu();
        if (kids != null) {
            BMenu sub;
            for (i = 0; i < 30 && i < kids.length; ++i) {
                BINavNode kid = kids[i];
                if (kid instanceof BHost) {
                    sub = new BMenu(kid.getNavDisplayName(null));
                    sub.add(null, (Command)new PathBarHyperlinkCommand((BWidget)shell, Theme.javaFx().shouldHideNonessentialIcons() ? null : BImage.make((BIcon)kid.getNavIcon()), kid.getNavDisplayName(null), kid.getNavOrd()));
                    BPathBar.makeHostSubMenu((BWidget)shell, menu, kid, sub, kids);
                    continue;
                }
                menu.add(null, (Command)new PathBarHyperlinkCommand((BWidget)shell, Theme.javaFx().shouldHideNonessentialIcons() ? null : BImage.make((BIcon)kids[i].getNavIcon()), kids[i].getNavDisplayName(null), kids[i].getNavOrd()));
            }
            BMenu prev = menu;
            while (i < kids.length - 1) {
                sub = BPathBar.makeSubMenu(shell, kids, i);
                prev.add(null, (BValue)new BSubMenuItem((BIMenu)sub));
                prev = sub;
                i += 30;
            }
        }
        if (cmds != null) {
            for (i = 0; i < cmds.length; ++i) {
                if (i == 0 && kids != null) {
                    menu.add(null, (BValue)new BSeparator());
                }
                menu.add(null, cmds[i]);
            }
        }
        return menu;
    }

    private static BMenu makeSubMenu(BWbShell shell, BINavNode[] kids, int start) {
        BMenu menu = new BMenu("More");
        for (int i = start; i < start + 30 && i < kids.length; ++i) {
            menu.add(null, (Command)new PathBarHyperlinkCommand((BWidget)shell, BImage.make((BIcon)kids[i].getNavIcon()), kids[i].getNavDisplayName(null), kids[i].getNavOrd()));
        }
        return menu;
    }

    class ViewController
    implements BPathBarButton.MenuController {
        ViewController() {
        }

        @Override
        public BMenu getMenu() {
            return NavMenuUtil.makeViewsMenu((BWidget)BPathBar.this, BPathBar.this.tab.getTarget().get(), BPathBar.this.tab.getOrd());
        }
    }

    class AgentController
    implements BPathBarButton.MenuController {
        private final BPathBarAgent agent;

        public AgentController(BPathBarAgent agent) {
            this.agent = agent;
        }

        @Override
        public BMenu getMenu() {
            return BPathBar.makeAgentMenu(BPathBar.this.shell, this.agent);
        }
    }

    class HostController
    implements BPathBarButton.MenuController {
        HostController() {
        }

        @Override
        public BMenu getMenu() {
            return BPathBar.makeRootMenu(BPathBar.this.shell);
        }
    }

    private class EditPathCmd
    extends Command {
        public EditPathCmd(BWidget owner, String label) {
            super(owner, label);
        }

        public CommandArtifact doInvoke() throws Exception {
            BPathBar.this.enterEditMode();
            return super.doInvoke();
        }
    }
}

