/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.pathbar;

import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.pathbar.PathBarHyperlinkCommand;
import com.tridium.workbench.shell.BNiagaraWbShell;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.Insets;
import javax.baja.gx.Point;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.style.IStylable;

@NiagaraType
public class BPathBarButton
extends BWidget
implements BMenu.MenuCloseListener {
    @Generated
    public static final Type TYPE = Sys.loadType(BPathBarButton.class);
    private static final BBrush shadow = BColor.make((int)0x333333).toBrush();
    private static final Insets insets = new Insets(3.0, 4.0, 3.0, 4.0);
    private static final int pad = 3;
    private static final int arrow = 10;
    private BNiagaraWbShell shell;
    private BImage icon;
    String text;
    private String reset;
    private Command command;
    private MenuController menu;
    private BMenu last;
    private boolean pinArrow = false;
    private boolean doCommand = true;
    private Point iconPt = new Point();
    private Point textPt = new Point();
    private boolean over = false;
    private boolean down = false;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPathBarButton() {
    }

    public BPathBarButton(BNiagaraWbShell shell, BImage icon, String text) {
        this.shell = shell;
        this.icon = icon;
        this.text = text;
        this.reset = text;
    }

    public void setIcon(BImage icon) {
        this.icon = icon;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public void setPinArrow(boolean b) {
        this.pinArrow = b;
    }

    public void setMenuController(MenuController menu) {
        this.menu = menu;
    }

    public void reset() {
        this.text = this.reset;
    }

    public void computePreferredSize() {
        double w = BPathBarButton.insets.left + BPathBarButton.insets.right;
        double h = 0.0;
        if (this.icon != null) {
            w += this.icon.getWidth();
            h += this.icon.getHeight();
        }
        if (this.text != null) {
            BFont font = Theme.pathBar().getTextFont((IStylable)this);
            w += font.width(this.text);
            w += 13.0;
            h = Math.max(h, font.getHeight());
        }
        if (this.icon != null && this.text != null) {
            w += 3.0;
        }
        this.setPreferredSize(w, h += BPathBarButton.insets.top + BPathBarButton.insets.bottom);
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth() - (BPathBarButton.insets.left + BPathBarButton.insets.right);
        double h = this.getHeight() - (BPathBarButton.insets.top + BPathBarButton.insets.bottom);
        BFont font = Theme.widget().getTextFont((IStylable)this);
        double dw = w;
        if (this.icon != null) {
            dw -= this.icon.getWidth();
        }
        if (this.text != null) {
            dw -= font.width(this.text);
        }
        if (this.menu != null) {
            dw -= 13.0;
        }
        if (this.icon != null && this.text != null) {
            dw -= 3.0;
        }
        if (this.icon != null) {
            this.iconPt.x = dw / 2.0;
            this.iconPt.y = (h - this.icon.getHeight()) / 2.0;
        }
        if (this.text != null) {
            this.textPt.x = this.icon == null ? dw / 2.0 : this.iconPt.x + this.icon.getWidth() + 3.0;
            this.textPt.y = (h - font.getHeight()) / 2.0;
            this.textPt.y += font.getAscent();
        }
    }

    public void paint(Graphics g) {
        BBrush background = Theme.pathBar().getControlBackground((IStylable)this);
        BBrush outline = Theme.pathBar().getControlForeground((IStylable)this);
        BBrush highlight = Theme.pathBar().getControlHighlight((IStylable)this);
        BBrush shadow = Theme.pathBar().getControlShadow((IStylable)this);
        double w = this.getWidth() - 1.0;
        double h = this.getHeight() - 1.0;
        double dx = BPathBarButton.insets.left;
        double dy = BPathBarButton.insets.top;
        if (this.over) {
            g.setBrush(background);
            g.fillRect(0.0, 0.0, w, h);
            if (this.command != null && this.menu != null) {
                double aw = 13.0 + BPathBarButton.insets.right - 3.0;
                if (this.down) {
                    aw -= 1.0;
                }
                g.setBrush(shadow);
                g.strokeLine(w - aw, 0.0, w - aw, h);
                if (!this.down) {
                    g.setBrush(background);
                    g.strokeLine(w - aw + 1.0, 0.0, w - aw + 1.0, h);
                }
            }
            g.setBrush(this.down ? shadow : highlight);
            g.strokeLine(0.0, 0.0, w, 0.0);
            g.strokeLine(0.0, 0.0, 0.0, h);
            g.setBrush(shadow);
            g.strokeLine(0.0, h, w, h);
            g.strokeLine(w, 0.0, w, h);
            if (this.down) {
                dx += 1.0;
                dy += 1.0;
            }
        }
        g.translate(dx, dy);
        if (this.icon != null) {
            g.drawImage(this.icon, this.iconPt.x, this.iconPt.y);
        }
        if (this.text != null) {
            g.setBrush(Theme.pathBar().getTextBrush((IStylable)this));
            g.setFont(Theme.pathBar().getTextFont((IStylable)this));
            g.drawString(this.text, this.textPt.x, this.textPt.y);
            if (this.menu != null && (this.over || this.pinArrow)) {
                int arrowWidth = 3;
                int mid = (int)(w - BPathBarButton.insets.right - (double)arrowWidth - 4.0);
                int bottom = 0 + arrowWidth + ((int)h - (int)BPathBarButton.insets.bottom - arrowWidth) / 2 - 1;
                for (int i = 0; i < arrowWidth; ++i) {
                    g.strokeLine((double)(mid - i), (double)(bottom - i), (double)(mid + i), (double)(bottom - i));
                }
            }
        }
        g.translate(-dx, -dy);
    }

    public String getStyleSelector() {
        return "path-bar";
    }

    public void mousePressed(BMouseEvent event) {
        this.doCommand = true;
        this.down = true;
        this.repaint();
        if (this.menu != null && (this.command == null || event.getX() > this.getWidth() - (13.0 + BPathBarButton.insets.right - 2.0))) {
            this.doCommand = false;
            this.last = this.menu.getMenu();
            if (this.last != null) {
                this.last.open((BWidget)this, 0.0, this.getHeight() + 1.0);
            }
        }
    }

    public void mouseReleased(BMouseEvent event) {
        if (this.last != null && this.last.isOpen()) {
            return;
        }
        this.down = false;
        this.repaint();
        if (this.over && this.command != null && this.doCommand) {
            if (this.command instanceof PathBarHyperlinkCommand) {
                BHyperlinkMode mode = event.isControlDown() ? BHyperlinkMode.newTab : BHyperlinkMode.replace;
                ((PathBarHyperlinkCommand)this.command).setMode(mode);
            }
            this.command.invoke();
        }
    }

    public void mouseEntered(BMouseEvent event) {
        this.over = true;
        this.repaint();
    }

    public void mouseExited(BMouseEvent event) {
        UiEnv.get().closeBubbleHelp();
        if (this.last != null && this.last.isOpen()) {
            return;
        }
        this.over = false;
        this.repaint();
    }

    public void mouseHover(BMouseEvent event) {
        Point pt = new Point(event.getX(), event.getY());
        pt.y = Math.max(this.getHeight() + 1.0, pt.y + 16.0);
        UiEnv.get().openBubbleHelp((BWidget)this, pt.x, pt.y, this.reset);
    }

    public void menuClosed(BMenu menu) {
        this.down = false;
        this.over = false;
        this.repaint();
    }

    public static interface MenuController {
        public BMenu getMenu();
    }
}

