/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.px;

import com.tridium.workbench.px.BOnMediaMigrationError;
import com.tridium.workbench.px.PxFileMediaMigrator;
import com.tridium.workbench.px.PxViewMediaMigrator;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="processFiles", type="boolean", defaultValue="true"), @NiagaraProperty(name="filePath", type="BOrd", defaultValue="BOrd.make(\"file:^\")"), @NiagaraProperty(name="filePathRegex", type="String", defaultValue="\\.px$"), @NiagaraProperty(name="preserveIdentities", type="boolean", defaultValue="false"), @NiagaraProperty(name="processViews", type="boolean", defaultValue="true"), @NiagaraProperty(name="rootViewOrd", type="BOrd", defaultValue="BOrd.make(\"station:|slot:/\")"), @NiagaraProperty(name="skipFrozenViews", type="boolean", defaultValue="true"), @NiagaraProperty(name="onValidationError", type="BOnMediaMigrationError", defaultValue="BOnMediaMigrationError.abort"), @NiagaraProperty(name="mediaType", type="BTypeSpec", defaultValue="BTypeSpec.make(\"uxBuilder:UxMedia\")", facets={@Facet(name="BFacets.TARGET_TYPE", value="\"bajaui:PxMedia\"")})})
@NiagaraActions(value={@NiagaraAction(name="execute"), @NiagaraAction(name="dryRun")})
public class BPxMediaMigrator
extends BComponent {
    @Generated
    public static final Property processFiles = BPxMediaMigrator.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property filePath = BPxMediaMigrator.newProperty((int)0, (BValue)BOrd.make((String)"file:^"), null);
    @Generated
    public static final Property filePathRegex = BPxMediaMigrator.newProperty((int)0, (String)"\\.px$", null);
    @Generated
    public static final Property preserveIdentities = BPxMediaMigrator.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property processViews = BPxMediaMigrator.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property rootViewOrd = BPxMediaMigrator.newProperty((int)0, (BValue)BOrd.make((String)"station:|slot:/"), null);
    @Generated
    public static final Property skipFrozenViews = BPxMediaMigrator.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property onValidationError = BPxMediaMigrator.newProperty((int)0, (BValue)BOnMediaMigrationError.abort, null);
    @Generated
    public static final Property mediaType = BPxMediaMigrator.newProperty((int)0, (BValue)BTypeSpec.make((String)"uxBuilder:UxMedia"), (BFacets)BFacets.make((String)"targetType", (String)"bajaui:PxMedia"));
    @Generated
    public static final Action execute = BPxMediaMigrator.newAction((int)0, null);
    @Generated
    public static final Action dryRun = BPxMediaMigrator.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPxMediaMigrator.class);

    @Generated
    public boolean getProcessFiles() {
        return this.getBoolean(processFiles);
    }

    @Generated
    public void setProcessFiles(boolean v) {
        this.setBoolean(processFiles, v, null);
    }

    @Generated
    public BOrd getFilePath() {
        return (BOrd)this.get(filePath);
    }

    @Generated
    public void setFilePath(BOrd v) {
        this.set(filePath, (BValue)v, null);
    }

    @Generated
    public String getFilePathRegex() {
        return this.getString(filePathRegex);
    }

    @Generated
    public void setFilePathRegex(String v) {
        this.setString(filePathRegex, v, null);
    }

    @Generated
    public boolean getPreserveIdentities() {
        return this.getBoolean(preserveIdentities);
    }

    @Generated
    public void setPreserveIdentities(boolean v) {
        this.setBoolean(preserveIdentities, v, null);
    }

    @Generated
    public boolean getProcessViews() {
        return this.getBoolean(processViews);
    }

    @Generated
    public void setProcessViews(boolean v) {
        this.setBoolean(processViews, v, null);
    }

    @Generated
    public BOrd getRootViewOrd() {
        return (BOrd)this.get(rootViewOrd);
    }

    @Generated
    public void setRootViewOrd(BOrd v) {
        this.set(rootViewOrd, (BValue)v, null);
    }

    @Generated
    public boolean getSkipFrozenViews() {
        return this.getBoolean(skipFrozenViews);
    }

    @Generated
    public void setSkipFrozenViews(boolean v) {
        this.setBoolean(skipFrozenViews, v, null);
    }

    @Generated
    public BOnMediaMigrationError getOnValidationError() {
        return (BOnMediaMigrationError)this.get(onValidationError);
    }

    @Generated
    public void setOnValidationError(BOnMediaMigrationError v) {
        this.set(onValidationError, (BValue)v, null);
    }

    @Generated
    public BTypeSpec getMediaType() {
        return (BTypeSpec)this.get(mediaType);
    }

    @Generated
    public void setMediaType(BTypeSpec v) {
        this.set(mediaType, (BValue)v, null);
    }

    @Generated
    public void execute() {
        this.invoke(execute, null, null);
    }

    @Generated
    public void dryRun() {
        this.invoke(dryRun, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doExecute(Context cx) throws Exception {
        this.doMigration(false, cx);
    }

    public void doDryRun(Context cx) throws Exception {
        this.doMigration(true, cx);
    }

    private static Logger getLogger() {
        return Logger.getLogger("com.tridium.px.editor.util");
    }

    private void doMigration(boolean dryRun, Context cx) {
        if (cx == null) {
            cx = new BasicContext();
        }
        if (this.getProcessFiles()) {
            ((CompletableFuture)this.migrateAllFiles((PxFileMediaMigrator)this.buildFileMigrator().inDryRunMode(dryRun), cx).thenRun(() -> BPxMediaMigrator.getLogger().info("Px file migration " + (dryRun ? "dry run " : "") + "complete"))).exceptionally(e -> {
                BPxMediaMigrator.getLogger().log(Level.SEVERE, "Px file migration failed.", (Throwable)e);
                return null;
            });
        }
        if (this.getProcessViews()) {
            ((CompletableFuture)this.migrateAllViews(this.buildViewMigrator().inDryRunMode(dryRun), cx).thenRun(() -> BPxMediaMigrator.getLogger().info("Px view migration " + (dryRun ? "dry run " : "") + "complete"))).exceptionally(e -> {
                BPxMediaMigrator.getLogger().log(Level.SEVERE, "Px view migration failed.", (Throwable)e);
                return null;
            });
        }
    }

    private CompletableFuture<Void> migrateAllViews(PxViewMediaMigrator migrator, Context cx) {
        return PxViewMediaMigrator.migrateToMedia(migrator, this.getRootViewOrd(), this.getSkipFrozenViews(), cx);
    }

    private CompletableFuture<Void> migrateAllFiles(PxFileMediaMigrator migrator, Context cx) {
        return PxFileMediaMigrator.migrateToMedia(migrator, this.getFilePath(), this.getFilePathRegex(), cx);
    }

    private PxViewMediaMigrator buildViewMigrator() {
        return new PxViewMediaMigrator().toMedia(this.getMediaType()).onValidationError(this.getOnValidationError().getTag());
    }

    private PxFileMediaMigrator buildFileMigrator() {
        return (PxFileMediaMigrator)((PxFileMediaMigrator)new PxFileMediaMigrator().toMedia(this.getMediaType()).preservingIdentities(this.getPreserveIdentities())).onValidationError(this.getOnValidationError().getTag());
    }
}

