/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.ui.theme.Theme;
import com.tridium.util.ThrowableUtil;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BToggleButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;

@NiagaraType
public class BErrorPanel
extends BPane {
    @Generated
    public static final Type TYPE = Sys.loadType(BErrorPanel.class);
    static BFont titleFont = Theme.widget().getLargeBoldFont();
    static BFont ordFont = Theme.widget().getTextFont();
    static BFont messageFont = Theme.widget().getTextFont();
    private BLabel icon;
    private BLabel title;
    private BLabel ord;
    private BLabel message;
    private BButton back;
    private BToggleButton expand;
    private BTextEditorPane details;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BErrorPanel() {
        throw new IllegalStateException();
    }

    public BErrorPanel(BWbShell shell, String msg, BOrd ord, Throwable ex) {
        this(shell, UiLexicon.bajaui().getText("errorPanel.title"), msg, ord, ex);
    }

    public BErrorPanel(BWbShell shell, String titleStr, String msg, BOrd o, Throwable ex) {
        this.icon = new BLabel(BDialog.ERROR_ICON);
        this.title = new BLabel(titleStr);
        this.ord = new BLabel(o != null ? o.toString() : "");
        this.ord.setStyleClasses("trace");
        this.message = new BLabel(msg);
        this.back = new BButton(shell.getBackCommand());
        this.expand = new BToggleButton((ToggleCommand)new DetailsToggle(this), true, false);
        this.details = new BTextEditorPane();
        this.title.setFont(titleFont);
        this.ord.setFont(ordFont);
        this.ord.setForeground(Theme.label().getTextBrush((IStylable)this.ord));
        this.message.setFont(messageFont);
        this.message.setHalign(BHalign.left);
        if (ex == null) {
            this.expand.setVisible(false);
        } else {
            this.details.getEditor().setText(ThrowableUtil.dumpToString((Throwable)ex));
        }
        this.details.setVisible(false);
        this.setStyleClasses("errorPanel");
        this.add("icon", (BValue)this.icon);
        this.add("title", (BValue)this.title);
        this.add("ord", (BValue)this.ord);
        this.add("message", (BValue)this.message);
        this.add("back", (BValue)this.back);
        this.add("expand", (BValue)this.expand);
        this.add("details", (BValue)this.details);
    }

    public void doLayout(BWidget[] kids) {
        double w = this.getWidth();
        double h = this.getHeight();
        this.icon.computePreferredSize();
        this.title.computePreferredSize();
        this.ord.computePreferredSize();
        this.message.computePreferredSize();
        this.back.computePreferredSize();
        this.expand.computePreferredSize();
        double iw = this.icon.getPreferredWidth();
        double ih = this.icon.getPreferredHeight();
        double tw = this.title.getPreferredWidth();
        double th = this.title.getPreferredHeight();
        double ow = this.ord.getPreferredWidth();
        double oh = this.ord.getPreferredHeight();
        double mw = this.message.getPreferredWidth();
        double mh = this.message.getPreferredHeight();
        double bw = this.back.getPreferredWidth();
        double bh = this.back.getPreferredHeight();
        double ew = this.expand.getPreferredWidth();
        double eh = this.expand.getPreferredHeight();
        double border = 10.0;
        double labelh = th + 4.0 + oh + 4.0 + mh;
        double labelx = border + iw + 5.0;
        this.icon.setBounds(border, border + (th + 4.0 + oh - ih) / 2.0, iw, ih);
        this.title.setBounds(labelx, border, tw, th);
        this.ord.setBounds(labelx, border + th + 2.0, ow, oh);
        this.message.setBounds(labelx, border + th + 4.0 + oh + 8.0, mw, mh);
        double butx = labelx;
        double buty = border + labelh + 14.0;
        double buth = Math.max(bh, eh);
        this.back.setBounds(butx, buty, bw, buth);
        this.expand.setBounds(butx + bw + 5.0, buty, ew, buth);
        double detailsy = buty + eh + border;
        double detailsh = h - detailsy - border;
        if (detailsh < 0.0) {
            detailsh = 0.0;
        }
        this.details.setBounds(border, detailsy, w - border - border, detailsh);
    }

    public void paint(Graphics g) {
        double w = this.getWidth();
        double h = this.getHeight();
        g.setBrush(Theme.pane().getControlBackground((IStylable)this));
        g.fillRect(0.0, 0.0, w, h);
        super.paint(g);
        g.setBrush(Theme.pane().getControlForeground((IStylable)this));
        g.strokeRect(1.0, 1.0, w - 3.0, h - 3.0);
        g.setBrush(Theme.pane().getControlHighlight((IStylable)this));
        g.strokeLine(w - 1.0, 0.0, w - 1.0, h);
        g.strokeLine(0.0, h - 1.0, w - 1.0, h - 1.0);
        g.setBrush(Theme.pane().getControlShadow((IStylable)this));
        g.strokeLine(0.0, 0.0, w - 1.0, 0.0);
        g.strokeLine(0.0, 0.0, 0.0, h - 1.0);
    }

    class DetailsToggle
    extends ToggleCommand {
        DetailsToggle(BErrorPanel owner) {
            super((BWidget)owner, UiLexicon.bajaui().getText("dialog.details"));
        }

        public void setSelected(boolean sel) {
            super.setSelected(sel);
            BErrorPanel.this.details.setVisible(sel);
            BErrorPanel.this.relayout();
        }
    }
}

