/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.shell;

import com.tridium.ui.theme.custom.nss.StyleUtils;
import com.tridium.workbench.auth.BCnxConfigPane;
import com.tridium.workbench.shell.BPasswordField;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="okButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="cancelButtonPressed", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()"), @NiagaraAction(name="setModified", parameterType="BWidgetEvent", defaultValue="new BWidgetEvent()")})
public class BPasswordResetDialog
extends BDialog {
    @Generated
    public static final Action okButtonPressed = BPasswordResetDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action cancelButtonPressed = BPasswordResetDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Action setModified = BPasswordResetDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPasswordResetDialog.class);
    private static Lexicon lex = Lexicon.make((String)"workbench");
    private static Lexicon bajaLex = Lexicon.make((String)"baja");
    private static final BImage logo = BImage.make((String)lex.get("cert.x32.icon", "module://icons/x32/lock.png"));
    protected BButton okButton;
    protected BButton cancelButton;
    private BPassword password = null;
    private BPasswordField passwordField = null;
    private BPasswordField confirmField = null;
    private BPasswordStrength strength = null;
    private String errMsg = null;

    @Generated
    public void okButtonPressed(BWidgetEvent parameter) {
        this.invoke(okButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public void cancelButtonPressed(BWidgetEvent parameter) {
        this.invoke(cancelButtonPressed, (BValue)parameter, null);
    }

    @Generated
    public void setModified(BWidgetEvent parameter) {
        this.invoke(setModified, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BPassword open(BWidget owner, BPasswordStrength strength, String errMsg) {
        BPasswordResetDialog dialog = new BPasswordResetDialog(owner, strength, errMsg);
        dialog.setBoundsCenteredOnOwner();
        dialog.setResizable(false);
        dialog.open();
        return dialog.getPassword();
    }

    private BPasswordResetDialog(BWidget owner, BPasswordStrength strength, String errMsg) {
        super(owner, "Reset Password", true);
        this.errMsg = errMsg;
        this.strength = strength;
        this.setContent(this.buildDialog());
        this.setDefaultButton(this.okButton);
        try {
            strength.isPasswordValid("");
            this.okButton.setEnabled(true);
        }
        catch (Exception e) {
            this.okButton.setEnabled(false);
        }
    }

    private BWidget buildDialog() {
        BEdgePane dialogPane = new BEdgePane();
        dialogPane.setTop(this.buildHeader());
        dialogPane.setCenter(this.buildContent());
        return dialogPane;
    }

    private BWidget buildHeader() {
        return new BWizardHeader(BCnxConfigPane.logo, this.getTitle(), "Set new account password");
    }

    private BWidget buildContent() {
        BGridPane contentPane = new BGridPane(1);
        contentPane.setHalign(BHalign.fill);
        contentPane.setColumnAlign(BHalign.fill);
        BGridPane infoPane = new BGridPane(1);
        infoPane.setHalign(BHalign.fill);
        infoPane.setColumnAlign(BHalign.fill);
        if (this.errMsg != null) {
            BLabel errLabel = new BLabel(this.errMsg, BHalign.left);
            StyleUtils.addStyleClass((IStylable)errLabel, (String)"error");
            infoPane.add(null, (BValue)errLabel);
        }
        infoPane.add(null, (BValue)new BLabel(bajaLex.getText("user.password.change.message"), BHalign.left));
        String rules = this.getPasswordRulesMessage();
        if (rules.length() > 0) {
            infoPane.add(null, (BValue)new BLabel(bajaLex.getText("user.password.notStrong"), BHalign.left));
            infoPane.add(null, (BValue)new BLabel(rules, BHalign.left));
        }
        contentPane.add(null, (BValue)new BBorderPane((BWidget)infoPane, 0.0, 0.0, 7.0, 0.0));
        contentPane.add(null, (BValue)this.buildBody());
        contentPane.add(null, (BValue)this.buildButtons());
        return new BBorderPane((BWidget)contentPane, 7.0, 30.0, 7.0, 30.0);
    }

    private BWidget buildBody() {
        BGridPane grid = new BGridPane(2);
        grid.setRowGap(5.0);
        grid.setColumnGap(5.0);
        grid.setColumnAlign(BHalign.left);
        grid.setStretchColumn(1);
        grid.add(null, (BValue)new BLabel(lex.get("password.field.password", "Password")));
        this.passwordField = new BPasswordField();
        grid.add(null, (BValue)this.passwordField);
        grid.add(null, (BValue)new BLabel(lex.get("password.field.confirm", "Confirm")));
        this.confirmField = new BPasswordField();
        grid.add(null, (BValue)this.confirmField);
        this.linkTo(null, (BComponent)this.passwordField, (Slot)BPasswordField.textModified, (Slot)setModified);
        this.linkTo(null, (BComponent)this.confirmField, (Slot)BPasswordField.textModified, (Slot)setModified);
        return grid;
    }

    private String getPasswordRulesMessage() {
        StringBuilder buf = new StringBuilder();
        if (this.strength.getMinimumLength() > 0) {
            buf.append(" - ").append(bajaLex.getText("user.password.notLongEnough", new Object[]{this.strength.getMinimumLength() + ""})).append("\n");
        }
        if (this.strength.getMinimumDigits() > 0) {
            buf.append(" - ").append(bajaLex.getText("user.password.notEnoughDigits", new Object[]{this.strength.getMinimumDigits() + ""})).append("\n");
        }
        if (this.strength.getMinimumLowerCase() > 0) {
            buf.append(" - ").append(bajaLex.getText("user.password.notEnoughLowerCase", new Object[]{this.strength.getMinimumLowerCase() + ""})).append("\n");
        }
        if (this.strength.getMinimumUpperCase() > 0) {
            buf.append(" - ").append(bajaLex.getText("user.password.notEnoughUpperCase", new Object[]{this.strength.getMinimumUpperCase() + ""})).append("\n");
        }
        if (this.strength.getMinimumSpecial() > 0) {
            buf.append(" - ").append(bajaLex.getText("user.password.notEnoughSpecial", new Object[]{this.strength.getMinimumSpecial() + ""})).append("\n");
        }
        if (this.strength.getMaximumLength() < Integer.MAX_VALUE) {
            buf.append(" - ").append(bajaLex.getText("user.password.notShortEnough", new Object[]{String.valueOf(this.strength.getMaximumLength())})).append('\n');
        }
        return buf.toString();
    }

    private BWidget buildButtons() {
        BGridPane buttonPane = new BGridPane(2);
        buttonPane.setColumnAlign(BHalign.fill);
        buttonPane.setUniformColumnWidth(true);
        this.okButton = new BButton(UiLexicon.bajaui().getText("dialog.ok"));
        buttonPane.add(null, (BValue)this.okButton);
        this.linkTo("linkA", (BComponent)this.okButton, (Slot)BButton.actionPerformed, (Slot)okButtonPressed);
        this.okButton.setEnabled(false);
        this.cancelButton = new BButton(UiLexicon.bajaui().getText("dialog.cancel"));
        buttonPane.add(null, (BValue)this.cancelButton);
        this.linkTo("linkC", (BComponent)this.cancelButton, (Slot)BButton.actionPerformed, (Slot)cancelButtonPressed);
        return new BBorderPane((BWidget)buttonPane, 7.0, 0.0, 0.0, 0.0);
    }

    public void windowClosing(BWindowEvent event) {
        this.close();
    }

    public BPassword getPassword() {
        return this.password;
    }

    public void doOkButtonPressed(BWidgetEvent event) throws Exception {
        this.password = BPassword.make((String)this.confirmField.getText());
        this.close();
    }

    public void doCancelButtonPressed(BWidgetEvent event) {
        this.close();
    }

    public void doSetModified(BWidgetEvent event) {
        try {
            if (this.passwordField.getText().equals(this.confirmField.getText()) && this.isStrongPassword(this.passwordField.getText())) {
                this.okButton.setEnabled(true);
            } else {
                this.okButton.setEnabled(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isStrongPassword(String pwd) {
        try {
            this.strength.isPasswordValid(pwd);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

